"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChildElementIndentation = void 0;
const schematics_1 = require("@angular-devkit/schematics");
/** Determines the indentation of child elements for the given Parse5 element. */
function getChildElementIndentation(element) {
    const childElement = element.childNodes.find(node => node.tagName);
    if ((childElement && !childElement.sourceCodeLocation) || !element.sourceCodeLocation) {
        throw new schematics_1.SchematicsException('Cannot determine child element indentation because the ' +
            'specified Parse5 element does not have any source code location metadata.');
    }
    const startColumns = childElement
        ? // In case there are child elements inside of the element, we assume that their
            // indentation is also applicable for other child elements.
            childElement.sourceCodeLocation.startCol
        : // In case there is no child element, we just assume that child elements should be indented
            // by two spaces.
            element.sourceCodeLocation.startCol + 2;
    // Since Parse5 does not set the `startCol` properties as zero-based, we need to subtract
    // one column in order to have a proper zero-based offset for the indentation.
    return startColumns - 1;
}
exports.getChildElementIndentation = getChildElementIndentation;
//# sourceMappingURL=data:application/json;base64,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