/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { bootstrapApplication, BrowserModule, createApplication, platformBrowser, provideProtractorTestingSupport } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { BrowserTransferStateModule, makeStateKey, TransferState } from './browser/transfer_state';
export { By } from './dom/debug/by';
export { REMOVE_STYLES_ON_COMPONENT_DESTROY } from './dom/dom_renderer';
export { EVENT_MANAGER_PLUGINS, EventManager } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HammerGestureConfig, HammerModule } from './dom/events/hammer_gestures';
export { DomSanitizer } from './security/dom_sanitization_service';
export * from './private_export';
export { VERSION } from './version';
//# sourceMappingURL=data:application/json;base64,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