import { Component, ContentChildren, HostBinding, Input } from '@angular/core';
import { NgTemplateOutlet } from '@angular/common';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { CollapseDirective } from '../../collapse';
import { TemplateIdDirective } from '../../shared';
import { AccordionButtonDirective } from '../accordion-button/accordion-button.directive';
import * as i0 from "@angular/core";
import * as i1 from "../accordion.service";
let nextId = 0;
export class AccordionItemComponent {
    constructor(accordionService) {
        this.accordionService = accordionService;
        this.contentId = `accordion-item-${nextId++}`;
        this.itemContext = { $implicit: this.visible };
        this.templates = {};
        this._visible = false;
    }
    get visible() {
        return this._visible;
    }
    /**
     * Toggle an accordion item programmatically
     * @type boolean
     * @default false
     */
    set visible(value) {
        this._visible = coerceBooleanProperty(value);
    }
    get open() {
        return this.visible;
    }
    set open(value) {
        console.warn('c-accordion-item "open" prop is deprecated, use "visible"  prop instead.');
        this.visible = value || this.visible;
    }
    get hostClasses() {
        return {
            'accordion-item': true
        };
    }
    ngOnInit() {
        this.accordionService.addItem(this);
    }
    ngOnDestroy() {
        this.accordionService.removeItem(this);
    }
    toggleItem() {
        this.accordionService.toggleItem(this);
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
AccordionItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: AccordionItemComponent, deps: [{ token: i1.AccordionService }], target: i0.ɵɵFactoryTarget.Component });
AccordionItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: AccordionItemComponent, isStandalone: true, selector: "c-accordion-item", inputs: { visible: "visible", open: "open" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cAccordionItem"], ngImport: i0, template: "<ng-container>\n  <div class=\"accordion-header\">\n    <ng-container *ngTemplateOutlet=\"templates['accordionHeaderTemplate'] || defaultAccordionHeaderTemplate; context: itemContext\"></ng-container>\n  </div>\n  <div class=\"accordion-collapse\" cCollapse [visible]=\"visible\" [attr.aria-expanded]=\"visible\" [id]=\"contentId\">\n    <ng-container *ngTemplateOutlet=\"templates['accordionBodyTemplate'] || defaultAccordionBodyTemplate; context: itemContext\"></ng-container>\n  </div>\n</ng-container>\n\n<ng-template #defaultAccordionHeaderTemplate>\n  <button cAccordionButton [collapsed]=\"!visible\" [attr.aria-controls]=\"contentId\" (click)=\"toggleItem()\">\n    <ng-container\n      *ngTemplateOutlet=\"templates['accordionHeader'] || defaultAccordionHeaderContentTemplate; context: itemContext\">\n    </ng-container>\n  </button>\n</ng-template>\n\n<ng-template #defaultAccordionHeaderContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n\n<ng-template #defaultAccordionBodyTemplate>\n  <div class=\"accordion-body\">\n    <ng-container\n      *ngTemplateOutlet=\"templates['accordionBody'] || defaultAccordionBodyContentTemplate; context: itemContext\">\n    </ng-container>\n  </div>\n</ng-template>\n\n<ng-template #defaultAccordionBodyContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [":host{display:block;overflow:hidden}\n"], dependencies: [{ kind: "directive", type: AccordionButtonDirective, selector: "[cAccordionButton]", inputs: ["collapsed", "type"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: CollapseDirective, selector: "[cCollapse]", inputs: ["animate", "horizontal", "visible", "navbar", "duration", "transition"], outputs: ["collapseChange"], exportAs: ["cCollapse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: AccordionItemComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-accordion-item', exportAs: 'cAccordionItem', standalone: true, imports: [AccordionButtonDirective, NgTemplateOutlet, CollapseDirective], template: "<ng-container>\n  <div class=\"accordion-header\">\n    <ng-container *ngTemplateOutlet=\"templates['accordionHeaderTemplate'] || defaultAccordionHeaderTemplate; context: itemContext\"></ng-container>\n  </div>\n  <div class=\"accordion-collapse\" cCollapse [visible]=\"visible\" [attr.aria-expanded]=\"visible\" [id]=\"contentId\">\n    <ng-container *ngTemplateOutlet=\"templates['accordionBodyTemplate'] || defaultAccordionBodyTemplate; context: itemContext\"></ng-container>\n  </div>\n</ng-container>\n\n<ng-template #defaultAccordionHeaderTemplate>\n  <button cAccordionButton [collapsed]=\"!visible\" [attr.aria-controls]=\"contentId\" (click)=\"toggleItem()\">\n    <ng-container\n      *ngTemplateOutlet=\"templates['accordionHeader'] || defaultAccordionHeaderContentTemplate; context: itemContext\">\n    </ng-container>\n  </button>\n</ng-template>\n\n<ng-template #defaultAccordionHeaderContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n\n<ng-template #defaultAccordionBodyTemplate>\n  <div class=\"accordion-body\">\n    <ng-container\n      *ngTemplateOutlet=\"templates['accordionBody'] || defaultAccordionBodyContentTemplate; context: itemContext\">\n    </ng-container>\n  </div>\n</ng-template>\n\n<ng-template #defaultAccordionBodyContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [":host{display:block;overflow:hidden}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AccordionService }]; }, propDecorators: { contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], visible: [{
                type: Input
            }], open: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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