import { Component, ContentChildren, EventEmitter, HostBinding, HostListener, Input, Output } from '@angular/core';
import { NgIf, NgTemplateOutlet } from '@angular/common';
import { animate, state, style, transition, trigger } from '@angular/animations';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { TemplateIdDirective } from '../shared';
import { ButtonCloseDirective } from '../button';
import * as i0 from "@angular/core";
export class AlertComponent {
    constructor() {
        /**
         * Sets the color context of the component to one of CoreUI’s themed colors.
         *
         * @type Colors
         * @default 'primary'
         */
        this.color = 'primary';
        /**
         * Default role for alert. [docs]
         * @type string
         * @default 'alert'
         */
        this.role = 'alert';
        /**
         * Event triggered on the alert dismiss.
         */
        this.visibleChange = new EventEmitter();
        this.templates = {};
        this._dismissible = false;
        this._fade = false;
        this._visible = true;
    }
    /**
     * Optionally adds a close button to alert and allow it to self dismiss.
     * @type boolean
     */
    get dismissible() {
        return this._dismissible;
    }
    set dismissible(value) {
        this._dismissible = coerceBooleanProperty(value);
    }
    /**
     * Adds animation for dismissible alert.
     * @type boolean
     */
    get fade() {
        return this._fade;
    }
    set fade(value) {
        this._fade = coerceBooleanProperty(value);
    }
    get visible() {
        return this._visible;
    }
    /**
     * Toggle the visibility of alert component.
     * @type boolean
     */
    set visible(value) {
        if (this._visible !== value) {
            this._visible = coerceBooleanProperty(value);
            this.visibleChange.emit(value);
        }
    }
    ;
    get animationDisabled() {
        return !this.fade;
    }
    get animateType() {
        return this.visible ? 'show' : 'hide';
    }
    get hostClasses() {
        return {
            alert: true,
            'alert-dismissible': this.dismissible,
            fade: this.fade,
            show: !this.hide,
            [`alert-${this.color}`]: !!this.color && this.variant !== 'solid',
            [`bg-${this.color}`]: !!this.color && this.variant === 'solid',
            'text-white': !!this.color && this.variant === 'solid'
        };
    }
    onAnimationStart($event) {
        this.onAnimationEvent($event);
    }
    onAnimationDone($event) {
        this.onAnimationEvent($event);
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
    onAnimationEvent(event) {
        this.hide = event.phaseName === 'start' && event.toState === 'show';
        if (event.phaseName === 'done') {
            this.hide = (event.toState === 'hide' || event.toState === 'void');
            if (event.toState === 'show') {
                this.hide = false;
            }
        }
    }
}
AlertComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: AlertComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
AlertComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: AlertComponent, isStandalone: true, selector: "c-alert", inputs: { color: "color", role: "role", variant: "variant", dismissible: "dismissible", fade: "fade", visible: "visible" }, outputs: { visibleChange: "visibleChange" }, host: { listeners: { "@fadeInOut.start": "onAnimationStart($event)", "@fadeInOut.done": "onAnimationDone($event)" }, properties: { "attr.role": "this.role", "@.disabled": "this.animationDisabled", "@fadeInOut": "this.animateType", "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cAlert"], ngImport: i0, template: "<ng-container *ngIf=\"visible || !hide\">\n  <ng-template [ngIf]=\"dismissible\">\n    <ng-container *ngTemplateOutlet=\"templates?.alertButtonCloseTemplate || defaultAlertButtonCloseTemplate\">\n    </ng-container>\n  </ng-template>\n  <ng-content></ng-content>\n</ng-container>\n\n<ng-template #defaultAlertButtonCloseTemplate>\n  <button (click)=\"visible=false\" aria-label=\"Close\" cButtonClose></button>\n</ng-template>\n", styles: [":host{display:block;overflow:hidden}\n"], dependencies: [{ kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: ButtonCloseDirective, selector: "[cButtonClose]", inputs: ["white"] }], animations: [
        trigger('fadeInOut', [
            state('show', style({ opacity: 1, height: '*', padding: '*', border: '*', margin: '*' })),
            state('hide', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
            state('void', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
            transition('show => hide', [
                animate('.3s ease-out')
            ]),
            transition('hide => show', [
                animate('.3s ease-in')
            ]),
            transition('show => void', [
                animate('.3s ease-out')
            ]),
            transition('void => show', [
                animate('.3s ease-in')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: AlertComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-alert', exportAs: 'cAlert', standalone: true, imports: [NgIf, NgTemplateOutlet, ButtonCloseDirective], animations: [
                        trigger('fadeInOut', [
                            state('show', style({ opacity: 1, height: '*', padding: '*', border: '*', margin: '*' })),
                            state('hide', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
                            state('void', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
                            transition('show => hide', [
                                animate('.3s ease-out')
                            ]),
                            transition('hide => show', [
                                animate('.3s ease-in')
                            ]),
                            transition('show => void', [
                                animate('.3s ease-out')
                            ]),
                            transition('void => show', [
                                animate('.3s ease-in')
                            ])
                        ])
                    ], template: "<ng-container *ngIf=\"visible || !hide\">\n  <ng-template [ngIf]=\"dismissible\">\n    <ng-container *ngTemplateOutlet=\"templates?.alertButtonCloseTemplate || defaultAlertButtonCloseTemplate\">\n    </ng-container>\n  </ng-template>\n  <ng-content></ng-content>\n</ng-container>\n\n<ng-template #defaultAlertButtonCloseTemplate>\n  <button (click)=\"visible=false\" aria-label=\"Close\" cButtonClose></button>\n</ng-template>\n", styles: [":host{display:block;overflow:hidden}\n"] }]
        }], propDecorators: { color: [{
                type: Input
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }, {
                type: Input
            }], variant: [{
                type: Input
            }], visibleChange: [{
                type: Output
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], dismissible: [{
                type: Input
            }], fade: [{
                type: Input
            }], visible: [{
                type: Input
            }], animationDisabled: [{
                type: HostBinding,
                args: ['@.disabled']
            }], animateType: [{
                type: HostBinding,
                args: ['@fadeInOut']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], onAnimationStart: [{
                type: HostListener,
                args: ['@fadeInOut.start', ['$event']]
            }], onAnimationDone: [{
                type: HostListener,
                args: ['@fadeInOut.done', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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