import { Component, HostBinding, Input } from '@angular/core';
import { NgIf, NgTemplateOutlet } from '@angular/common';
import { RouterModule } from '@angular/router';
import { HtmlAttributesDirective } from '../../shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
export class BreadcrumbItemComponent {
    get ariaCurrent() {
        return this.active ? 'page' : null;
    }
    get hostClasses() {
        return {
            'breadcrumb-item': true,
            active: this.active
        };
    }
}
BreadcrumbItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: BreadcrumbItemComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
BreadcrumbItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: BreadcrumbItemComponent, isStandalone: true, selector: "c-breadcrumb-item", inputs: { active: "active", url: "url", attributes: "attributes", linkProps: "linkProps" }, host: { properties: { "attr.aria-current": "this.ariaCurrent", "class": "this.hostClasses" } }, ngImport: i0, template: "<a *ngIf=\"!active; else activeItem\"\n   [routerLink]=\"url\"\n   [cHtmlAttr]=\"attributes ?? {}\"\n   [target]=\"attributes?.['target']\"\n   [queryParams]=\"linkProps?.queryParams ?? null\"\n   [fragment]=\"linkProps?.fragment\"\n   [queryParamsHandling]=\"linkProps?.queryParamsHandling ?? null\"\n   [preserveFragment]=\"linkProps?.preserveFragment ?? false\"\n   [skipLocationChange]=\"linkProps?.skipLocationChange ?? false\"\n   [replaceUrl]=\"linkProps?.replaceUrl ?? false\"\n   [state]=\"linkProps?.state ?? {}\"\n>\n  <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\n</a>\n\n<ng-template #activeItem>\n  <span [cHtmlAttr]=\"attributes ?? {}\">\n      <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\n  </span>\n</ng-template>\n\n<ng-template #defaultBreadcrumbItemContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [":host{display:list-item;text-align:-webkit-match-parent;text-align:match-parent}\n"], dependencies: [{ kind: "ngmodule", type: RouterModule }, { kind: "directive", type: i1.RouterLink, selector: "[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: BreadcrumbItemComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-breadcrumb-item', standalone: true, imports: [RouterModule, NgIf, NgTemplateOutlet, HtmlAttributesDirective], template: "<a *ngIf=\"!active; else activeItem\"\n   [routerLink]=\"url\"\n   [cHtmlAttr]=\"attributes ?? {}\"\n   [target]=\"attributes?.['target']\"\n   [queryParams]=\"linkProps?.queryParams ?? null\"\n   [fragment]=\"linkProps?.fragment\"\n   [queryParamsHandling]=\"linkProps?.queryParamsHandling ?? null\"\n   [preserveFragment]=\"linkProps?.preserveFragment ?? false\"\n   [skipLocationChange]=\"linkProps?.skipLocationChange ?? false\"\n   [replaceUrl]=\"linkProps?.replaceUrl ?? false\"\n   [state]=\"linkProps?.state ?? {}\"\n>\n  <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\n</a>\n\n<ng-template #activeItem>\n  <span [cHtmlAttr]=\"attributes ?? {}\">\n      <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\n  </span>\n</ng-template>\n\n<ng-template #defaultBreadcrumbItemContentTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [":host{display:list-item;text-align:-webkit-match-parent;text-align:match-parent}\n"] }]
        }], propDecorators: { active: [{
                type: Input
            }], url: [{
                type: Input
            }], attributes: [{
                type: Input
            }], linkProps: [{
                type: Input
            }], ariaCurrent: [{
                type: HostBinding,
                args: ['attr.aria-current']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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