import { Component, Input } from '@angular/core';
import { Observable } from 'rxjs';
import { AsyncPipe, NgForOf, NgIf } from '@angular/common';
import { BreadcrumbComponent } from '../breadcrumb/breadcrumb.component';
import { BreadcrumbItemComponent } from '../breadcrumb-item/breadcrumb-item.component';
import * as i0 from "@angular/core";
import * as i1 from "./breadcrumb-router.service";
export class BreadcrumbRouterComponent {
    constructor(service) {
        this.service = service;
    }
    ngOnInit() {
        this.breadcrumbs = this.service.breadcrumbs$;
    }
    ngOnChanges(changes) {
        if (changes['items']) {
            this.setup();
        }
    }
    setup() {
        if (this.items && this.items.length > 0) {
            this.breadcrumbs = new Observable((observer) => {
                if (this.items) {
                    observer.next(this.items);
                }
            });
        }
    }
    ngOnDestroy() {
        this.breadcrumbs = undefined;
    }
}
BreadcrumbRouterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: BreadcrumbRouterComponent, deps: [{ token: i1.BreadcrumbRouterService }], target: i0.ɵɵFactoryTarget.Component });
BreadcrumbRouterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: BreadcrumbRouterComponent, isStandalone: true, selector: "c-breadcrumb-router, [cBreadcrumbRouter]", inputs: { items: "items" }, usesOnChanges: true, ngImport: i0, template: "<c-breadcrumb class=\"m-0\">\n  <ng-template ngFor let-breadcrumb [ngForOf]=\"breadcrumbs | async\" let-last=\"last\">\n    <ng-container *ngIf=\"breadcrumb?.label && (breadcrumb?.url?.slice(-1) === '/' || last)\">\n      <c-breadcrumb-item\n        [active]=\"last\"\n        [url]=\"breadcrumb?.url\"\n        [attributes]=\"breadcrumb?.attributes\"\n        [linkProps]=\"breadcrumb?.linkProps\"\n      >\n        {{ breadcrumb?.label }}\n      </c-breadcrumb-item>\n    </ng-container>\n  </ng-template>\n</c-breadcrumb>\n", styles: [""], dependencies: [{ kind: "component", type: BreadcrumbComponent, selector: "c-breadcrumb", inputs: ["ariaLabel", "role"] }, { kind: "component", type: BreadcrumbItemComponent, selector: "c-breadcrumb-item", inputs: ["active", "url", "attributes", "linkProps"] }, { kind: "directive", type: NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "pipe", type: AsyncPipe, name: "async" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: BreadcrumbRouterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-breadcrumb-router, [cBreadcrumbRouter]', standalone: true, imports: [BreadcrumbComponent, BreadcrumbItemComponent, NgForOf, NgIf, AsyncPipe], template: "<c-breadcrumb class=\"m-0\">\n  <ng-template ngFor let-breadcrumb [ngForOf]=\"breadcrumbs | async\" let-last=\"last\">\n    <ng-container *ngIf=\"breadcrumb?.label && (breadcrumb?.url?.slice(-1) === '/' || last)\">\n      <c-breadcrumb-item\n        [active]=\"last\"\n        [url]=\"breadcrumb?.url\"\n        [attributes]=\"breadcrumb?.attributes\"\n        [linkProps]=\"breadcrumb?.linkProps\"\n      >\n        {{ breadcrumb?.label }}\n      </c-breadcrumb-item>\n    </ng-container>\n  </ng-template>\n</c-breadcrumb>\n" }]
        }], ctorParameters: function () { return [{ type: i1.BreadcrumbRouterService }]; }, propDecorators: { items: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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