import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ButtonDirective {
    constructor() {
        this._active = false;
        this._disabled = false;
        /**
         * Sets the color context of the component to one of CoreUI’s themed colors. [docs]
         * @type Colors
         */
        this.color = 'primary';
        /**
         * Size the component small or large.
         * @type {'sm' | 'lg'}
         */
        this.size = '';
        /**
         * Specifies the type of button. Always specify the type attribute for the `<button>` element.
         * Different browsers may use different default types for the `<button>` element.
         */
        this.type = 'button';
    }
    /**
     * Toggle the active state for the component. [docs]
     * @type boolean
     */
    get active() {
        return this._active;
    }
    set active(value) {
        this._active = coerceBooleanProperty(value);
    }
    /**
     * Toggle the disabled state for the component.
     * @type boolean
     */
    get disabled() {
        return this._disabled;
    }
    set disabled(value) {
        this._disabled = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            btn: true,
            [`btn-${this.color}`]: !!this.color && !this.variant,
            [`btn-${this.variant}`]: !!this.variant && !this.color,
            [`btn-${this.variant}-${this.color}`]: !!this.variant && !!this.color,
            [`btn-${this.size}`]: !!this.size,
            [`${this.shape}`]: !!this.shape,
            disabled: this.disabled,
            active: this.active
        };
    }
    get ariaDisabled() {
        return this.disabled || null;
    }
    ;
    get isActive() {
        return this.active || null;
    }
    get attrDisabled() {
        return this.disabled ? '' : null;
    }
    ;
    get tabIndex() {
        return this.disabled ? '-1' : null;
    }
}
ButtonDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ButtonDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ButtonDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: ButtonDirective, isStandalone: true, selector: "[cButton]", inputs: { active: "active", color: "color", disabled: "disabled", shape: "shape", size: "size", type: "type", variant: "variant" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses", "attr.aria-disabled": "this.ariaDisabled", "attr.aria-pressed": "this.isActive", "attr.disabled": "this.attrDisabled", "attr.tabindex": "this.tabIndex" } }, exportAs: ["cButton"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ButtonDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cButton]',
                    exportAs: 'cButton',
                    standalone: true
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { active: [{
                type: Input
            }], color: [{
                type: Input
            }], disabled: [{
                type: Input
            }], shape: [{
                type: Input
            }], size: [{
                type: Input
            }], type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], variant: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], ariaDisabled: [{
                type: HostBinding,
                args: ['attr.aria-disabled']
            }], isActive: [{
                type: HostBinding,
                args: ['attr.aria-pressed']
            }], attrDisabled: [{
                type: HostBinding,
                args: ['attr.disabled']
            }], tabIndex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }] } });
//# sourceMappingURL=data:application/json;base64,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