import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class FormCheckInputDirective {
    /**
     * Set component indeterminate state.
     * @type boolean
     */
    set indeterminate(value) {
        const newValue = coerceBooleanProperty(value);
        if (this._indeterminate !== newValue) {
            this._indeterminate = newValue;
            this.renderer.setProperty(this.hostElement.nativeElement, 'indeterminate', newValue);
        }
    }
    ;
    get indeterminate() {
        return this._indeterminate;
    }
    get hostClasses() {
        return {
            'form-check-input': true,
            'is-valid': this.valid === true,
            'is-invalid': this.valid === false
        };
    }
    get checked() {
        return this.hostElement?.nativeElement?.checked;
    }
    constructor(renderer, hostElement) {
        this.renderer = renderer;
        this.hostElement = hostElement;
        /**
         * Specifies the type of component.
         * @type {'checkbox' | 'radio'}
         * @default 'checkbox'
         */
        this.type = 'checkbox';
        this._indeterminate = false;
    }
}
FormCheckInputDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormCheckInputDirective, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
FormCheckInputDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: FormCheckInputDirective, isStandalone: true, selector: "input[cFormCheckInput]", inputs: { type: "type", indeterminate: "indeterminate", valid: "valid" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormCheckInputDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'input[cFormCheckInput]',
                    standalone: true
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, propDecorators: { type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], indeterminate: [{
                type: Input
            }], valid: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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