import { Component, ContentChild, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { FormCheckLabelDirective } from './form-check-label.directive';
import * as i0 from "@angular/core";
export class FormCheckComponent {
    constructor() {
        this._inline = false;
        this._reverse = false;
        /**
         * Size the component large or extra large. Works only with `[switch]="true"` [docs]
         * @type {'lg' | 'xl' | ''}
         */
        this.sizing = '';
        this._switch = false;
        this._formCheckClass = true;
    }
    /**
     * Group checkboxes or radios on the same horizontal row.
     * @type boolean
     * @default false
     */
    set inline(value) {
        this._inline = coerceBooleanProperty(value);
    }
    get inline() {
        return this._inline;
    }
    /**
     * Put checkboxes or radios on the opposite side.
     * @type boolean
     * @default false
     * @since 4.4.7
     */
    set reverse(value) {
        this._reverse = coerceBooleanProperty(value);
    }
    get reverse() {
        return this._reverse;
    }
    /**
     * Render a toggle switch on for checkbox.
     * @type boolean
     * @default false
     */
    set switch(value) {
        this._switch = coerceBooleanProperty(value);
    }
    get switch() {
        return this._switch;
    }
    get hostClasses() {
        return {
            'form-check': this.formCheckClass,
            'form-switch': this.switch,
            [`form-switch-${this.sizing}`]: this.switch && !!this.sizing,
            'form-check-inline': this.inline,
            'form-check-reverse': this.reverse
        };
    }
    get formCheckClass() {
        return this._formCheckClass;
    }
    ngAfterContentInit() {
        this._formCheckClass = !!this.formCheckLabel;
    }
}
FormCheckComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormCheckComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
FormCheckComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: FormCheckComponent, isStandalone: true, selector: "c-form-check", inputs: { inline: "inline", reverse: "reverse", sizing: "sizing", switch: "switch" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "formCheckLabel", first: true, predicate: FormCheckLabelDirective, descendants: true }], exportAs: ["cFormCheck"], ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormCheckComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-form-check',
                    template: '<ng-content></ng-content>',
                    exportAs: 'cFormCheck',
                    standalone: true
                }]
        }], propDecorators: { inline: [{
                type: Input
            }], reverse: [{
                type: Input
            }], sizing: [{
                type: Input
            }], switch: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], formCheckLabel: [{
                type: ContentChild,
                args: [FormCheckLabelDirective]
            }] } });
//# sourceMappingURL=data:application/json;base64,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