import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class FormControlDirective {
    /**
     * Render the component styled as plain text. Removes the default form field styling and preserve the correct margin and padding. Recommend to use alongside `readonly` [docs]
     */
    set plaintext(value) {
        this._plaintext = coerceBooleanProperty(value);
    }
    get plaintext() {
        return this._plaintext;
    }
    constructor(hostElement) {
        this.hostElement = hostElement;
        /**
         * Size the component small or large.
         * @type {'sm' | 'lg'}
         */
        this.sizing = '';
        /**
         * Specifies the type of input element.
         */
        this.type = 'text';
        this._plaintext = false;
    }
    get hostClasses() {
        const isRangeType = this.type === 'range';
        return {
            'form-control': !isRangeType && !this.plaintext,
            'form-control-plaintext': !isRangeType && this.plaintext,
            'form-control-color': this.type === 'color',
            'form-range': isRangeType,
            [`form-control-${this.sizing}`]: !!this.sizing && !isRangeType,
            'is-valid': this.valid === true,
            'is-invalid': this.valid === false
        };
    }
    get hostTag() {
        return this.hostElement.nativeElement.tagName;
    }
    ngOnInit() {
        const hostTag = this.hostTag.toLowerCase();
        if (hostTag !== 'input' && hostTag !== 'textarea') {
            console.warn(`CoreUI [cFormControl] works with '<input>' and '<texarea>' - not with '<${hostTag}>'`);
        }
    }
}
FormControlDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormControlDirective, deps: [{ token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
FormControlDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: FormControlDirective, isStandalone: true, selector: "input[cFormControl], textarea[cFormControl]", inputs: { sizing: "sizing", valid: "valid", type: "type", plaintext: "plaintext" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormControlDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'input[cFormControl], textarea[cFormControl]',
                    standalone: true
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }]; }, propDecorators: { sizing: [{
                type: Input
            }], valid: [{
                type: Input
            }], type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], plaintext: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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