import { Component, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class FormFeedbackComponent {
    constructor() {
        /**
         * If your form layout allows it, you can display validation feedback in a styled tooltip.
         */
        this._tooltip = false;
    }
    set tooltip(value) {
        this._tooltip = coerceBooleanProperty(value);
    }
    get tooltip() {
        return this._tooltip;
    }
    get hostClasses() {
        return {
            'valid-feedback': this.valid === true && !this.tooltip,
            'valid-tooltip': this.valid === true && this.tooltip,
            'invalid-feedback': this.valid !== true && !this.tooltip,
            'invalid-tooltip': this.valid !== true && this.tooltip
        };
    }
}
FormFeedbackComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormFeedbackComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
FormFeedbackComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: FormFeedbackComponent, isStandalone: true, selector: "c-form-feedback", inputs: { tooltip: "tooltip", valid: "valid" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: FormFeedbackComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-form-feedback',
                    template: '<ng-content></ng-content>',
                    standalone: true
                }]
        }], propDecorators: { tooltip: [{
                type: Input
            }], valid: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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