import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ImgDirective {
    /**
     * Make image responsive.
     * @type boolean
     */
    set fluid(value) {
        this._fluid = coerceBooleanProperty(value);
    }
    ;
    get fluid() {
        return this._fluid;
    }
    /**
     * Make image rounded.
     * @type boolean
     */
    set rounded(value) {
        this._rounded = coerceBooleanProperty(value);
    }
    ;
    get rounded() {
        return this._rounded;
    }
    /**
     * Give an image a rounded 1px border appearance.
     * @type boolean
     */
    set thumbnail(value) {
        this._thumbnail = coerceBooleanProperty(value);
    }
    ;
    get thumbnail() {
        return this._thumbnail;
    }
    get getStyles() {
        return { backgroundColor: this.placeholderColor };
    }
    get hostClasses() {
        const align = this.align;
        return {
            [`float-${align}`]: align === 'start' || align === 'end',
            'd-block': align === 'center',
            'mx-auto': align === 'center',
            'img-fluid': this.fluid,
            'rounded': this.rounded,
            'img-thumbnail': this.thumbnail,
        };
    }
    constructor() {
        /**
         * Set the horizontal aligment.
         * @type {'' | 'start' | 'end' | 'center'}
         */
        this.align = '';
        this._fluid = false;
        this._rounded = false;
        this._thumbnail = false;
        /**
         * Color for image placeholder.
         */
        this.placeholderColor = 'transparent';
    }
}
ImgDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ImgDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ImgDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: ImgDirective, isStandalone: true, selector: "[cImg]", inputs: { align: "align", fluid: "fluid", rounded: "rounded", thumbnail: "thumbnail", placeholderColor: "placeholderColor" }, host: { properties: { "style": "this.getStyles", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ImgDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cImg]',
                    standalone: true
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { align: [{
                type: Input
            }], fluid: [{
                type: Input
            }], rounded: [{
                type: Input
            }], thumbnail: [{
                type: Input
            }], placeholderColor: [{
                type: Input
            }], getStyles: [{
                type: HostBinding,
                args: ['style']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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