import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ListGroupDirective {
    /**
     * Remove some borders and rounded corners to render list group items edge-to-edge in a parent component (e.g., `<CCard>`).
     * @type boolean
     */
    set flush(value) {
        this._flush = coerceBooleanProperty(value);
    }
    ;
    get flush() {
        return this._flush;
    }
    get hostClasses() {
        const classes = {
            'list-group': true,
            'list-group-horizontal': this.horizontal === true || this.horizontal === '',
            [`list-group-horizontal-${this.horizontal}`]: !!this.horizontal && typeof this.horizontal !== 'boolean',
            'list-group-flush': this.flush,
        };
        return classes;
    }
    constructor() {
        this._flush = false;
    }
}
ListGroupDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ListGroupDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ListGroupDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: ListGroupDirective, isStandalone: true, selector: "[cListGroup]", inputs: { flush: "flush", horizontal: "horizontal" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ListGroupDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cListGroup]',
                    standalone: true
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { flush: [{
                type: Input
            }], horizontal: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdC1ncm91cC5kaXJlY3RpdmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL2xpc3QtZ3JvdXAvbGlzdC1ncm91cC5kaXJlY3RpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLFNBQVMsRUFBRSxXQUFXLEVBQUUsS0FBSyxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBRTVELE9BQU8sRUFBZ0IscUJBQXFCLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQzs7QUFNNUUsTUFBTSxPQUFPLGtCQUFrQjtJQUc3Qjs7O09BR0c7SUFDSCxJQUNJLEtBQUssQ0FBQyxLQUFjO1FBQ3RCLElBQUksQ0FBQyxNQUFNLEdBQUcscUJBQXFCLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUFBLENBQUM7SUFDRixJQUFJLEtBQUs7UUFDUCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQU9ELElBQ0ksV0FBVztRQUNiLE1BQU0sT0FBTyxHQUFHO1lBQ2QsWUFBWSxFQUFFLElBQUk7WUFDbEIsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLFVBQVUsS0FBSyxJQUFJLElBQUksSUFBSSxDQUFDLFVBQVUsS0FBSyxFQUFFO1lBQzNFLENBQUMseUJBQXlCLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLE9BQU8sSUFBSSxDQUFDLFVBQVUsS0FBSyxTQUFTO1lBQ3ZHLGtCQUFrQixFQUFFLElBQUksQ0FBQyxLQUFLO1NBQy9CLENBQUM7UUFDRixPQUFPLE9BQU8sQ0FBQztJQUNqQixDQUFDO0lBRUQ7UUFqQlEsV0FBTSxHQUFHLEtBQUssQ0FBQztJQWlCTCxDQUFDOzsrR0EvQlIsa0JBQWtCO21HQUFsQixrQkFBa0I7MkZBQWxCLGtCQUFrQjtrQkFKOUIsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsY0FBYztvQkFDeEIsVUFBVSxFQUFFLElBQUk7aUJBQ2pCOzBFQVNLLEtBQUs7c0JBRFIsS0FBSztnQkFXRyxVQUFVO3NCQUFsQixLQUFLO2dCQUdGLFdBQVc7c0JBRGQsV0FBVzt1QkFBQyxPQUFPIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtEaXJlY3RpdmUsIEhvc3RCaW5kaW5nLCBJbnB1dH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBTaXplcyB9IGZyb20gJy4uL2NvcmV1aS50eXBlcyc7XG5pbXBvcnQgeyBCb29sZWFuSW5wdXQsIGNvZXJjZUJvb2xlYW5Qcm9wZXJ0eSB9IGZyb20gJ0Bhbmd1bGFyL2Nkay9jb2VyY2lvbic7XG5cbkBEaXJlY3RpdmUoe1xuICBzZWxlY3RvcjogJ1tjTGlzdEdyb3VwXScsXG4gIHN0YW5kYWxvbmU6IHRydWVcbn0pXG5leHBvcnQgY2xhc3MgTGlzdEdyb3VwRGlyZWN0aXZlIHtcbiAgc3RhdGljIG5nQWNjZXB0SW5wdXRUeXBlX2ZsdXNoOiBCb29sZWFuSW5wdXQ7XG5cbiAgLyoqXG4gICAqIFJlbW92ZSBzb21lIGJvcmRlcnMgYW5kIHJvdW5kZWQgY29ybmVycyB0byByZW5kZXIgbGlzdCBncm91cCBpdGVtcyBlZGdlLXRvLWVkZ2UgaW4gYSBwYXJlbnQgY29tcG9uZW50IChlLmcuLCBgPENDYXJkPmApLlxuICAgKiBAdHlwZSBib29sZWFuXG4gICAqL1xuICBASW5wdXQoKVxuICBzZXQgZmx1c2godmFsdWU6IGJvb2xlYW4pIHtcbiAgICB0aGlzLl9mbHVzaCA9IGNvZXJjZUJvb2xlYW5Qcm9wZXJ0eSh2YWx1ZSk7XG4gIH07XG4gIGdldCBmbHVzaCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZmx1c2g7XG4gIH1cbiAgcHJpdmF0ZSBfZmx1c2ggPSBmYWxzZTtcbiAgLyoqXG4gICAqIFNwZWNpZnkgaG9yaXpvbnRhbCBsYXlvdXQgdHlwZS5cbiAgICovXG4gIEBJbnB1dCgpIGhvcml6b250YWw/OiBib29sZWFuIHwgU2l6ZXM7XG5cbiAgQEhvc3RCaW5kaW5nKCdjbGFzcycpXG4gIGdldCBob3N0Q2xhc3NlcygpOiBhbnkge1xuICAgIGNvbnN0IGNsYXNzZXMgPSB7XG4gICAgICAnbGlzdC1ncm91cCc6IHRydWUsXG4gICAgICAnbGlzdC1ncm91cC1ob3Jpem9udGFsJzogdGhpcy5ob3Jpem9udGFsID09PSB0cnVlIHx8IHRoaXMuaG9yaXpvbnRhbCA9PT0gJycsXG4gICAgICBbYGxpc3QtZ3JvdXAtaG9yaXpvbnRhbC0ke3RoaXMuaG9yaXpvbnRhbH1gXTogISF0aGlzLmhvcml6b250YWwgJiYgdHlwZW9mIHRoaXMuaG9yaXpvbnRhbCAhPT0gJ2Jvb2xlYW4nLFxuICAgICAgJ2xpc3QtZ3JvdXAtZmx1c2gnOiB0aGlzLmZsdXNoLFxuICAgIH07XG4gICAgcmV0dXJuIGNsYXNzZXM7XG4gIH1cblxuICBjb25zdHJ1Y3RvciggKSB7ICB9XG5cbn1cblxuIl19