var _OffcanvasComponent_scroll, _OffcanvasComponent_visible, _OffcanvasComponent_activeBackdrop, _OffcanvasComponent_scrollbarWidth, _OffcanvasComponent_stateToggleSubscription, _OffcanvasComponent_backdropClickSubscription, _OffcanvasComponent_layoutChangeSubscription, _OffcanvasComponent_show;
import { __classPrivateFieldGet, __classPrivateFieldSet } from "tslib";
import { Component, EventEmitter, HostBinding, HostListener, Inject, Input, Output, PLATFORM_ID } from '@angular/core';
import { DOCUMENT, isPlatformBrowser } from '@angular/common';
import { animate, state, style, transition, trigger } from '@angular/animations';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { filter } from 'rxjs/operators';
import { A11yModule } from '@angular/cdk/a11y';
import * as i0 from "@angular/core";
import * as i1 from "../offcanvas.service";
import * as i2 from "../../backdrop/backdrop.service";
import * as i3 from "@angular/cdk/layout";
import * as i4 from "@angular/cdk/a11y";
let nextId = 0;
export class OffcanvasComponent {
    constructor(document, platformId, renderer, hostElement, offcanvasService, backdropService, breakpointObserver) {
        this.document = document;
        this.platformId = platformId;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.offcanvasService = offcanvasService;
        this.backdropService = backdropService;
        this.breakpointObserver = breakpointObserver;
        /**
         * Apply a backdrop on body while offcanvas is open.
         * @type boolean | 'static'
         * @default true
         */
        this.backdrop = true;
        /**
         * Closes the offcanvas when escape key is pressed [docs]
         * @type boolean
         * @default true
         */
        this.keyboard = true;
        /**
         * Components placement, there’s no default placement.
         * @type {'start' | 'end' | 'top' | 'bottom'}
         * @default 'start'
         */
        this.placement = 'start';
        /**
         * Responsive offcanvas property hides content outside the viewport from a specified breakpoint and down.
         * @type boolean | 'sm' | 'md' | 'lg' | 'xl' | 'xxl';
         * @default true
         * @since 4.3.10
         */
        this.responsive = true;
        this.id = `offcanvas-${this.placement}-${nextId++}`;
        /**
         * Default role for offcanvas. [docs]
         * @type string
         * @default 'dialog'
         */
        this.role = 'dialog';
        /**
         * Set aria-modal html attr for offcanvas. [docs]
         * @type boolean
         * @default true
         */
        this.ariaModal = true;
        /**
         * Event triggered on visible change.
         */
        this.visibleChange = new EventEmitter();
        _OffcanvasComponent_scroll.set(this, false);
        _OffcanvasComponent_visible.set(this, false);
        _OffcanvasComponent_activeBackdrop.set(this, void 0);
        _OffcanvasComponent_scrollbarWidth.set(this, void 0);
        _OffcanvasComponent_stateToggleSubscription.set(this, void 0);
        _OffcanvasComponent_backdropClickSubscription.set(this, void 0);
        _OffcanvasComponent_layoutChangeSubscription.set(this, void 0);
        _OffcanvasComponent_show.set(this, false);
    }
    get scroll() {
        return __classPrivateFieldGet(this, _OffcanvasComponent_scroll, "f");
    }
    /**
     * Allow body scrolling while offcanvas is visible.
     * @type boolean
     * @default false
     */
    set scroll(value) {
        __classPrivateFieldSet(this, _OffcanvasComponent_scroll, coerceBooleanProperty(value), "f");
    }
    get visible() {
        return __classPrivateFieldGet(this, _OffcanvasComponent_visible, "f");
    }
    /**
     * Toggle the visibility of offcanvas component.
     * @type boolean
     * @default false
     */
    set visible(value) {
        __classPrivateFieldSet(this, _OffcanvasComponent_visible, coerceBooleanProperty(value), "f");
        if (__classPrivateFieldGet(this, _OffcanvasComponent_visible, "f")) {
            this.setBackdrop(this.backdrop);
            this.setFocus();
        }
        else {
            this.setBackdrop(false);
        }
        this.layoutChangeSubscribe(__classPrivateFieldGet(this, _OffcanvasComponent_visible, "f"));
        this.visibleChange.emit(value);
    }
    get hostClasses() {
        return {
            offcanvas: typeof this.responsive === 'boolean',
            [`offcanvas-${this.responsive}`]: typeof this.responsive !== 'boolean',
            [`offcanvas-${this.placement}`]: !!this.placement,
            show: this.show
        };
    }
    get ariaHidden() {
        return this.visible ? null : true;
    }
    get tabIndex() {
        return '-1';
    }
    get animateTrigger() {
        return this.visible ? 'visible' : 'hidden';
    }
    get show() {
        return this.visible && __classPrivateFieldGet(this, _OffcanvasComponent_show, "f");
    }
    set show(value) {
        __classPrivateFieldSet(this, _OffcanvasComponent_show, value, "f");
    }
    get responsiveBreakpoint() {
        if (typeof this.responsive !== 'string') {
            return false;
        }
        const element = this.document.documentElement;
        const responsiveBreakpoint = this.responsive;
        const breakpointValue = getComputedStyle(element).getPropertyValue(`--cui-breakpoint-${responsiveBreakpoint.trim()}`) || false;
        return breakpointValue ? `${parseFloat(breakpointValue.trim()) - 0.02}px` : false;
    }
    animateStart(event) {
        const scrollbarWidth = __classPrivateFieldGet(this, _OffcanvasComponent_scrollbarWidth, "f");
        if (event.toState === 'visible') {
            if (!this.scroll) {
                this.renderer.setStyle(this.document.body, 'overflow', 'hidden');
                this.renderer.setStyle(this.document.body, 'padding-right', scrollbarWidth);
            }
            this.renderer.addClass(this.hostElement.nativeElement, 'showing');
        }
        else {
            this.renderer.addClass(this.hostElement.nativeElement, 'hiding');
        }
    }
    animateDone(event) {
        setTimeout(() => {
            if (event.toState === 'visible') {
                this.renderer.removeClass(this.hostElement.nativeElement, 'showing');
            }
            if (event.toState === 'hidden') {
                this.renderer.removeClass(this.hostElement.nativeElement, 'hiding');
                this.renderer.removeStyle(this.document.body, 'overflow');
                this.renderer.removeStyle(this.document.body, 'paddingRight');
            }
        });
        this.show = this.visible;
    }
    onKeyDownHandler(event) {
        if (event.key === 'Escape' &&
            this.keyboard &&
            this.visible &&
            this.backdrop !== 'static') {
            this.offcanvasService.toggle({ show: false, id: this.id });
        }
    }
    ngOnInit() {
        __classPrivateFieldSet(this, _OffcanvasComponent_scrollbarWidth, this.backdropService.scrollbarWidth, "f");
        this.stateToggleSubscribe();
        setTimeout(() => {
            // hotfix to avoid offcanvas flicker on the first render
            this.renderer.setStyle(this.hostElement.nativeElement, 'display', 'flex');
        });
    }
    ngOnDestroy() {
        this.offcanvasService.toggle({ show: false, id: this.id });
        this.stateToggleSubscribe(false);
    }
    setFocus() {
        if (isPlatformBrowser(this.platformId)) {
            setTimeout(() => this.hostElement.nativeElement.focus());
        }
    }
    stateToggleSubscribe(subscribe = true) {
        if (subscribe) {
            __classPrivateFieldSet(this, _OffcanvasComponent_stateToggleSubscription, this.offcanvasService.offcanvasState$.subscribe((action) => {
                if (this === action.offcanvas || this.id === action.id) {
                    if ('show' in action) {
                        this.visible =
                            action?.show === 'toggle' ? !this.visible : action.show;
                    }
                }
            }), "f");
        }
        else {
            __classPrivateFieldGet(this, _OffcanvasComponent_stateToggleSubscription, "f")?.unsubscribe();
        }
    }
    backdropClickSubscribe(subscribe = true) {
        if (subscribe) {
            __classPrivateFieldSet(this, _OffcanvasComponent_backdropClickSubscription, this.backdropService.backdropClick$.subscribe((clicked) => {
                this.offcanvasService.toggle({ show: !clicked, id: this.id });
            }), "f");
        }
        else {
            __classPrivateFieldGet(this, _OffcanvasComponent_backdropClickSubscription, "f")?.unsubscribe();
        }
    }
    setBackdrop(setBackdrop) {
        __classPrivateFieldSet(this, _OffcanvasComponent_scrollbarWidth, this.backdropService.scrollbarWidth, "f");
        __classPrivateFieldSet(this, _OffcanvasComponent_activeBackdrop, !!setBackdrop ? this.backdropService.setBackdrop('offcanvas')
            : this.backdropService.clearBackdrop(__classPrivateFieldGet(this, _OffcanvasComponent_activeBackdrop, "f")), "f");
        setBackdrop === true ? this.backdropClickSubscribe()
            : this.backdropClickSubscribe(false);
    }
    layoutChangeSubscribe(subscribe = true) {
        if (subscribe) {
            if (!this.responsiveBreakpoint) {
                return;
            }
            const responsiveBreakpoint = `(max-width: ${this.responsiveBreakpoint})`;
            const layoutChanges = this.breakpointObserver.observe([responsiveBreakpoint]);
            __classPrivateFieldSet(this, _OffcanvasComponent_layoutChangeSubscription, layoutChanges
                .pipe(filter(breakpointState => !breakpointState.matches))
                .subscribe((breakpointState) => {
                this.visible = breakpointState.matches;
            }), "f");
        }
        else {
            __classPrivateFieldGet(this, _OffcanvasComponent_layoutChangeSubscription, "f")?.unsubscribe();
        }
    }
}
_OffcanvasComponent_scroll = new WeakMap(), _OffcanvasComponent_visible = new WeakMap(), _OffcanvasComponent_activeBackdrop = new WeakMap(), _OffcanvasComponent_scrollbarWidth = new WeakMap(), _OffcanvasComponent_stateToggleSubscription = new WeakMap(), _OffcanvasComponent_backdropClickSubscription = new WeakMap(), _OffcanvasComponent_layoutChangeSubscription = new WeakMap(), _OffcanvasComponent_show = new WeakMap();
OffcanvasComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: OffcanvasComponent, deps: [{ token: DOCUMENT }, { token: PLATFORM_ID }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.OffcanvasService }, { token: i2.BackdropService }, { token: i3.BreakpointObserver }], target: i0.ɵɵFactoryTarget.Component });
OffcanvasComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: OffcanvasComponent, isStandalone: true, selector: "c-offcanvas", inputs: { backdrop: "backdrop", keyboard: "keyboard", placement: "placement", responsive: "responsive", id: "id", role: "role", ariaModal: "ariaModal", scroll: "scroll", visible: "visible" }, outputs: { visibleChange: "visibleChange" }, host: { listeners: { "@showHide.start": "animateStart($event)", "@showHide.done": "animateDone($event)", "document:keydown": "onKeyDownHandler($event)" }, properties: { "attr.role": "this.role", "attr.aria-modal": "this.ariaModal", "class": "this.hostClasses", "attr.aria-hidden": "this.ariaHidden", "attr.tabindex": "this.tabIndex", "@showHide": "this.animateTrigger" } }, exportAs: ["cOffcanvas"], ngImport: i0, template: "<div cdkTrapFocus cdkTrapFocusAutoCapture>\n  <ng-content></ng-content>\n</div>\n\n", styles: [":host{display:none}\n"], dependencies: [{ kind: "ngmodule", type: A11yModule }, { kind: "directive", type: i4.CdkTrapFocus, selector: "[cdkTrapFocus]", inputs: ["cdkTrapFocus", "cdkTrapFocusAutoCapture"], exportAs: ["cdkTrapFocus"] }], animations: [
        trigger('showHide', [
            state('visible', style({
            // visibility: 'visible'
            })),
            state('hidden', style({
            // visibility: 'hidden'
            })),
            transition('visible <=> *', [animate('300ms')])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: OffcanvasComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-offcanvas', animations: [
                        trigger('showHide', [
                            state('visible', style({
                            // visibility: 'visible'
                            })),
                            state('hidden', style({
                            // visibility: 'hidden'
                            })),
                            transition('visible <=> *', [animate('300ms')])
                        ])
                    ], exportAs: 'cOffcanvas', standalone: true, imports: [A11yModule], template: "<div cdkTrapFocus cdkTrapFocusAutoCapture>\n  <ng-content></ng-content>\n</div>\n\n", styles: [":host{display:none}\n"] }]
        }], ctorParameters: function () { return [{ type: Document, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PLATFORM_ID]
                }] }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.OffcanvasService }, { type: i2.BackdropService }, { type: i3.BreakpointObserver }]; }, propDecorators: { backdrop: [{
                type: Input
            }], keyboard: [{
                type: Input
            }], placement: [{
                type: Input
            }], responsive: [{
                type: Input
            }], id: [{
                type: Input
            }], role: [{
                type: Input
            }, {
                type: HostBinding,
                args: ['attr.role']
            }], ariaModal: [{
                type: Input
            }, {
                type: HostBinding,
                args: ['attr.aria-modal']
            }], visibleChange: [{
                type: Output
            }], scroll: [{
                type: Input
            }], visible: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], ariaHidden: [{
                type: HostBinding,
                args: ['attr.aria-hidden']
            }], tabIndex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }], animateTrigger: [{
                type: HostBinding,
                args: ['@showHide']
            }], animateStart: [{
                type: HostListener,
                args: ['@showHide.start', ['$event']]
            }], animateDone: [{
                type: HostListener,
                args: ['@showHide.done', ['$event']]
            }], onKeyDownHandler: [{
                type: HostListener,
                args: ['document:keydown', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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