import { ContentChild, Directive, HostBinding, Input } from '@angular/core';
import { PlaceholderDirective } from './placeholder.directive';
import * as i0 from "@angular/core";
export class PlaceholderAnimationDirective {
    constructor() {
        this.animate = false;
    }
    get hostClasses() {
        return {
            [`placeholder-${this.animation}`]: this.animate && !!this.animation
        };
    }
    ngAfterContentInit() {
        this.animate = this.placeholder?.visible;
    }
}
PlaceholderAnimationDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: PlaceholderAnimationDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
PlaceholderAnimationDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: PlaceholderAnimationDirective, isStandalone: true, selector: "[cPlaceholderAnimation]", inputs: { animation: ["cPlaceholderAnimation", "animation"] }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "placeholder", first: true, predicate: PlaceholderDirective, descendants: true }], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: PlaceholderAnimationDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cPlaceholderAnimation]',
                    standalone: true
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { animation: [{
                type: Input,
                args: ['cPlaceholderAnimation']
            }], placeholder: [{
                type: ContentChild,
                args: [PlaceholderDirective]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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