import { Component, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty, coerceNumberProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class ProgressComponent {
    constructor() {
        this._height = 0;
        this._thin = false;
        this._white = false;
    }
    /**
     * Sets the height of the component. If you set that value the inner `<CProgressBar>` will automatically resize accordingly.
     * @type number
     */
    set height(value) {
        this._height = coerceNumberProperty(value);
    }
    get height() {
        return this._height;
    }
    /**
     * Displays thin progress.
     * @type boolean
     */
    set thin(value) {
        this._thin = coerceBooleanProperty(value);
    }
    get thin() {
        return this._thin;
    }
    /**
     * Change the default color to white.
     * @type boolean
     */
    get white() {
        return this._white;
    }
    set white(value) {
        this._white = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            progress: true,
            'progress-thin': this.thin,
            'progress-white': this.white
        };
    }
    get hostStyle() {
        return !!this.height ? `${this.height}px` : '';
    }
}
ProgressComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ProgressComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
ProgressComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: ProgressComponent, isStandalone: true, selector: "c-progress", inputs: { height: "height", thin: "thin", white: "white" }, host: { properties: { "class": "this.hostClasses", "style.height": "this.hostStyle" } }, ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ProgressComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-progress',
                    template: '<ng-content></ng-content>',
                    standalone: true
                }]
        }], propDecorators: { height: [{
                type: Input
            }], thin: [{
                type: Input
            }], white: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], hostStyle: [{
                type: HostBinding,
                args: ['style.height']
            }] } });
//# sourceMappingURL=data:application/json;base64,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