import { Component, HostBinding, Input } from '@angular/core';
import { NgClass, NgIf } from '@angular/common';
import { RouterLink } from '@angular/router';
import { HtmlAttributesDirective } from '../../shared';
import * as i0 from "@angular/core";
export class SidebarBrandComponent {
    constructor() {
        this.sidebarBrandClass = true;
        this.brandImg = false;
    }
    ngOnInit() {
        this.brandImg = Boolean(this.brandFull || this.brandNarrow);
    }
}
SidebarBrandComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarBrandComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
SidebarBrandComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: SidebarBrandComponent, isStandalone: true, selector: "c-sidebar-brand", inputs: { brandFull: "brandFull", brandNarrow: "brandNarrow", routerLink: "routerLink" }, host: { properties: { "class.sidebar-brand": "this.sidebarBrandClass" } }, ngImport: i0, template: "<ng-template [ngIf]=\"brandImg\">\n  <a [routerLink]=\"routerLink\">\n    <img *ngIf=\"brandFull\"\n         [cHtmlAttr]=\"brandFull\"\n         [ngClass]=\"'sidebar-brand-full'\">\n    <img *ngIf=\"brandNarrow\"\n         [cHtmlAttr]=\"brandNarrow\"\n         [ngClass]=\"'sidebar-brand-narrow'\">\n  </a>\n</ng-template>\n<ng-template [ngIf]=\"!brandImg\">\n  <ng-content></ng-content>\n</ng-template>\n", dependencies: [{ kind: "directive", type: RouterLink, selector: "[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarBrandComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-brand', standalone: true, imports: [RouterLink, HtmlAttributesDirective, NgIf, NgClass], template: "<ng-template [ngIf]=\"brandImg\">\n  <a [routerLink]=\"routerLink\">\n    <img *ngIf=\"brandFull\"\n         [cHtmlAttr]=\"brandFull\"\n         [ngClass]=\"'sidebar-brand-full'\">\n    <img *ngIf=\"brandNarrow\"\n         [cHtmlAttr]=\"brandNarrow\"\n         [ngClass]=\"'sidebar-brand-narrow'\">\n  </a>\n</ng-template>\n<ng-template [ngIf]=\"!brandImg\">\n  <ng-content></ng-content>\n</ng-template>\n" }]
        }], propDecorators: { brandFull: [{
                type: Input
            }], brandNarrow: [{
                type: Input
            }], routerLink: [{
                type: Input
            }], sidebarBrandClass: [{
                type: HostBinding,
                args: ['class.sidebar-brand']
            }] } });
//# sourceMappingURL=data:application/json;base64,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