import { Component, EventEmitter, Input, Output } from '@angular/core';
import { CommonModule, NgIf } from '@angular/common';
import { NavigationEnd, RouterModule } from '@angular/router';
import { filter } from 'rxjs/operators';
// import {SidebarService} from '../sidebar.service';
import { HtmlAttributesDirective } from '../../shared';
import { SidebarNavHelper } from './sidebar-nav.service';
import { SidebarNavLinkPipe } from './sidebar-nav-link.pipe';
import { SidebarNavBadgePipe } from './sidebar-nav-badge.pipe';
import { SidebarNavIconPipe } from './sidebar-nav-icon.pipe';
import { IconModule } from '@coreui/icons-angular';
import * as i0 from "@angular/core";
import * as i1 from "./sidebar-nav.service";
import * as i2 from "@angular/router";
import * as i3 from "@angular/common";
import * as i4 from "@coreui/icons-angular";
export class SidebarNavLinkContentComponent {
    constructor(helper) {
        this.helper = helper;
    }
}
SidebarNavLinkContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavLinkContentComponent, deps: [{ token: i1.SidebarNavHelper }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavLinkContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: SidebarNavLinkContentComponent, isStandalone: true, selector: "c-sidebar-nav-link-content", inputs: { item: "item" }, providers: [SidebarNavHelper], ngImport: i0, template: `
    <ng-container *ngIf="true">
      <ng-container>{{item?.name ?? ''}}</ng-container>
    </ng-container>
  `, isInline: true, dependencies: [{ kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavLinkContentComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-sidebar-nav-link-content',
                    template: `
    <ng-container *ngIf="true">
      <ng-container>{{item?.name ?? ''}}</ng-container>
    </ng-container>
  `,
                    providers: [SidebarNavHelper],
                    standalone: true,
                    imports: [NgIf]
                }]
        }], ctorParameters: function () { return [{ type: i1.SidebarNavHelper }]; }, propDecorators: { item: [{
                type: Input
            }] } });
export class SidebarNavLinkComponent {
    set item(item) {
        this._item = JSON.parse(JSON.stringify(item));
    }
    get item() {
        return this._item;
    }
    constructor(router
    // private renderer: Renderer2,
    // private hostElement: ElementRef,
    // private sidebarService: SidebarService
    ) {
        this.router = router;
        // tslint:disable-next-line:variable-name
        this._item = {};
        this.linkClick = new EventEmitter();
        this.navigationEndObservable = router.events.pipe(filter(event => {
            return event instanceof NavigationEnd;
        }));
    }
    ngOnInit() {
        // @ts-ignore
        this.url = typeof this.item.url === 'string' ? this.item.url : this.router.serializeUrl(this.router.createUrlTree(this.item.url));
        this.linkType = this.getLinkType();
        this.href = this.isDisabled() ? '' : (this.item.href || this.url);
        this.linkActive = this.router.url.split(/[?#(;]/)[0] === this.href.split(/[?#(;]/)[0];
        this.navSubscription = this.navigationEndObservable.subscribe(event => {
            const itemUrlArray = this.href.split(/[?#(;]/)[0].split('/');
            const urlArray = event.urlAfterRedirects.split(/[?#(;]/)[0].split('/');
            this.linkActive = itemUrlArray.every((value, index) => value === urlArray[index]);
        });
    }
    ngOnDestroy() {
        this.navSubscription?.unsubscribe();
    }
    getLinkType() {
        return this.isDisabled() ? 'disabled' : this.isExternalLink() ? 'external' : 'link';
    }
    isDisabled() {
        return this.item?.attributes?.['disabled'];
    }
    isExternalLink() {
        const linkPath = Array.isArray(this.item.url) ? this.item.url[0] : this.item.url;
        return !!this.item.href || linkPath.substring(0, 4) === 'http';
    }
    linkClicked() {
        this.linkClick.emit();
    }
}
SidebarNavLinkComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavLinkComponent, deps: [{ token: i2.Router }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavLinkComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: SidebarNavLinkComponent, isStandalone: true, selector: "c-sidebar-nav-link", inputs: { item: "item" }, outputs: { linkClick: "linkClick" }, providers: [SidebarNavHelper], ngImport: i0, template: "<ng-container [ngSwitch]=\"linkType\">\n  <a *ngSwitchCase=\"'disabled'\"\n     [ngClass]=\"item | cSidebarNavLink\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n  >\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n  <a *ngSwitchCase=\"'external'\"\n     [ngClass]=\"item | cSidebarNavLink\"\n     [href]=\"href\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n     (click)=\"linkClicked()\"\n  >\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n  <a *ngSwitchDefault\n     [ngClass]=\"item | cSidebarNavLink\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n     [target]=\"item.attributes?.['target']\"\n     [queryParams]=\"item.linkProps?.queryParams ?? null\"\n     [fragment]=\"item.linkProps?.fragment\"\n     [queryParamsHandling]=\"item.linkProps?.queryParamsHandling\"\n     [preserveFragment]=\"item.linkProps?.preserveFragment ?? false\"\n     [skipLocationChange]=\"item.linkProps?.skipLocationChange ?? false\"\n     [replaceUrl]=\"item.linkProps?.replaceUrl ?? false\"\n     [state]=\"item.linkProps?.state ?? {}\"\n     [routerLink]=\"item.url\"\n     routerLinkActive=\"active\"\n     [routerLinkActiveOptions]=\"item.linkProps?.routerLinkActiveOptions ?? { exact: false }\"\n     (click)=\"linkClicked()\"\n  >\n<!--    [class.active]=\"linkActive\"-->\n    <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n</ng-container>\n\n<ng-template #iconTemplate let-item>\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\n  <ng-template [ngIf]=\"item?.iconComponent\">\n    <svg\n      [cIcon]=\"item.iconComponent?.content\"\n      [name]=\"item.iconComponent?.name\"\n      [customClasses]=\"item | cSidebarNavIcon\"\n    ></svg>\n  </ng-template>\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\n</ng-template>\n", dependencies: [{ kind: "ngmodule", type: CommonModule }, { kind: "directive", type: i3.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i3.NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: i3.NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: i3.NgSwitchDefault, selector: "[ngSwitchDefault]" }, { kind: "ngmodule", type: RouterModule }, { kind: "directive", type: i2.RouterLink, selector: "[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i2.RouterLinkActive, selector: "[routerLinkActive]", inputs: ["routerLinkActiveOptions", "ariaCurrentWhenActive", "routerLinkActive"], outputs: ["isActiveChange"], exportAs: ["routerLinkActive"] }, { kind: "directive", type: HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "component", type: SidebarNavLinkContentComponent, selector: "c-sidebar-nav-link-content", inputs: ["item"] }, { kind: "pipe", type: SidebarNavLinkPipe, name: "cSidebarNavLink" }, { kind: "pipe", type: SidebarNavBadgePipe, name: "cSidebarNavBadge" }, { kind: "pipe", type: SidebarNavIconPipe, name: "cSidebarNavIcon" }, { kind: "ngmodule", type: IconModule }, { kind: "directive", type: i4.IconDirective, selector: "svg[cIcon]", inputs: ["cIcon", "size", "title", "customClasses", "width", "height", "name", "viewBox", "xmlns", "pointer-events", "role"], exportAs: ["cIcon"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavLinkComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav-link', providers: [SidebarNavHelper], standalone: true, imports: [CommonModule, RouterModule, HtmlAttributesDirective, SidebarNavLinkContentComponent, SidebarNavLinkPipe, SidebarNavBadgePipe, SidebarNavIconPipe, IconModule], template: "<ng-container [ngSwitch]=\"linkType\">\n  <a *ngSwitchCase=\"'disabled'\"\n     [ngClass]=\"item | cSidebarNavLink\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n  >\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n  <a *ngSwitchCase=\"'external'\"\n     [ngClass]=\"item | cSidebarNavLink\"\n     [href]=\"href\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n     (click)=\"linkClicked()\"\n  >\n    <ng-container *ngTemplateOutlet=\"iconTemplate; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n  <a *ngSwitchDefault\n     [ngClass]=\"item | cSidebarNavLink\"\n     [cHtmlAttr]=\"item.attributes ?? {}\"\n     [target]=\"item.attributes?.['target']\"\n     [queryParams]=\"item.linkProps?.queryParams ?? null\"\n     [fragment]=\"item.linkProps?.fragment\"\n     [queryParamsHandling]=\"item.linkProps?.queryParamsHandling\"\n     [preserveFragment]=\"item.linkProps?.preserveFragment ?? false\"\n     [skipLocationChange]=\"item.linkProps?.skipLocationChange ?? false\"\n     [replaceUrl]=\"item.linkProps?.replaceUrl ?? false\"\n     [state]=\"item.linkProps?.state ?? {}\"\n     [routerLink]=\"item.url\"\n     routerLinkActive=\"active\"\n     [routerLinkActiveOptions]=\"item.linkProps?.routerLinkActiveOptions ?? { exact: false }\"\n     (click)=\"linkClicked()\"\n  >\n<!--    [class.active]=\"linkActive\"-->\n    <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\n    <c-sidebar-nav-link-content [item]=\"item\"></c-sidebar-nav-link-content>\n    <span *ngIf=\"item.badge\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge?.text }}</span>\n  </a>\n</ng-container>\n\n<ng-template #iconTemplate let-item>\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\n  <ng-template [ngIf]=\"item?.iconComponent\">\n    <svg\n      [cIcon]=\"item.iconComponent?.content\"\n      [name]=\"item.iconComponent?.name\"\n      [customClasses]=\"item | cSidebarNavIcon\"\n    ></svg>\n  </ng-template>\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\n</ng-template>\n" }]
        }], ctorParameters: function () { return [{ type: i2.Router }]; }, propDecorators: { item: [{
                type: Input
            }], linkClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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