import { animate, state, style, transition, trigger } from '@angular/animations';
import { NgClass, NgForOf, NgIf, NgStyle, NgSwitch, NgSwitchCase, NgSwitchDefault, NgTemplateOutlet } from '@angular/common';
import { Component, ElementRef, forwardRef, HostBinding, Input, Optional, ViewChild } from '@angular/core';
import { NavigationEnd, RouterModule } from '@angular/router';
import { filter } from 'rxjs/operators';
import { SidebarNavHelper } from './sidebar-nav.service';
import { SidebarNavGroupService } from './sidebar-nav-group.service';
import { HtmlAttributesDirective } from '../../shared';
import { IconModule } from '@coreui/icons-angular';
import { SidebarNavIconPipe } from './sidebar-nav-icon.pipe';
import { SidebarNavBadgePipe } from './sidebar-nav-badge.pipe';
import { SidebarNavLinkComponent } from './sidebar-nav-link.component';
import { SidebarNavLabelComponent } from './sidebar-nav-label.component';
import { SidebarNavTitleComponent } from './sidebar-nav-title.component';
import { SidebarNavDividerComponent } from './sidebar-nav-divider.component';
import { SidebarNavItemClassPipe } from './sidebar-nav-item-class.pipe';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "./sidebar-nav.service";
import * as i3 from "./sidebar-nav-group.service";
import * as i4 from "@coreui/icons-angular";
import * as i5 from "../sidebar/sidebar.component";
import * as i6 from "../sidebar.service";
export class SidebarNavGroupComponent {
    constructor(router, renderer, hostElement, helper, sidebarNavGroupService) {
        this.router = router;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.helper = helper;
        this.sidebarNavGroupService = sidebarNavGroupService;
        this.dropdownMode = 'path';
        this.navItems = [];
        this.display = { display: 'block' };
        this.navigationEndObservable = router.events.pipe(filter((event) => event instanceof NavigationEnd));
    }
    get hostClasses() {
        return {
            'nav-group': true,
            show: this.open
        };
    }
    ngOnInit() {
        this.navItems = [...this.item.children];
        this.navSubscription = this.navigationEndObservable.subscribe((event) => {
            if (this.dropdownMode !== 'none') {
                const samePath = this.samePath(event.url);
                this.openGroup(samePath);
            }
        });
        if (this.samePath(this.router.routerState.snapshot.url)) {
            this.openGroup(true);
        }
        this.navGroupSubscription = this.sidebarNavGroupService.sidebarNavGroupState$.subscribe(next => {
            if (this.dropdownMode === 'close' && next.sidebarNavGroup && next.sidebarNavGroup !== this) {
                if (next.sidebarNavGroup.item.url.startsWith(this.item.url)) {
                    return;
                }
                if (this.samePath(this.router.routerState.snapshot.url)) {
                    this.openGroup(true);
                    return;
                }
                this.openGroup(false);
            }
        });
    }
    samePath(url) {
        // console.log('item:', this.item.name, this.item.url, 'url:', url);
        const itemArray = this.item.url?.split('/');
        const urlArray = url.split('/');
        return itemArray?.every((value, index) => {
            // console.log(value === urlArray[index], 'value:', value, 'index:', index, urlArray[index], url);
            return value === urlArray[index];
        });
    }
    openGroup(open) {
        this.open = open;
    }
    toggleGroup($event) {
        $event.preventDefault();
        this.openGroup(!this.open);
        if (this.open) {
            this.sidebarNavGroupService.toggle({ open: this.open, sidebarNavGroup: this });
        }
    }
    ngOnDestroy() {
        this.navSubscription?.unsubscribe();
    }
    onAnimationStart($event) {
        this.display = { display: 'block' };
        if ($event.toState === 'open') {
            const host = this.sidebarNav.nativeElement;
            this.renderer.setStyle(host, 'height', `${host['scrollHeight']}px`);
        }
    }
    onAnimationDone($event) {
        if ($event.toState === 'open') {
            const host = this.sidebarNav.nativeElement;
            this.renderer.setStyle(host, 'height', 'auto');
        }
        if ($event.toState === 'closed') {
            setTimeout(() => {
                this.display = null;
            });
        }
    }
}
SidebarNavGroupComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavGroupComponent, deps: [{ token: i1.Router }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i2.SidebarNavHelper }, { token: i3.SidebarNavGroupService }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavGroupComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: SidebarNavGroupComponent, isStandalone: true, selector: "c-sidebar-nav-group", inputs: { item: "item", dropdownMode: "dropdownMode", show: "show" }, host: { properties: { "class": "this.hostClasses" } }, providers: [SidebarNavHelper, SidebarNavGroupService], viewQueries: [{ propertyName: "sidebarNav", first: true, predicate: i0.forwardRef(function () { return SidebarNavComponent; }), descendants: true, read: ElementRef }], ngImport: i0, template: "<a (click)=\"toggleGroup($event)\"\n   [cHtmlAttr]=\"item.attributes\"\n   class=\"nav-link nav-group-toggle\"\n   href>\n  <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\n  <ng-container>{{ item.name }}</ng-container>\n  <span *ngIf=\"helper.hasBadge(item)\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge.text }}</span>\n</a>\n<c-sidebar-nav\n  (@openClose.done)=\"onAnimationDone($event)\"\n  (@openClose.start)=\"onAnimationStart($event)\"\n  [@openClose]=\"open ? 'open' : 'closed'\"\n  [dropdownMode]=\"dropdownMode\"\n  [groupItems]=\"true\"\n  [navItems]=\"navItems\"\n  [ngStyle]=\"display\"\n>\n</c-sidebar-nav>\n\n<ng-template #iconTemplate let-item>\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\n  <ng-template [ngIf]=\"item?.iconComponent\">\n    <svg\n      [cIcon]=\"item.iconComponent?.content\"\n      [customClasses]=\"item | cSidebarNavIcon\"\n      [name]=\"item.iconComponent?.name\"\n    ></svg>\n  </ng-template>\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\n</ng-template>\n", styles: [".nav-group-toggle{cursor:pointer}.nav-group-items{display:block}\n"], dependencies: [{ kind: "directive", type: i0.forwardRef(function () { return HtmlAttributesDirective; }), selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "directive", type: i0.forwardRef(function () { return NgTemplateOutlet; }), selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i0.forwardRef(function () { return NgIf; }), selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i0.forwardRef(function () { return NgClass; }), selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "ngmodule", type: i0.forwardRef(function () { return IconModule; }) }, { kind: "directive", type: i0.forwardRef(function () { return i4.IconDirective; }), selector: "svg[cIcon]", inputs: ["cIcon", "size", "title", "customClasses", "width", "height", "name", "viewBox", "xmlns", "pointer-events", "role"], exportAs: ["cIcon"] }, { kind: "pipe", type: i0.forwardRef(function () { return SidebarNavIconPipe; }), name: "cSidebarNavIcon" }, { kind: "pipe", type: i0.forwardRef(function () { return SidebarNavBadgePipe; }), name: "cSidebarNavBadge" }, { kind: "component", type: i0.forwardRef(function () { return SidebarNavComponent; }), selector: "c-sidebar-nav", inputs: ["navItems", "dropdownMode", "groupItems", "compact"] }, { kind: "directive", type: i0.forwardRef(function () { return NgStyle; }), selector: "[ngStyle]", inputs: ["ngStyle"] }], animations: [
        trigger('openClose', [
            state('open', style({
                height: '*'
            })),
            state('closed', style({
                height: '0px'
            })),
            transition('open <=> closed', [
                animate('.15s ease')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavGroupComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav-group', providers: [SidebarNavHelper, SidebarNavGroupService], standalone: true, imports: [
                        HtmlAttributesDirective,
                        NgTemplateOutlet,
                        NgIf,
                        NgClass,
                        IconModule,
                        SidebarNavIconPipe,
                        SidebarNavBadgePipe,
                        forwardRef(() => SidebarNavComponent),
                        NgStyle
                    ], animations: [
                        trigger('openClose', [
                            state('open', style({
                                height: '*'
                            })),
                            state('closed', style({
                                height: '0px'
                            })),
                            transition('open <=> closed', [
                                animate('.15s ease')
                            ])
                        ])
                    ], template: "<a (click)=\"toggleGroup($event)\"\n   [cHtmlAttr]=\"item.attributes\"\n   class=\"nav-link nav-group-toggle\"\n   href>\n  <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\n  <ng-container>{{ item.name }}</ng-container>\n  <span *ngIf=\"helper.hasBadge(item)\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge.text }}</span>\n</a>\n<c-sidebar-nav\n  (@openClose.done)=\"onAnimationDone($event)\"\n  (@openClose.start)=\"onAnimationStart($event)\"\n  [@openClose]=\"open ? 'open' : 'closed'\"\n  [dropdownMode]=\"dropdownMode\"\n  [groupItems]=\"true\"\n  [navItems]=\"navItems\"\n  [ngStyle]=\"display\"\n>\n</c-sidebar-nav>\n\n<ng-template #iconTemplate let-item>\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\n  <ng-template [ngIf]=\"item?.iconComponent\">\n    <svg\n      [cIcon]=\"item.iconComponent?.content\"\n      [customClasses]=\"item | cSidebarNavIcon\"\n      [name]=\"item.iconComponent?.name\"\n    ></svg>\n  </ng-template>\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\n</ng-template>\n", styles: [".nav-group-toggle{cursor:pointer}.nav-group-items{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.Router }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i2.SidebarNavHelper }, { type: i3.SidebarNavGroupService }]; }, propDecorators: { item: [{
                type: Input
            }], dropdownMode: [{
                type: Input
            }], show: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], sidebarNav: [{
                type: ViewChild,
                args: [forwardRef(() => SidebarNavComponent), { read: ElementRef }]
            }] } });
export class SidebarNavComponent {
    constructor(sidebar, helper, router, renderer, hostElement, sidebarService) {
        this.sidebar = sidebar;
        this.helper = helper;
        this.router = router;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.sidebarService = sidebarService;
        this.navItems = [];
        this.dropdownMode = 'path';
        this.role = 'nav';
        this.navItemsArray = [];
    }
    get hostClasses() {
        return {
            'sidebar-nav': !this.groupItems,
            compact: !this.groupItems && !!this.compact
        };
    }
    get sidebarNavGroupItemsClass() {
        return !!this.groupItems;
    }
    ngOnChanges(changes) {
        this.navItemsArray = Array.isArray(this.navItems) ? this.navItems.slice() : [];
    }
    hideMobile() {
        // todo: proper scrollIntoView() after NavigationEnd
        if (this.sidebar && this.sidebar.sidebarState.mobile) {
            this.sidebarService.toggle({ toggle: 'visible', sidebar: this.sidebar });
        }
    }
}
SidebarNavComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavComponent, deps: [{ token: i5.SidebarComponent, optional: true }, { token: i2.SidebarNavHelper }, { token: i1.Router }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i6.SidebarService }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: SidebarNavComponent, isStandalone: true, selector: "c-sidebar-nav", inputs: { navItems: "navItems", dropdownMode: "dropdownMode", groupItems: "groupItems", compact: "compact" }, host: { properties: { "class": "this.hostClasses", "class.nav-group-items": "this.sidebarNavGroupItemsClass", "attr.role": "this.role" } }, usesOnChanges: true, ngImport: i0, template: "<ng-container *ngFor=\"let item of navItemsArray\">\n  <ng-container [ngSwitch]=\"helper.itemType(item)\">\n    <c-sidebar-nav-group\n      #rla=\"routerLinkActive\"\n      *ngSwitchCase=\"'group'\"\n      [dropdownMode]=\"dropdownMode\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\"\n      [routerLinkActiveOptions]=\"{exact: true}\"\n      routerLinkActive=\"show\"\n    >\n    </c-sidebar-nav-group>\n    <c-sidebar-nav-divider\n      *ngSwitchCase=\"'divider'\"\n      [cHtmlAttr]=\"item.attributes ?? {}\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-divider>\n    <c-sidebar-nav-title\n      *ngSwitchCase=\"'title'\"\n      [cHtmlAttr]=\"item.attributes ?? {}\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-title>\n    <c-sidebar-nav-label\n      *ngSwitchCase=\"'label'\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-label>\n    <ng-container\n      *ngSwitchCase=\"'empty'\">\n    </ng-container>\n    <c-sidebar-nav-link\n      (linkClick)=\"hideMobile()\"\n      *ngSwitchDefault\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\"\n    >\n    </c-sidebar-nav-link>\n  </ng-container>\n</ng-container>\n<ng-content></ng-content>\n", dependencies: [{ kind: "directive", type: NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: NgSwitchDefault, selector: "[ngSwitchDefault]" }, { kind: "directive", type: HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "component", type: SidebarNavLinkComponent, selector: "c-sidebar-nav-link", inputs: ["item"], outputs: ["linkClick"] }, { kind: "component", type: SidebarNavLabelComponent, selector: "c-sidebar-nav-label", inputs: ["item"] }, { kind: "component", type: SidebarNavTitleComponent, selector: "c-sidebar-nav-title", inputs: ["item"] }, { kind: "component", type: SidebarNavDividerComponent, selector: "c-sidebar-nav-divider", inputs: ["item"] }, { kind: "component", type: SidebarNavGroupComponent, selector: "c-sidebar-nav-group", inputs: ["item", "dropdownMode", "show"] }, { kind: "pipe", type: SidebarNavItemClassPipe, name: "cSidebarNavItemClass" }, { kind: "ngmodule", type: RouterModule }, { kind: "directive", type: i1.RouterLinkActive, selector: "[routerLinkActive]", inputs: ["routerLinkActiveOptions", "ariaCurrentWhenActive", "routerLinkActive"], outputs: ["isActiveChange"], exportAs: ["routerLinkActive"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: SidebarNavComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav', standalone: true, imports: [
                        NgForOf,
                        NgClass,
                        NgSwitch,
                        NgSwitchCase,
                        NgSwitchDefault,
                        HtmlAttributesDirective,
                        SidebarNavLinkComponent,
                        SidebarNavLabelComponent,
                        SidebarNavTitleComponent,
                        SidebarNavDividerComponent,
                        SidebarNavGroupComponent,
                        SidebarNavItemClassPipe,
                        RouterModule
                    ], template: "<ng-container *ngFor=\"let item of navItemsArray\">\n  <ng-container [ngSwitch]=\"helper.itemType(item)\">\n    <c-sidebar-nav-group\n      #rla=\"routerLinkActive\"\n      *ngSwitchCase=\"'group'\"\n      [dropdownMode]=\"dropdownMode\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\"\n      [routerLinkActiveOptions]=\"{exact: true}\"\n      routerLinkActive=\"show\"\n    >\n    </c-sidebar-nav-group>\n    <c-sidebar-nav-divider\n      *ngSwitchCase=\"'divider'\"\n      [cHtmlAttr]=\"item.attributes ?? {}\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-divider>\n    <c-sidebar-nav-title\n      *ngSwitchCase=\"'title'\"\n      [cHtmlAttr]=\"item.attributes ?? {}\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-title>\n    <c-sidebar-nav-label\n      *ngSwitchCase=\"'label'\"\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\">\n    </c-sidebar-nav-label>\n    <ng-container\n      *ngSwitchCase=\"'empty'\">\n    </ng-container>\n    <c-sidebar-nav-link\n      (linkClick)=\"hideMobile()\"\n      *ngSwitchDefault\n      [item]=\"item\"\n      [ngClass]=\"item | cSidebarNavItemClass\"\n    >\n    </c-sidebar-nav-link>\n  </ng-container>\n</ng-container>\n<ng-content></ng-content>\n" }]
        }], ctorParameters: function () { return [{ type: i5.SidebarComponent, decorators: [{
                    type: Optional
                }] }, { type: i2.SidebarNavHelper }, { type: i1.Router }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i6.SidebarService }]; }, propDecorators: { navItems: [{
                type: Input
            }], dropdownMode: [{
                type: Input
            }], groupItems: [{
                type: Input
            }], compact: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], sidebarNavGroupItemsClass: [{
                type: HostBinding,
                args: ['class.nav-group-items']
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }] } });
//# sourceMappingURL=data:application/json;base64,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