import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class TableDirective {
    /**
     * Add borders on all sides of the table and cells.
     * @type boolean
     */
    set bordered(value) {
        this._bordered = coerceBooleanProperty(value);
    }
    ;
    get bordered() {
        return this._bordered;
    }
    /**
     * Remove borders on all sides of the table and cells.
     * @type boolean
     */
    set borderless(value) {
        this._borderless = coerceBooleanProperty(value);
    }
    ;
    get borderless() {
        return this._borderless;
    }
    /**
     * Enable a hover state on table rows within table body.
     * @type boolean
     */
    set hover(value) {
        this._hover = coerceBooleanProperty(value);
    }
    ;
    get hover() {
        return this._hover;
    }
    /**
     * Make table more compact by cutting all cell `padding` in half.
     * @type boolean
     */
    set small(value) {
        this._small = coerceBooleanProperty(value);
    }
    ;
    get small() {
        return this._small;
    }
    /**
     * Add zebra-striping to any table row within the table body.
     * @type boolean
     */
    set striped(value) {
        this._striped = coerceBooleanProperty(value);
    }
    ;
    get striped() {
        return this._striped;
    }
    /**
     * Add zebra-striping to any table column.
     * @type boolean
     * @since 4.2.4
     */
    set stripedColumns(value) {
        this._stripedColumns = coerceBooleanProperty(value);
    }
    ;
    get stripedColumns() {
        return this._stripedColumns;
    }
    constructor(renderer, hostElement) {
        this.renderer = renderer;
        this.hostElement = hostElement;
        this._bordered = false;
        this._borderless = false;
        this._hover = false;
        this._small = false;
        this._striped = false;
        this._stripedColumns = false;
    }
    get hostClasses() {
        return {
            table: true,
            [`align-${this.align}`]: !!this.align,
            [`caption-${this.caption}`]: !!this.caption,
            [`border-${this.borderColor}`]: !!this.borderColor,
            'table-bordered': this.bordered,
            'table-borderless': this.borderless,
            [`table-${this.color}`]: !!this.color,
            'table-hover': this.hover,
            'table-sm': this.small,
            'table-striped': this.striped,
            'table-striped-columns': this.stripedColumns
        };
    }
    ngOnInit() {
        this.setResponsiveWrapper();
    }
    // todo
    setResponsiveWrapper() {
        if (!!this.responsive) {
            const nativeElement = this.hostElement.nativeElement;
            const wrapper = this.renderer.createElement('div');
            const className = this.responsive === true ? 'table-responsive' : `table-responsive-${this.responsive}`;
            this.renderer.addClass(wrapper, className);
            const parentNode = this.renderer.parentNode(nativeElement);
            this.renderer.appendChild(parentNode, wrapper);
            this.renderer.insertBefore(parentNode, wrapper, nativeElement);
            this.renderer.appendChild(wrapper, nativeElement);
        }
    }
}
TableDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: TableDirective, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
TableDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: TableDirective, isStandalone: true, selector: "[cTable]", inputs: { align: "align", borderColor: "borderColor", bordered: "bordered", borderless: "borderless", caption: "caption", color: "color", hover: "hover", responsive: "responsive", small: "small", striped: "striped", stripedColumns: "stripedColumns" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: TableDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cTable]',
                    standalone: true
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, propDecorators: { align: [{
                type: Input
            }], borderColor: [{
                type: Input
            }], bordered: [{
                type: Input
            }], borderless: [{
                type: Input
            }], caption: [{
                type: Input
            }], color: [{
                type: Input
            }], hover: [{
                type: Input
            }], responsive: [{
                type: Input
            }], small: [{
                type: Input
            }], striped: [{
                type: Input
            }], stripedColumns: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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