import { Component, EventEmitter, HostBinding, HostListener, Input, Output, } from '@angular/core';
import { animate, state, style, transition, trigger } from '@angular/animations';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
import * as i1 from "../toaster/toaster.service";
export class ToastComponent {
    /**
     * Toggle the visibility of component.
     * @type boolean
     */
    set visible(value) {
        const newValue = coerceBooleanProperty(value);
        if (this._visible !== newValue) {
            this._visible = newValue;
            newValue ? this.setTimer() : this.clearTimer();
            this.visibleChange.emit(newValue);
            this.changeDetectorRef.markForCheck();
        }
    }
    get visible() {
        return this._visible;
    }
    constructor(hostElement, renderer, toasterService, changeDetectorRef) {
        this.hostElement = hostElement;
        this.renderer = renderer;
        this.toasterService = toasterService;
        this.changeDetectorRef = changeDetectorRef;
        /**
         * Auto hide the toast.
         * @type boolean
         */
        this.autohide = true;
        /**
         * Sets the color context of the component to one of CoreUI’s themed colors.
         * @type Colors
         */
        this.color = '';
        /**
         * Delay hiding the toast (ms).
         * @type number
         */
        this.delay = 5000;
        /**
         * Apply fade transition to the toast.
         * @type boolean
         */
        this.fade = true;
        this._visible = false;
        /**
         * Event emitted on visibility change. [docs]
         * @type boolean
         */
        this.visibleChange = new EventEmitter();
        /**
         * Event emitted on timer tick. [docs]
         * @type number
         */
        this.timer = new EventEmitter();
    }
    get clock() {
        return this._clock;
    }
    set clock(value) {
        this._clock = value;
        this.timer.emit(this._clock);
        this.changeDetectorRef.markForCheck();
    }
    get animationDisabled() {
        return !this.fade;
    }
    get animateType() {
        return this.visible ? 'show' : 'hide';
    }
    onAnimationStart($event) {
        this.onAnimationEvent($event);
    }
    onAnimationDone($event) {
        this.onAnimationEvent($event);
    }
    onMouseOver() {
        this.clearTimer();
    }
    onMouseOut() {
        this.setTimer();
    }
    get hostClasses() {
        return {
            toast: true,
            fade: this.fade,
            show: !this.hide,
            [`bg-${this.color}`]: !!this.color,
            'border-0': !!this.color
        };
    }
    ngOnInit() {
        if (this.visible) {
            this.toasterService.setState({
                toast: this,
                show: this.visible,
                placement: this.placement,
            });
            this.clearTimer();
            this.setTimer();
        }
    }
    ngOnDestroy() {
        this.clearTimer();
    }
    setTimer() {
        this.clearTimer();
        if (this.autohide && this.visible) {
            this.timerId = this.delay > 0 ? setTimeout(() => this.onClose(), this.delay) : null;
            this.setClock();
        }
    }
    clearTimer() {
        this.clearClock();
        clearTimeout(this.timerId);
        this.timerId = null;
    }
    onClose() {
        this.clearTimer();
        this.toasterService.setState({
            toast: this,
            show: false,
            placement: this.placement,
        });
    }
    setClock() {
        this.clearClock();
        this.clock = 0;
        this.clockId = setInterval(() => {
            this.clock += 1;
            this.changeDetectorRef.markForCheck();
        }, 1000);
        this.clockTimerId = setTimeout(() => {
            this.clearClock();
        }, this.delay);
    }
    clearClock() {
        clearTimeout(this.clockTimerId);
        clearInterval(this.clockId);
        this.clockId = null;
    }
    onAnimationEvent(event) {
        this.hide = event.phaseName === 'start' && event.toState === 'show';
        if (event.phaseName === 'done') {
            this.hide = (event.toState === 'hide' || event.toState === 'void');
            if (event.toState === 'show') {
                this.hide = false;
            }
        }
    }
}
ToastComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ToastComponent, deps: [{ token: i0.ElementRef }, { token: i0.Renderer2 }, { token: i1.ToasterService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
ToastComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: ToastComponent, isStandalone: true, selector: "c-toast", inputs: { autohide: "autohide", color: "color", delay: "delay", fade: "fade", visible: "visible", index: "index" }, outputs: { visibleChange: "visibleChange", timer: "timer" }, host: { listeners: { "@fadeInOut.start": "onAnimationStart($event)", "@fadeInOut.done": "onAnimationDone($event)", "mouseover": "onMouseOver()", "mouseout": "onMouseOut()" }, properties: { "@.disabled": "this.animationDisabled", "@fadeInOut": "this.animateType", "class": "this.hostClasses" } }, exportAs: ["cToast"], ngImport: i0, template: `<ng-content></ng-content>`, isInline: true, styles: [":host{display:block;overflow:hidden}\n"], animations: [
        trigger('fadeInOut', [
            state('show', style({ opacity: 1, height: '*', padding: '*', border: '*', margin: '*' })),
            state('hide', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
            state('void', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
            transition('show => hide', [
                animate('{{ time }} {{ easing }}'),
            ], {
                params: { time: '300ms', easing: 'ease-out' }
            }),
            transition('hide => show', [animate('{{ time }} {{ easing }}')], {
                params: { time: '300ms', easing: 'ease-in' },
            }),
            transition('show => void', [animate('{{ time }} {{ easing }}')], {
                params: { time: '300ms', easing: 'ease-out' },
            }),
            transition('void => show', [animate('{{ time }} {{ easing }}')], {
                params: { time: '300ms', easing: 'ease-in' },
            }),
        ]),
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ToastComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-toast', template: `<ng-content></ng-content>`, exportAs: 'cToast', standalone: true, animations: [
                        trigger('fadeInOut', [
                            state('show', style({ opacity: 1, height: '*', padding: '*', border: '*', margin: '*' })),
                            state('hide', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
                            state('void', style({ opacity: 0, height: 0, padding: 0, border: 0, margin: 0 })),
                            transition('show => hide', [
                                animate('{{ time }} {{ easing }}'),
                            ], {
                                params: { time: '300ms', easing: 'ease-out' }
                            }),
                            transition('hide => show', [animate('{{ time }} {{ easing }}')], {
                                params: { time: '300ms', easing: 'ease-in' },
                            }),
                            transition('show => void', [animate('{{ time }} {{ easing }}')], {
                                params: { time: '300ms', easing: 'ease-out' },
                            }),
                            transition('void => show', [animate('{{ time }} {{ easing }}')], {
                                params: { time: '300ms', easing: 'ease-in' },
                            }),
                        ]),
                    ], styles: [":host{display:block;overflow:hidden}\n"] }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i1.ToasterService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { autohide: [{
                type: Input
            }], color: [{
                type: Input
            }], delay: [{
                type: Input
            }], fade: [{
                type: Input
            }], visible: [{
                type: Input
            }], index: [{
                type: Input
            }], visibleChange: [{
                type: Output
            }], timer: [{
                type: Output
            }], animationDisabled: [{
                type: HostBinding,
                args: ['@.disabled']
            }], animateType: [{
                type: HostBinding,
                args: ['@fadeInOut']
            }], onAnimationStart: [{
                type: HostListener,
                args: ['@fadeInOut.start', ['$event']]
            }], onAnimationDone: [{
                type: HostListener,
                args: ['@fadeInOut.done', ['$event']]
            }], onMouseOver: [{
                type: HostListener,
                args: ['mouseover']
            }], onMouseOut: [{
                type: HostListener,
                args: ['mouseout']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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