import { Component, ContentChildren, HostBinding, Input, VERSION, ViewChild, ViewContainerRef } from '@angular/core';
import { ToasterHostDirective } from './toaster-host.directive';
import { ToastComponent } from '../toast/toast.component';
import * as i0 from "@angular/core";
import * as i1 from "./toaster.service";
export var ToasterPlacement;
(function (ToasterPlacement) {
    ToasterPlacement["Static"] = "static";
    ToasterPlacement["TopStart"] = "top-start";
    ToasterPlacement["TopCenter"] = "top-center";
    ToasterPlacement["TopEnd"] = "top-end";
    ToasterPlacement["MiddleStart"] = "middle-start";
    ToasterPlacement["MiddleCenter"] = "middle-center";
    ToasterPlacement["MiddleEnd"] = "middle-end";
    ToasterPlacement["BottomStart"] = "bottom-start";
    ToasterPlacement["BottomCenter"] = "bottom-center";
    ToasterPlacement["BottomEnd"] = "bottom-end";
})(ToasterPlacement || (ToasterPlacement = {}));
export class ToasterComponent {
    constructor(componentFactoryResolver, hostElement, renderer, toasterService) {
        this.componentFactoryResolver = componentFactoryResolver;
        this.hostElement = hostElement;
        this.renderer = renderer;
        this.toasterService = toasterService;
        this.placements = Object.values(ToasterPlacement);
        this.toastsDynamic = [];
        /**
         * Toaster placement
         * @type TToasterPlacement
         */
        this.placement = ToasterPlacement.TopEnd;
        /**
         * Toaster position
         * @type (string | 'absolute' | 'fixed' | 'static')
         */
        this.position = 'absolute';
    }
    get hostClasses() {
        return {
            toaster: true,
            'toast-container': true,
            [`position-${this.position}`]: !!this.position,
            'top-0': this.placement.includes('top'),
            'top-50': this.placement.includes('middle'),
            'bottom-0': this.placement.includes('bottom'),
            'start-0': this.placement.includes('start'),
            'start-50': this.placement.includes('center'),
            'end-0': this.placement.includes('end'),
            'translate-middle-x': this.placement.includes('center') && !this.placement.includes('middle'),
            'translate-middle-y': this.placement.includes('middle') && !this.placement.includes('center'),
            'translate-middle': this.placement.includes('middle') && this.placement.includes('center'),
        };
    }
    ngOnInit() {
        this.stateToasterSubscribe(true);
    }
    ngOnDestroy() {
        this.stateToasterSubscribe(false);
    }
    ngAfterContentChecked() {
        this.toasts = this.contentToasts;
    }
    addToast(toast, props, options) {
        let componentRef;
        if (parseInt(VERSION.major) < 13) {
            const factory = this.componentFactoryResolver.resolveComponentFactory(toast);
            componentRef = this.toasterHost.viewContainerRef.createComponent(factory, options?.index, options?.injector, options?.projectableNodes, options?.ngModuleRef);
        }
        else {
            // @ts-ignore
            componentRef = this.toasterHost.viewContainerRef.createComponent(toast, options);
        }
        this.toastsDynamic.push(componentRef);
        const index = this.toastsDynamic.indexOf(componentRef);
        for (const [key, value] of Object.entries(props)) {
            componentRef.instance[key] = value;
        }
        componentRef.instance['placement'] = this.placement;
        componentRef.instance['dynamic'] = true;
        componentRef.instance['index'] = index;
        componentRef.instance['visible'] = true;
        componentRef.instance['visibleChange'].emit(true);
        componentRef.changeDetectorRef?.detectChanges();
        return componentRef;
    }
    removeToast(state) {
        this.toastsDynamic?.forEach(item => {
            if (state.toast?.dynamic && (item.instance === state.toast)) {
                item.instance.visible = false;
                item.instance['visibleChange'].emit(false);
                setTimeout(() => {
                    item.destroy();
                }, 300);
            }
        });
        this.toasts?.forEach(item => {
            if (item.element.nativeElement === state.toast?.hostElement.nativeElement) {
                if (!state.toast?.dynamic) {
                    // @ts-ignore
                    state.toast.visible = false;
                }
            }
        });
    }
    stateToasterSubscribe(subscribe = true) {
        if (subscribe) {
            this.stateToasterSubscription = this.toasterService.toasterState$.subscribe((state) => {
                if (state.show === false) {
                    this.removeToast(state);
                }
                if (state.show === true && state.toast?.dynamic === undefined) {
                }
            });
        }
        else {
            this.stateToasterSubscription?.unsubscribe();
        }
    }
}
ToasterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ToasterComponent, deps: [{ token: i0.ComponentFactoryResolver }, { token: i0.ElementRef }, { token: i0.Renderer2 }, { token: i1.ToasterService }], target: i0.ɵɵFactoryTarget.Component });
ToasterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: ToasterComponent, isStandalone: true, selector: "c-toaster", inputs: { placement: "placement", position: "position" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentToasts", predicate: ToastComponent, read: ViewContainerRef }], viewQueries: [{ propertyName: "toasterHost", first: true, predicate: ToasterHostDirective, descendants: true, static: true }], exportAs: ["cToaster"], ngImport: i0, template: "<ng-template cToasterHost></ng-template>\n<ng-content cToasterHost></ng-content>\n", dependencies: [{ kind: "directive", type: ToasterHostDirective, selector: "[cToasterHost]", exportAs: ["cToasterHost"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: ToasterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-toaster', exportAs: 'cToaster', standalone: true, imports: [ToasterHostDirective], template: "<ng-template cToasterHost></ng-template>\n<ng-content cToasterHost></ng-content>\n" }]
        }], ctorParameters: function () { return [{ type: i0.ComponentFactoryResolver }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i1.ToasterService }]; }, propDecorators: { placement: [{
                type: Input
            }], position: [{
                type: Input
            }], toasterHost: [{
                type: ViewChild,
                args: [ToasterHostDirective, { static: true }]
            }], contentToasts: [{
                type: ContentChildren,
                args: [ToastComponent, { read: ViewContainerRef }]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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