import { Directive, HostBinding, Inject, Input } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { createPopper } from '@popperjs/core';
import { TooltipComponent } from './tooltip/tooltip.component';
import { ListenersService } from '../services/listeners.service';
import * as i0 from "@angular/core";
import * as i1 from "../services/listeners.service";
export class TooltipDirective {
    /**
     * Optional popper Options object, takes precedence over cPopoverPlacement prop
     * @type Partial<Options>
     */
    set popperOptions(value) {
        this._popperOptions = { ...this._popperOptions, placement: this.placement, ...value };
    }
    ;
    get popperOptions() {
        return { placement: this.placement, ...this._popperOptions };
    }
    /**
     * Toggle the visibility of tooltip component.
     */
    set visible(value) {
        this._visible = value;
    }
    get visible() {
        return this._visible;
    }
    get ariaDescribedBy() {
        return this.tooltipId ? this.tooltipId : null;
    }
    constructor(document, renderer, hostElement, viewContainerRef, listenersService, changeDetectorRef) {
        this.document = document;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.viewContainerRef = viewContainerRef;
        this.listenersService = listenersService;
        this.changeDetectorRef = changeDetectorRef;
        /**
         * Content of tooltip
         * @type {string | TemplateRef}
         */
        this.content = '';
        /**
         * Describes the placement of your component after Popper.js has applied all the modifiers that may have flipped or altered the originally provided placement property.
         */
        this.placement = 'top';
        /**
         * Sets which event handlers you’d like provided to your toggle prop. You can specify one trigger or an array of them.
         * @type {'hover' | 'focus' | 'click'}
         */
        this.trigger = 'hover';
        this._visible = false;
        this._popperOptions = {
            modifiers: [
                {
                    name: 'offset',
                    options: {
                        offset: [0, 0]
                    }
                }
            ]
        };
    }
    ngOnChanges(changes) {
        if (changes['visible']) {
            changes['visible'].currentValue ? this.addTooltipElement() : this.removeTooltipElement();
        }
    }
    ngOnDestroy() {
        this.clearListeners();
        this.destroyTooltipElement();
    }
    ngOnInit() {
        this.setListeners();
    }
    setListeners() {
        const config = {
            hostElement: this.hostElement,
            trigger: this.trigger,
            callbackToggle: () => {
                this.visible = !this.visible;
                this.visible ? this.addTooltipElement() : this.removeTooltipElement();
            },
            callbackOff: () => {
                this.visible = false;
                this.removeTooltipElement();
            },
            callbackOn: () => {
                this.visible = true;
                this.addTooltipElement();
            }
        };
        this.listenersService.setListeners(config);
    }
    clearListeners() {
        this.listenersService.clearListeners();
    }
    getUID(prefix) {
        let uid = prefix ?? 'random-id';
        do {
            uid = `${prefix}-${Math.floor(Math.random() * 1000000).toString(10)}`;
        } while (this.document.getElementById(uid));
        return uid;
    }
    createTooltipElement() {
        if (!this.tooltipRef) {
            this.tooltipRef = this.viewContainerRef.createComponent(TooltipComponent);
            // this.viewContainerRef.detach();
        }
    }
    destroyTooltipElement() {
        this.tooltip?.remove();
        this.tooltipRef?.destroy();
        // @ts-ignore
        this.tooltipRef = undefined;
        this.popperInstance?.destroy();
        this.viewContainerRef?.detach();
        this.viewContainerRef?.clear();
    }
    addTooltipElement() {
        if (!this.tooltipRef) {
            this.createTooltipElement();
        }
        this.tooltipId = this.getUID('tooltip');
        this.tooltipRef.instance.id = this.tooltipId;
        this.tooltipRef.instance.content = this.content;
        this.tooltip = this.tooltipRef.location.nativeElement;
        this.renderer.addClass(this.tooltip, 'd-none');
        this.renderer.addClass(this.tooltip, 'fade');
        this.popperInstance?.destroy();
        this.viewContainerRef.insert(this.tooltipRef.hostView);
        this.renderer.appendChild(this.document.body, this.tooltip);
        this.popperInstance = createPopper(this.hostElement.nativeElement, this.tooltip, { ...this.popperOptions });
        if (!this.visible) {
            this.removeTooltipElement();
            return;
        }
        this.renderer.removeClass(this.tooltip, 'd-none');
        this.changeDetectorRef.markForCheck();
        setTimeout(() => {
            this.tooltipRef.instance.visible = this.visible;
            this.popperInstance.forceUpdate();
            this.changeDetectorRef.markForCheck();
        }, 100);
    }
    removeTooltipElement() {
        this.tooltipId = '';
        if (!this.tooltipRef) {
            return;
        }
        this.tooltipRef.instance.visible = false;
        this.tooltipRef.instance.id = undefined;
        this.changeDetectorRef.markForCheck();
        setTimeout(() => {
            this.viewContainerRef?.detach();
        }, 300);
    }
}
TooltipDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: TooltipDirective, deps: [{ token: DOCUMENT }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i0.ViewContainerRef }, { token: i1.ListenersService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Directive });
TooltipDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "15.2.8", type: TooltipDirective, isStandalone: true, selector: "[cTooltip]", inputs: { content: ["cTooltip", "content"], popperOptions: ["cTooltipOptions", "popperOptions"], placement: ["cTooltipPlacement", "placement"], trigger: ["cTooltipTrigger", "trigger"], visible: ["cTooltipVisible", "visible"] }, host: { properties: { "attr.aria-describedby": "this.ariaDescribedBy" } }, providers: [ListenersService], exportAs: ["cTooltip"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: TooltipDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cTooltip]',
                    exportAs: 'cTooltip',
                    providers: [ListenersService],
                    standalone: true
                }]
        }], ctorParameters: function () { return [{ type: Document, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i0.ViewContainerRef }, { type: i1.ListenersService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { content: [{
                type: Input,
                args: ['cTooltip']
            }], popperOptions: [{
                type: Input,
                args: ['cTooltipOptions']
            }], placement: [{
                type: Input,
                args: ['cTooltipPlacement']
            }], trigger: [{
                type: Input,
                args: ['cTooltipTrigger']
            }], visible: [{
                type: Input,
                args: ['cTooltipVisible']
            }], ariaDescribedBy: [{
                type: HostBinding,
                args: ['attr.aria-describedby']
            }] } });
//# sourceMappingURL=data:application/json;base64,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