import { Component, ContentChildren, HostBinding, Input } from '@angular/core';
import { TemplateIdDirective } from '../../shared';
import { CardBodyComponent } from '../../card';
import { NgClass, NgIf, NgTemplateOutlet } from '@angular/common';
import * as i0 from "@angular/core";
export class WidgetStatAComponent {
    constructor() {
        this.templates = {};
    }
    get hostClasses() {
        return {
            'card': true,
            [`bg-${this.color}`]: !!this.color,
            'text-high-emphasis-inverse': !!this.color
        };
    }
    get bodyClasses() {
        return {
            'pb-0': true,
            'd-flex': true,
            'justify-content-between': true,
            'align-items-start': true
        };
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
WidgetStatAComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatAComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatAComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: WidgetStatAComponent, isStandalone: true, selector: "c-widget-stat-a", inputs: { color: "color", title: "title", value: "value" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cWidgetStatA"], ngImport: i0, template: "<ng-container>\n  <c-card-body [ngClass]=\"bodyClasses\">\n    <div>\n      <div *ngIf=\"!!value || templates?.widgetValueTemplate\" class=\"fs-4 fw-semibold\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetValueTemplate || defaultWidgetValueTemplate\"></ng-container>\n      </div>\n      <div *ngIf=\"!!title || templates?.widgetTitleTemplate\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetTitleTemplate || defaultWidgetTitleTemplate\"></ng-container>\n      </div>\n    </div>\n    <ng-container *ngTemplateOutlet=\"templates?.widgetActionTemplate || defaultWidgetActionTemplate\"></ng-container>\n  </c-card-body>\n  <ng-container *ngTemplateOutlet=\"templates?.widgetChartTemplate || defaultWidgetChartTemplate\"></ng-container>\n</ng-container>\n\n<ng-template #defaultWidgetTitleTemplate>\n  {{title}}\n</ng-template>\n\n<ng-template #defaultWidgetValueTemplate>\n  {{value}}\n</ng-template>\n\n<ng-template #defaultWidgetChartTemplate>\n  <ng-content select=\".chart-wrapper\"></ng-content>\n</ng-template>\n\n<ng-template #defaultWidgetActionTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", dependencies: [{ kind: "component", type: CardBodyComponent, selector: "c-card-body, [c-card-body]" }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatAComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-a', exportAs: 'cWidgetStatA', imports: [CardBodyComponent, NgClass, NgIf, NgTemplateOutlet], standalone: true, template: "<ng-container>\n  <c-card-body [ngClass]=\"bodyClasses\">\n    <div>\n      <div *ngIf=\"!!value || templates?.widgetValueTemplate\" class=\"fs-4 fw-semibold\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetValueTemplate || defaultWidgetValueTemplate\"></ng-container>\n      </div>\n      <div *ngIf=\"!!title || templates?.widgetTitleTemplate\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetTitleTemplate || defaultWidgetTitleTemplate\"></ng-container>\n      </div>\n    </div>\n    <ng-container *ngTemplateOutlet=\"templates?.widgetActionTemplate || defaultWidgetActionTemplate\"></ng-container>\n  </c-card-body>\n  <ng-container *ngTemplateOutlet=\"templates?.widgetChartTemplate || defaultWidgetChartTemplate\"></ng-container>\n</ng-container>\n\n<ng-template #defaultWidgetTitleTemplate>\n  {{title}}\n</ng-template>\n\n<ng-template #defaultWidgetValueTemplate>\n  {{value}}\n</ng-template>\n\n<ng-template #defaultWidgetChartTemplate>\n  <ng-content select=\".chart-wrapper\"></ng-content>\n</ng-template>\n\n<ng-template #defaultWidgetActionTemplate>\n  <ng-content></ng-content>\n</ng-template>\n" }]
        }], propDecorators: { color: [{
                type: Input
            }], title: [{
                type: Input
            }], value: [{
                type: Input
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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