import { Component, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { NgClass, NgIf } from '@angular/common';
import { CardBodyComponent, CardComponent } from '../../card';
import * as i0 from "@angular/core";
export class WidgetStatBComponent extends CardComponent {
    constructor() {
        super();
        this._inverse = false;
    }
    /**
     * Invert colors from their default dark shade.
     * @type boolean
     */
    get inverse() {
        return this._inverse;
    }
    set inverse(value) {
        this._inverse = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            'card': true,
            [`bg-${this.color}`]: !!this.color,
            [`text-${this.textColor}`]: !!this.textColor,
            'text-high-emphasis-inverse': !!this.color
        };
    }
}
WidgetStatBComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatBComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatBComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: WidgetStatBComponent, isStandalone: true, selector: "c-widget-stat-b", inputs: { color: "color", textColor: "textColor", title: "title", text: "text", value: "value", inverse: "inverse" }, host: { properties: { "class": "this.hostClasses" } }, exportAs: ["cWidgetStatB"], usesInheritance: true, ngImport: i0, template: "<c-card-body>\n  <div *ngIf=\"!!value\" class=\"fs-4 fw-semibold\">{{value}}</div>\n  <div *ngIf=\"!!title\">{{title}}</div>\n  <ng-content></ng-content>\n  <small *ngIf=\"text\" [ngClass]=\"inverse ? 'text-medium-emphasis-inverse' : 'text-medium-emphasis'\">\n    {{text}}\n  </small>\n</c-card-body>\n", dependencies: [{ kind: "component", type: CardBodyComponent, selector: "c-card-body, [c-card-body]" }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatBComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-b', exportAs: 'cWidgetStatB', standalone: true, imports: [CardBodyComponent, NgIf, NgClass], template: "<c-card-body>\n  <div *ngIf=\"!!value\" class=\"fs-4 fw-semibold\">{{value}}</div>\n  <div *ngIf=\"!!title\">{{title}}</div>\n  <ng-content></ng-content>\n  <small *ngIf=\"text\" [ngClass]=\"inverse ? 'text-medium-emphasis-inverse' : 'text-medium-emphasis'\">\n    {{text}}\n  </small>\n</c-card-body>\n" }]
        }], ctorParameters: function () { return []; }, propDecorators: { color: [{
                type: Input
            }], textColor: [{
                type: Input
            }], title: [{
                type: Input
            }], text: [{
                type: Input
            }], value: [{
                type: Input
            }], inverse: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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