import { Component, ContentChildren, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { CardBodyComponent, CardComponent } from '../../card';
import { TemplateIdDirective } from '../../shared';
import { NgClass, NgIf, NgTemplateOutlet } from '@angular/common';
import * as i0 from "@angular/core";
export class WidgetStatCComponent extends CardComponent {
    constructor() {
        super();
        this._inverse = false;
        this.templates = {};
    }
    /**
     * Invert colors from their default dark shade.
     * @type boolean
     */
    get inverse() {
        return this._inverse;
    }
    set inverse(value) {
        this._inverse = coerceBooleanProperty(value);
    }
    get hostExtendedClass() {
        return {
            'high-emphasis-inverse': this.inverse
        };
    }
    get iconClasses() {
        return {
            'mb-4': !this.textColor,
            'text-end': true,
            'text-medium-emphasis': !this.inverse,
            'text-medium-emphasis-inverse': this.inverse,
            [`text-${this.textColor}`]: !!this.textColor
        };
    }
    get titleClasses() {
        return {
            'text-medium-emphasis': !this.inverse,
            'text-medium-emphasis-inverse': this.inverse,
            [`text-${this.textColor}`]: !!this.textColor
        };
    }
    get valueClasses() {
        return {
            'fs-4': !this.textColor,
            'fw-semibold': true,
            'text-high-emphasis': !this.inverse,
            'text-high-emphasis-inverse': this.inverse,
            [`text-${this.textColor}`]: !!this.textColor
        };
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
WidgetStatCComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatCComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatCComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: WidgetStatCComponent, isStandalone: true, selector: "c-widget-stat-c", inputs: { icon: "icon", title: "title", value: "value", inverse: "inverse" }, host: { properties: { "class": "this.hostExtendedClass" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cWidgetStatC"], usesInheritance: true, ngImport: i0, template: "<c-card-body>\n  <div *ngIf=\"icon || templates?.widgetIconTemplate\" [ngClass]=\"iconClasses\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetIconTemplate || defaultWidgetIconTemplate\"></ng-container>\n  </div>\n  <div *ngIf=\"!!value\" [ngClass]=\"valueClasses\">\n    {{value}}\n  </div>\n  <div *ngIf=\"!!title\" [ngClass]=\"titleClasses\">\n    {{title}}\n  </div>\n  <ng-container *ngIf=\"templates?.widgetProgressTemplate\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetProgressTemplate || defaultWidgetProgressTemplate\"></ng-container>\n  </ng-container>\n</c-card-body>\n\n<ng-template #defaultWidgetIconTemplate>\n  {{icon}}\n</ng-template>\n\n<ng-template #defaultWidgetProgressTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", dependencies: [{ kind: "component", type: CardBodyComponent, selector: "c-card-body, [c-card-body]" }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatCComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-c', exportAs: 'cWidgetStatC', standalone: true, imports: [CardBodyComponent, NgIf, NgClass, NgTemplateOutlet], template: "<c-card-body>\n  <div *ngIf=\"icon || templates?.widgetIconTemplate\" [ngClass]=\"iconClasses\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetIconTemplate || defaultWidgetIconTemplate\"></ng-container>\n  </div>\n  <div *ngIf=\"!!value\" [ngClass]=\"valueClasses\">\n    {{value}}\n  </div>\n  <div *ngIf=\"!!title\" [ngClass]=\"titleClasses\">\n    {{title}}\n  </div>\n  <ng-container *ngIf=\"templates?.widgetProgressTemplate\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetProgressTemplate || defaultWidgetProgressTemplate\"></ng-container>\n  </ng-container>\n</c-card-body>\n\n<ng-template #defaultWidgetIconTemplate>\n  {{icon}}\n</ng-template>\n\n<ng-template #defaultWidgetProgressTemplate>\n  <ng-content></ng-content>\n</ng-template>\n" }]
        }], ctorParameters: function () { return []; }, propDecorators: { icon: [{
                type: Input
            }], title: [{
                type: Input
            }], value: [{
                type: Input
            }], inverse: [{
                type: Input
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], hostExtendedClass: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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