import { Component, HostBinding, Input } from '@angular/core';
import { CardBodyComponent, CardHeaderComponent } from '../../card';
import { ColComponent, RowDirective } from '../../grid';
import { NgClass, NgForOf, NgIf } from '@angular/common';
import * as i0 from "@angular/core";
export class WidgetStatDComponent {
    constructor() { }
    get hostClasses() {
        return {
            'card': true
        };
    }
    get headerClasses() {
        return {
            'position-relative': true,
            'd-flex': true,
            'justify-content-center': true,
            'align-items-center': true,
            [`bg-${this.color}`]: this.color
        };
    }
}
WidgetStatDComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatDComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatDComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: WidgetStatDComponent, isStandalone: true, selector: "c-widget-stat-d", inputs: { color: "color", values: "values" }, host: { properties: { "class": "this.hostClasses" } }, exportAs: ["cWidgetStatD"], ngImport: i0, template: "<c-card-header [ngClass]=\"headerClasses\">\n  <ng-content></ng-content>\n</c-card-header>\n<c-card-body cRow class=\"text-center\">\n  <ng-template [ngForOf]=\"values\" let-i=\"index\" let-item ngFor>\n    <div *ngIf=\"i % 2 !== 0\" class=\"vr\"></div>\n    <c-col>\n      <div class=\"fs-5 fw-semibold\">{{item.value}}</div>\n      <div class=\"text-uppercase text-medium-emphasis small\">{{item.title}}</div>\n    </c-col>\n  </ng-template>\n</c-card-body>\n", dependencies: [{ kind: "component", type: CardHeaderComponent, selector: "c-card-header, [c-card-header]" }, { kind: "component", type: CardBodyComponent, selector: "c-card-body, [c-card-body]" }, { kind: "component", type: ColComponent, selector: "c-col" }, { kind: "directive", type: RowDirective, selector: "[cRow]", inputs: ["xs", "sm", "md", "lg", "xl", "xxl"] }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatDComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-d', exportAs: 'cWidgetStatD', standalone: true, imports: [CardHeaderComponent, CardBodyComponent, ColComponent, RowDirective, NgClass, NgForOf, NgIf], template: "<c-card-header [ngClass]=\"headerClasses\">\n  <ng-content></ng-content>\n</c-card-header>\n<c-card-body cRow class=\"text-center\">\n  <ng-template [ngForOf]=\"values\" let-i=\"index\" let-item ngFor>\n    <div *ngIf=\"i % 2 !== 0\" class=\"vr\"></div>\n    <c-col>\n      <div class=\"fs-5 fw-semibold\">{{item.value}}</div>\n      <div class=\"text-uppercase text-medium-emphasis small\">{{item.title}}</div>\n    </c-col>\n  </ng-template>\n</c-card-body>\n" }]
        }], ctorParameters: function () { return []; }, propDecorators: { color: [{
                type: Input
            }], values: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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