import { Component, ContentChildren, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { TemplateIdDirective } from '../../shared';
import { NgClass, NgIf, NgTemplateOutlet } from '@angular/common';
import { CardBodyComponent, CardFooterComponent } from '../../card';
import * as i0 from "@angular/core";
export class WidgetStatFComponent {
    constructor() {
        this._padding = false;
        this.templates = {};
    }
    /**
     * Set padding of your component.
     * @type boolean
     */
    get padding() {
        return this._padding;
    }
    set padding(value) {
        this._padding = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            card: true
        };
    }
    get cardBodyClasses() {
        return {
            'd-flex': true,
            'align-items-center': true,
            'p-0': !this.padding
        };
    }
    get iconClasses() {
        return {
            'me-3': !this.textColor,
            'text-white': true,
            [`bg-${this.color}`]: !!this.color,
            'p-3': this.padding,
            'p-4': !this.padding
        };
    }
    get titleClasses() {
        return {
            'text-medium-emphasis': !this.textColor,
            'small': true,
            'text-uppercase': true,
            'fw-semibold': true,
            [`text-${this.textColor}`]: !!this.textColor
        };
    }
    get valueClasses() {
        return {
            'fs-6': !this.textColor,
            'fw-semibold': true,
            [`text-${this.textColor}`]: !!this.textColor
        };
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
WidgetStatFComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatFComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatFComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.2.8", type: WidgetStatFComponent, isStandalone: true, selector: "c-widget-stat-f", inputs: { color: "color", textColor: "textColor", footer: "footer", icon: "icon", padding: "padding", title: "title", value: "value" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cWidgetStatB"], ngImport: i0, template: "<ng-container>\n  <c-card-body [ngClass]=\"cardBodyClasses\">\n    <div [ngClass]=\"iconClasses\">\n      <ng-container *ngTemplateOutlet=\"templates?.widgetIconTemplate || defaultWidgetIconTemplate\"></ng-container>\n    </div>\n    <div>\n      <div [ngClass]=\"valueClasses\">{{value}}</div>\n      <div [ngClass]=\"titleClasses\">{{title}}</div>\n    </div>\n  </c-card-body>\n  <c-card-footer *ngIf=\"footer || templates?.widgetFooterTemplate\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetFooterTemplate || defaultFooterIconTemplate\"></ng-container>\n  </c-card-footer>\n</ng-container>\n\n<ng-template #defaultWidgetIconTemplate>\n  <span>{{icon}}</span>\n</ng-template>\n\n<ng-template #defaultFooterIconTemplate>\n  <span>{{footer}}</span>\n</ng-template>\n", dependencies: [{ kind: "component", type: CardBodyComponent, selector: "c-card-body, [c-card-body]" }, { kind: "component", type: CardFooterComponent, selector: "c-card-footer, [c-card-footer]" }, { kind: "directive", type: NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.8", ngImport: i0, type: WidgetStatFComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-f', exportAs: 'cWidgetStatB', standalone: true, imports: [CardBodyComponent, CardFooterComponent, NgClass, NgTemplateOutlet, NgIf], template: "<ng-container>\n  <c-card-body [ngClass]=\"cardBodyClasses\">\n    <div [ngClass]=\"iconClasses\">\n      <ng-container *ngTemplateOutlet=\"templates?.widgetIconTemplate || defaultWidgetIconTemplate\"></ng-container>\n    </div>\n    <div>\n      <div [ngClass]=\"valueClasses\">{{value}}</div>\n      <div [ngClass]=\"titleClasses\">{{title}}</div>\n    </div>\n  </c-card-body>\n  <c-card-footer *ngIf=\"footer || templates?.widgetFooterTemplate\">\n    <ng-container *ngTemplateOutlet=\"templates?.widgetFooterTemplate || defaultFooterIconTemplate\"></ng-container>\n  </c-card-footer>\n</ng-container>\n\n<ng-template #defaultWidgetIconTemplate>\n  <span>{{icon}}</span>\n</ng-template>\n\n<ng-template #defaultFooterIconTemplate>\n  <span>{{footer}}</span>\n</ng-template>\n" }]
        }], propDecorators: { color: [{
                type: Input
            }], textColor: [{
                type: Input
            }], footer: [{
                type: Input
            }], icon: [{
                type: Input
            }], padding: [{
                type: Input
            }], title: [{
                type: Input
            }], value: [{
                type: Input
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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