import { MagicServices, TaskBaseMagicComponent } from '@magic-xpa/angular';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { SelectionModel } from '@angular/cdk/collections';
import { ChangeDetectorRef, Component, ViewChild } from '@angular/core';
import { matMagicProviders } from '../services/mat.magic.providers';
import { MatPaginator } from '@angular/material/paginator';
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
import * as i0 from "@angular/core";
import * as i1 from "@magic-xpa/angular";
export class BaseMatTableMagicComponent extends TaskBaseMagicComponent {
    constructor(ref, magicService) {
        super(ref, magicService);
        this.ref = ref;
        this.magicService = magicService;
        this.displayedColumns = [];
        this.dataSource = new MatTableDataSource(this.task.Records.list);
        this.selection = new SelectionModel(false, []);
    }
    ngOnInit() {
        super.ngOnInit();
        this.magicService.tableService.connect(this.dataSource, this.paginator, this.selection);
    }
    ngAfterContentChecked() {
        if (!isNullOrUndefined(this.paginator) && !isNullOrUndefined(this.paginator.pageSize) &&
            this.paginator.pageSize != this.task.oldPageSize) {
            this.magicService.tableService.handleResize(this.paginator.pageIndex, 0, this.paginator.pageSize);
            this.task.oldPageSize = this.paginator.pageSize;
        }
    }
}
BaseMatTableMagicComponent.ɵfac = function BaseMatTableMagicComponent_Factory(t) { return new (t || BaseMatTableMagicComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.MagicServices)); };
BaseMatTableMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: BaseMatTableMagicComponent, selectors: [["ng-component"]], viewQuery: function BaseMatTableMagicComponent_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(MatPaginator, 7);
        i0.ɵɵviewQuery(MatSort, 7);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.paginator = _t.first);
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.sort = _t.first);
    } }, features: [i0.ɵɵProvidersFeature(matMagicProviders), i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseMatTableMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMatTableMagicComponent, [{
        type: Component,
        args: [{
                providers: matMagicProviders,
                template: ''
            }]
    }], function () { return [{ type: i0.ChangeDetectorRef }, { type: i1.MagicServices }]; }, { paginator: [{
            type: ViewChild,
            args: [MatPaginator, { static: true }]
        }], sort: [{
            type: ViewChild,
            args: [MatSort, { static: true }]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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