import { Injectable } from '@angular/core';
import { TaskMagicService, ComponentListMagicService } from "@magic-xpa/angular";
import { getGuiEventObj } from "@magic-xpa/engine";
import { TableMagicService } from "@magic-xpa/angular";
import { isNullOrUndefined } from "@magic-xpa/mscorelib";
import * as i0 from "@angular/core";
import * as i1 from "@magic-xpa/angular";
export class MgMatTableService extends TableMagicService {
    get DataSource() {
        return this.dataSource;
    }
    set DataSource(dataSource) {
        this.dataSource = dataSource;
    }
    get Selection() {
        return this.selection;
    }
    set Selection(selection) {
        this.selection = selection;
    }
    get Paginator() {
        return this.paginator;
    }
    set Paginator(paginator) {
        this.paginator = paginator;
    }
    constructor(componentList, task) {
        super(componentList, task);
        this.componentList = componentList;
        this.task = task;
    }
    connect(dataSource, paginator, selection) {
        this.dataSource = dataSource;
        this.paginator = paginator;
        this.selection = selection;
    }
    refreshDataSource() {
        if (!isNullOrUndefined(this.paginator))
            this.dataSource.paginator = this.paginator;
        this.dataSource.data = (this.task.mgAccessorService.isDataviewEmpty() ? [] : this.task.Records.list);
    }
    getPageSize() {
        if (isNullOrUndefined(this.paginator))
            return 10;
        return this.paginator.pageSize;
    }
    selectRow(guiRowid) {
        super.selectRow(guiRowid);
        this.selection.select(this.task.Records.list[guiRowid]);
        this.refreshDataSource();
    }
    selectPage(pageId) {
        if (!isNullOrUndefined(this.paginator))
            this.paginator.pageIndex = pageId;
        this.refreshDataSource();
    }
    selectedRow() {
        return this.selection.selected[0];
    }
    mgOnPaginateChange(e, changeSelectedRow) {
        if (this.task.oldPageSize != e.pageSize) {
            this.handleResize(e.pageIndex, e.previousPageIndex, e.pageSize);
            this.task.oldPageSize = e.pageSize;
        }
        else {
            if (changeSelectedRow) {
                let evt = (e.pageIndex > e.previousPageIndex) ? "next-page" : "previous-page";
                let guiEvent = getGuiEventObj("navigateInTable", "magicRow", 0);
                guiEvent.Value = evt;
                this.task.insertEvent(guiEvent);
            }
            else
                this.getRowsIfNeeded(e.pageIndex, e.previousPageIndex, e.pageSize);
        }
    }
    handleResize(pageIndex, prevPageIndex, pageSize) {
        let requiredGuiRowId = pageIndex * pageSize;
        this.task.resize(pageSize, requiredGuiRowId);
    }
    getRowsIfNeeded(pageIndex, prevPageIndex, pageSize) {
        let guiEvent = getGuiEventObj("getRows", "", 0);
        guiEvent.Line = pageIndex * pageSize;
        this.task.insertEvent(guiEvent);
        this.setTableTopIndex(this.task.getDvRowId(pageSize * pageIndex));
    }
    sortData(e) {
        let direction = 0;
        if (e.direction === 'asc')
            direction = 0;
        else if (e.direction === 'desc')
            direction = 1;
        let guiEvent = getGuiEventObj("columnSort", e.active, direction);
        this.task.insertEvent(guiEvent);
    }
    updateTableSize(size) {
        if (size === 0) {
            size = 1;
            this.task.Records.clearFirstTableRecord(this.task.template);
        }
        else if (isNullOrUndefined(this.paginator))
            size = this.getPageSize();
        this.task.formGroups.length = size;
        this.task.Records.updateSize(size);
        this.task.setIncludesFirst(false);
    }
    selectPageForGuiRowId(guiRowId) {
        let pageToBeSelected = 0;
        let prevSelectedRow = this.selectedRow();
        pageToBeSelected = Math.floor(guiRowId / this.getPageSize());
        if ((isNullOrUndefined(prevSelectedRow) || (!isNullOrUndefined(this.paginator) && pageToBeSelected != this.paginator.pageIndex)))
            this.selectPage(pageToBeSelected);
    }
    setTableTopIndex(value) {
        this.task.Records.setGuiTopIndex(value);
        if (value >= 0)
            this.selectPageForGuiRowId(this.task.getGuiRowId(value, true));
    }
    getTableTopIndex() {
        return this.task.Records.getGuiTopIndex();
    }
}
MgMatTableService.ɵfac = function MgMatTableService_Factory(t) { return new (t || MgMatTableService)(i0.ɵɵinject(i1.ComponentListMagicService), i0.ɵɵinject(i1.TaskMagicService)); };
MgMatTableService.ɵprov = i0.ɵɵdefineInjectable({ token: MgMatTableService, factory: MgMatTableService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgMatTableService, [{
        type: Injectable
    }], function () { return [{ type: i1.ComponentListMagicService }, { type: i1.TaskMagicService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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