import * as i0 from '@angular/core';
import { Directive, HostListener, Injectable, Component, ViewChild, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';
import * as i1 from '@magic-xpa/angular';
import { CheckboxMagicDirective, ComboboxMagicDirective, MagicDirective, TableMagicService, basicMagicProviders, TaskBaseMagicComponent, MagicModule } from '@magic-xpa/angular';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource, MatTableModule } from '@angular/material/table';
import { SelectionModel } from '@angular/cdk/collections';
import { getGuiEventObj } from '@magic-xpa/engine';
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
import { MatPaginator, MatPaginatorModule } from '@angular/material/paginator';
import { MatInputModule } from '@angular/material/input';
import { MatButtonModule } from '@angular/material/button';
import { MatListModule } from '@angular/material/list';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatTabsModule } from '@angular/material/tabs';
import { MatSelectModule } from '@angular/material/select';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatNativeDateModule } from '@angular/material/core';

class MatCheckboxDirective extends CheckboxMagicDirective {
}
MatCheckboxDirective.ɵfac = function () { let ɵMatCheckboxDirective_BaseFactory; return function MatCheckboxDirective_Factory(t) { return (ɵMatCheckboxDirective_BaseFactory || (ɵMatCheckboxDirective_BaseFactory = i0.ɵɵgetInheritedFactory(MatCheckboxDirective)))(t || MatCheckboxDirective); }; }();
MatCheckboxDirective.ɵdir = i0.ɵɵdefineDirective({ type: MatCheckboxDirective, selectors: [["mat-checkbox", "magic", "", 3, "noFormControl", ""]], features: [i0.ɵɵInheritDefinitionFeature] });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MatCheckboxDirective, [{
            type: Directive,
            args: [{
                    selector: `
    mat-checkbox[magic]:not([noFormControl])
    `,
                }]
        }], null, null);
})();

class MatComboboxDirective extends ComboboxMagicDirective {
    onChange($event) {
        super.onChange($event);
    }
    onOpenedChanged($event) {
        MagicDirective.opened = $event;
    }
    onComboboxItemsListChanged() {
    }
}
MatComboboxDirective.ɵfac = function () { let ɵMatComboboxDirective_BaseFactory; return function MatComboboxDirective_Factory(t) { return (ɵMatComboboxDirective_BaseFactory || (ɵMatComboboxDirective_BaseFactory = i0.ɵɵgetInheritedFactory(MatComboboxDirective)))(t || MatComboboxDirective); }; }();
MatComboboxDirective.ɵdir = i0.ɵɵdefineDirective({ type: MatComboboxDirective, selectors: [["mat-select", "magic", ""]], hostBindings: function MatComboboxDirective_HostBindings(rf, ctx) {
        if (rf & 1) {
            i0.ɵɵlistener("selectionChange", function MatComboboxDirective_selectionChange_HostBindingHandler($event) { return ctx.onChange($event); })("openedChange", function MatComboboxDirective_openedChange_HostBindingHandler($event) { return ctx.onOpenedChanged($event); });
        }
    }, features: [i0.ɵɵInheritDefinitionFeature] });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MatComboboxDirective, [{
            type: Directive,
            args: [{
                    selector: `mat-select[magic]`,
                }]
        }], null, { onChange: [{
                type: HostListener,
                args: ['selectionChange', ['$event']]
            }], onOpenedChanged: [{
                type: HostListener,
                args: ['openedChange', ['$event']]
            }] });
})();

class MgMatTableService extends TableMagicService {
    get DataSource() {
        return this.dataSource;
    }
    set DataSource(dataSource) {
        this.dataSource = dataSource;
    }
    get Selection() {
        return this.selection;
    }
    set Selection(selection) {
        this.selection = selection;
    }
    get Paginator() {
        return this.paginator;
    }
    set Paginator(paginator) {
        this.paginator = paginator;
    }
    constructor(componentList, task) {
        super(componentList, task);
        this.componentList = componentList;
        this.task = task;
    }
    connect(dataSource, paginator, selection) {
        this.dataSource = dataSource;
        this.paginator = paginator;
        this.selection = selection;
    }
    refreshDataSource() {
        if (!isNullOrUndefined(this.paginator))
            this.dataSource.paginator = this.paginator;
        this.dataSource.data = (this.task.mgAccessorService.isDataviewEmpty() ? [] : this.task.Records.list);
    }
    getPageSize() {
        if (isNullOrUndefined(this.paginator))
            return 10;
        return this.paginator.pageSize;
    }
    selectRow(guiRowid) {
        super.selectRow(guiRowid);
        this.selection.select(this.task.Records.list[guiRowid]);
        this.refreshDataSource();
    }
    selectPage(pageId) {
        if (!isNullOrUndefined(this.paginator))
            this.paginator.pageIndex = pageId;
        this.refreshDataSource();
    }
    selectedRow() {
        return this.selection.selected[0];
    }
    mgOnPaginateChange(e, changeSelectedRow) {
        if (this.task.oldPageSize != e.pageSize) {
            this.handleResize(e.pageIndex, e.previousPageIndex, e.pageSize);
            this.task.oldPageSize = e.pageSize;
        }
        else {
            if (changeSelectedRow) {
                let evt = (e.pageIndex > e.previousPageIndex) ? "next-page" : "previous-page";
                let guiEvent = getGuiEventObj("navigateInTable", "magicRow", 0);
                guiEvent.Value = evt;
                this.task.insertEvent(guiEvent);
            }
            else
                this.getRowsIfNeeded(e.pageIndex, e.previousPageIndex, e.pageSize);
        }
    }
    handleResize(pageIndex, prevPageIndex, pageSize) {
        let requiredGuiRowId = pageIndex * pageSize;
        this.task.resize(pageSize, requiredGuiRowId);
    }
    getRowsIfNeeded(pageIndex, prevPageIndex, pageSize) {
        let guiEvent = getGuiEventObj("getRows", "", 0);
        guiEvent.Line = pageIndex * pageSize;
        this.task.insertEvent(guiEvent);
        this.setTableTopIndex(this.task.getDvRowId(pageSize * pageIndex));
    }
    sortData(e) {
        let direction = 0;
        if (e.direction === 'asc')
            direction = 0;
        else if (e.direction === 'desc')
            direction = 1;
        let guiEvent = getGuiEventObj("columnSort", e.active, direction);
        this.task.insertEvent(guiEvent);
    }
    updateTableSize(size) {
        if (size === 0) {
            size = 1;
            this.task.Records.clearFirstTableRecord(this.task.template);
        }
        else if (isNullOrUndefined(this.paginator))
            size = this.getPageSize();
        this.task.formGroups.length = size;
        this.task.Records.updateSize(size);
        this.task.setIncludesFirst(false);
    }
    selectPageForGuiRowId(guiRowId) {
        let pageToBeSelected = 0;
        let prevSelectedRow = this.selectedRow();
        pageToBeSelected = Math.floor(guiRowId / this.getPageSize());
        if ((isNullOrUndefined(prevSelectedRow) || (!isNullOrUndefined(this.paginator) && pageToBeSelected != this.paginator.pageIndex)))
            this.selectPage(pageToBeSelected);
    }
    setTableTopIndex(value) {
        this.task.Records.setGuiTopIndex(value);
        if (value >= 0)
            this.selectPageForGuiRowId(this.task.getGuiRowId(value, true));
    }
    getTableTopIndex() {
        return this.task.Records.getGuiTopIndex();
    }
}
MgMatTableService.ɵfac = function MgMatTableService_Factory(t) { return new (t || MgMatTableService)(i0.ɵɵinject(i1.ComponentListMagicService), i0.ɵɵinject(i1.TaskMagicService)); };
MgMatTableService.ɵprov = i0.ɵɵdefineInjectable({ token: MgMatTableService, factory: MgMatTableService.ɵfac });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgMatTableService, [{
            type: Injectable
        }], function () { return [{ type: i1.ComponentListMagicService }, { type: i1.TaskMagicService }]; }, null);
})();

const matMagicProviders = [
    ...basicMagicProviders,
    { provide: TableMagicService, useClass: MgMatTableService }
];

class BaseMatTableMagicComponent extends TaskBaseMagicComponent {
    constructor(ref, magicService) {
        super(ref, magicService);
        this.ref = ref;
        this.magicService = magicService;
        this.displayedColumns = [];
        this.dataSource = new MatTableDataSource(this.task.Records.list);
        this.selection = new SelectionModel(false, []);
    }
    ngOnInit() {
        super.ngOnInit();
        this.magicService.tableService.connect(this.dataSource, this.paginator, this.selection);
    }
    ngAfterContentChecked() {
        if (!isNullOrUndefined(this.paginator) && !isNullOrUndefined(this.paginator.pageSize) &&
            this.paginator.pageSize != this.task.oldPageSize) {
            this.magicService.tableService.handleResize(this.paginator.pageIndex, 0, this.paginator.pageSize);
            this.task.oldPageSize = this.paginator.pageSize;
        }
    }
}
BaseMatTableMagicComponent.ɵfac = function BaseMatTableMagicComponent_Factory(t) { return new (t || BaseMatTableMagicComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.MagicServices)); };
BaseMatTableMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: BaseMatTableMagicComponent, selectors: [["ng-component"]], viewQuery: function BaseMatTableMagicComponent_Query(rf, ctx) {
        if (rf & 1) {
            i0.ɵɵviewQuery(MatPaginator, 7);
            i0.ɵɵviewQuery(MatSort, 7);
        }
        if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.paginator = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.sort = _t.first);
        }
    }, features: [i0.ɵɵProvidersFeature(matMagicProviders), i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseMatTableMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMatTableMagicComponent, [{
            type: Component,
            args: [{
                    providers: matMagicProviders,
                    template: ''
                }]
        }], function () { return [{ type: i0.ChangeDetectorRef }, { type: i1.MagicServices }]; }, { paginator: [{
                type: ViewChild,
                args: [MatPaginator, { static: true }]
            }], sort: [{
                type: ViewChild,
                args: [MatSort, { static: true }]
            }] });
})();

class MatListboxDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
    }
    onChange($event) {
        this.magicDirective.task.onListBoxSelectionChanged($event, this.magicDirective.id);
    }
}
MatListboxDirective.ɵfac = function MatListboxDirective_Factory(t) { return new (t || MatListboxDirective)(i0.ɵɵdirectiveInject(i1.MagicDirective)); };
MatListboxDirective.ɵdir = i0.ɵɵdefineDirective({ type: MatListboxDirective, selectors: [["mat-selection-list", "magic", ""]], hostBindings: function MatListboxDirective_HostBindings(rf, ctx) {
        if (rf & 1) {
            i0.ɵɵlistener("selectionChange", function MatListboxDirective_selectionChange_HostBindingHandler($event) { return ctx.onChange($event); });
        }
    } });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MatListboxDirective, [{
            type: Directive,
            args: [{
                    selector: `mat-selection-list[magic]`,
                }]
        }], function () { return [{ type: i1.MagicDirective }]; }, { onChange: [{
                type: HostListener,
                args: ['selectionChange', ['$event']]
            }] });
})();

class MatMagicAutocompleteDirective {
    onOpenedChanged($event) {
        MagicDirective.noOfAutoCompleteBoxesOpened++;
    }
    onClosedChanged($event) {
        MagicDirective.noOfAutoCompleteBoxesOpened--;
    }
}
MatMagicAutocompleteDirective.ɵfac = function MatMagicAutocompleteDirective_Factory(t) { return new (t || MatMagicAutocompleteDirective)(); };
MatMagicAutocompleteDirective.ɵdir = i0.ɵɵdefineDirective({ type: MatMagicAutocompleteDirective, selectors: [["mat-autocomplete", "magic", ""]], hostBindings: function MatMagicAutocompleteDirective_HostBindings(rf, ctx) {
        if (rf & 1) {
            i0.ɵɵlistener("opened", function MatMagicAutocompleteDirective_opened_HostBindingHandler($event) { return ctx.onOpenedChanged($event); })("closed", function MatMagicAutocompleteDirective_closed_HostBindingHandler($event) { return ctx.onClosedChanged($event); });
        }
    } });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MatMagicAutocompleteDirective, [{
            type: Directive,
            args: [{
                    selector: 'mat-autocomplete[magic]'
                }]
        }], null, { onOpenedChanged: [{
                type: HostListener,
                args: ['opened', ['$event']]
            }], onClosedChanged: [{
                type: HostListener,
                args: ['closed', ['$event']]
            }] });
})();

const materialModules = [
    MatTableModule,
    MatPaginatorModule,
    MatInputModule,
    MatButtonModule,
    MatListModule,
    MatCheckboxModule,
    MatTabsModule,
    MatSelectModule,
    MatDatepickerModule,
    MatNativeDateModule,
];
class MagicAngularMaterialModule {
}
MagicAngularMaterialModule.ɵfac = function MagicAngularMaterialModule_Factory(t) { return new (t || MagicAngularMaterialModule)(); };
MagicAngularMaterialModule.ɵmod = i0.ɵɵdefineNgModule({ type: MagicAngularMaterialModule });
MagicAngularMaterialModule.ɵinj = i0.ɵɵdefineInjector({ imports: [CommonModule,
        FormsModule, materialModules, MagicModule] });
(function () {
    (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicAngularMaterialModule, [{
            type: NgModule,
            args: [{
                    declarations: [
                        MatCheckboxDirective,
                        MatComboboxDirective,
                        MatListboxDirective,
                        MatMagicAutocompleteDirective,
                        BaseMatTableMagicComponent,
                    ],
                    exports: [
                        MatCheckboxDirective,
                        MatComboboxDirective,
                        MatListboxDirective,
                        MatMagicAutocompleteDirective,
                        BaseMatTableMagicComponent
                    ],
                    imports: [
                        CommonModule,
                        FormsModule,
                        ...materialModules,
                        MagicModule
                    ]
                }]
        }], null, null);
})();
(function () {
    (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MagicAngularMaterialModule, { declarations: [MatCheckboxDirective,
            MatComboboxDirective,
            MatListboxDirective,
            MatMagicAutocompleteDirective,
            BaseMatTableMagicComponent], imports: [CommonModule,
            FormsModule, MatTableModule,
            MatPaginatorModule,
            MatInputModule,
            MatButtonModule,
            MatListModule,
            MatCheckboxModule,
            MatTabsModule,
            MatSelectModule,
            MatDatepickerModule,
            MatNativeDateModule, MagicModule], exports: [MatCheckboxDirective,
            MatComboboxDirective,
            MatListboxDirective,
            MatMagicAutocompleteDirective,
            BaseMatTableMagicComponent] });
})();

export { BaseMatTableMagicComponent, MagicAngularMaterialModule, MatCheckboxDirective, MatComboboxDirective, MatListboxDirective, MatMagicAutocompleteDirective, MgMatTableService, matMagicProviders, materialModules };
//# sourceMappingURL=magic-xpa-angular-material-core.mjs.map
