import { isNullOrUndefined } from "@magic-xpa/mscorelib";
export class ControlMetadata {
    constructor() {
        this.properties = new Map();
        this.classesMap = new Map();
        this.stylesMap = new Map();
        this.userProperties = new Map();
        this.customValidators = new Map();
    }
    setClass(key, value) {
        if (this.classesMap.has(key)) {
            this.removedClass = this.classesMap.get(key);
        }
        this.classesMap.set(key, value);
        let result = '';
        for (let value of this.classesMap) {
            result += value + ' ';
        }
        this.classes = result;
    }
    setStyle(key, value) {
        this.stylesMap.set(key, value);
    }
}
export class ControlsMetadata {
    constructor() {
        this.values = new Map();
        this.ControlsProperties = new Map();
        this.isCreated = false;
        this.isEditing = false;
    }
    get Values() {
        return this.values;
    }
    getControlMetadata(controlId) {
        if (!this.ControlsProperties.has(controlId))
            this.ControlsProperties.set(controlId, new ControlMetadata());
        return this.ControlsProperties.get(controlId);
    }
    update(obj) {
        let props = obj.ControlsMetaData;
        for (let controlName in props) {
            if (!this.ControlsProperties.has(controlName))
                this.ControlsProperties.set(controlName, new ControlMetadata());
            let controlMetaData = this.ControlsProperties.get(controlName);
            for (let property in obj.ControlsMetaData[controlName].Properties)
                controlMetaData[property] = obj.ControlsMetaData[controlName].Properties[property];
            controlMetaData.controlType = obj.ControlsMetaData[controlName].Type;
        }
        for (let controlName in obj.ControlsValues) {
            this.setValue(controlName, obj.ControlsValues[controlName]);
        }
    }
    setValue(controlName, value) {
        this.values.set(controlName, value);
    }
    getProperty(controlId, prop) {
        if (this.ControlsProperties.has(controlId)) {
            if (this.ControlsProperties.get(controlId).properties.has(prop)) {
                return this.ControlsProperties.get(controlId).properties.get(prop);
            }
        }
        return "";
    }
    getValue(controlName) {
        return this.values.get(controlName);
    }
}
export class Records {
    constructor() {
        this.data = new Map();
        this.list = [];
        this.recordsBeforeCurrentView = 0;
        this.isEmptyDataView = false;
        this.sizeUpdated = false;
    }
    getRow(dvRowId) {
        return this.list[dvRowId + this.recordsBeforeCurrentView];
    }
    markRowAsCreated(guiRowId) {
        if (guiRowId < this.list.length) {
            this.addRow(guiRowId);
            this.data.get(guiRowId).isCreated = true;
        }
    }
    markRowAsNotCreated(guiRowId) {
        if (guiRowId < this.list.length)
            this.data.get(guiRowId).isCreated = false;
    }
    isRowCreated(guiRowId) {
        if (guiRowId < this.list.length) {
            if (!this.data.has(guiRowId) || isNullOrUndefined(this.data.get(guiRowId)))
                return false;
            else
                return this.data.get(guiRowId).isCreated;
        }
        return false;
    }
    startRowEditing(guiRowId) {
        if (guiRowId < this.list.length && this.data.has(guiRowId))
            this.data.get(guiRowId).isEditing = true;
    }
    stopRowEditing(guiRowId) {
        if (guiRowId < this.list.length && this.data.has(guiRowId))
            this.data.get(guiRowId).isEditing = false;
    }
    isRowInRowEditing(guiRowId) {
        if (+guiRowId < this.list.length) {
            if (!this.data.has(+guiRowId) || isNullOrUndefined(this.data.get(+guiRowId)))
                return false;
            else
                return this.data.get(+guiRowId).isEditing;
        }
        return false;
    }
    update(obj) {
        if (obj.fullRefresh && obj.rows.length != this.list.length) {
            this.data = new Map();
            this.list = new Array();
        }
        for (let rowId in obj.rows) {
            if (!this.data.has(+rowId) || this.data.get(+rowId) === null)
                this.data.set(+rowId, new ControlsMetadata());
            let controlsData = this.data.get(+rowId);
            controlsData.update(obj.rows[rowId]);
            controlsData.rowId = rowId;
        }
        for (var [key, value] of this.data) {
            this.list[key] = value;
        }
    }
    updateSize(len) {
        if (this.list.length != len) {
            if (len < this.list.length) {
                for (let i = len; i < this.list.length; i++) {
                    this.data.delete(i);
                }
            }
            this.list.length = len;
            this.sizeUpdated = true;
        }
    }
    clearFirstTableRecord(template) {
        if (this.list.length >= 1) {
            for (const key in template) {
                if (template[key] == '1' && this.list[0].ControlsProperties.has(key)) {
                    this.list[0].ControlsProperties.get(key).properties = new Map();
                }
            }
        }
    }
    addRow(guiRowId) {
        if (guiRowId !== 0 || !this.data.has(guiRowId) || isNullOrUndefined(this.data.get(guiRowId))) {
            this.data.set(guiRowId, new ControlsMetadata());
            this.data.get(guiRowId).rowId = "" + guiRowId;
            this.list[guiRowId] = this.data.get(guiRowId);
        }
    }
    createFirst() {
        this.addRow(0);
    }
    fromJson(data) {
        var obj = JSON.parse(data);
        this.update(obj);
    }
    setGuiTopIndex(topIndex) {
        this.guiTopIndex = topIndex;
    }
    getGuiTopIndex() {
        return this.guiTopIndex;
    }
}
export var HtmlClasses;
(function (HtmlClasses) {
    HtmlClasses["Color"] = "color";
    HtmlClasses["font"] = "font";
    HtmlClasses["FocusColor"] = "focuscolor";
    HtmlClasses["HintColor"] = "hintcolor";
})(HtmlClasses || (HtmlClasses = {}));
//# sourceMappingURL=data:application/json;base64,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