import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { RouterModule } from '@angular/router';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { DynamicModule } from 'ng-dynamic-component';
import { NoControlMagicDirective } from './ui/directives/magic/nocontrol.magic.directive';
import { MagicOverlayContainer } from './ui/magic-modal/magic-overlay-container';
import { RouterContainerMagicComponent } from './ui/router-container.magic.component';
import { MgformatMagicDirective } from './ui/directives/mgformat.magic.directive';
import { DateMagicPipe } from './ui/pipes/date.magic.pipe';
import { TimeMagicPipe } from './ui/pipes/time.magic.pipe';
import { RangeValidatorMagicDirective } from './ui/directives/range-validator.magic.directive';
import { SubformMagicComponent } from './ui/subform.magic.component';
import { ErrorMagicComponent } from './ui/mgerror.magic.component';
import { CheckboxMagicDirective } from './ui/directives/magic/checkbox.magic.directive';
import { ComboboxMagicDirective } from './ui/directives/magic/combobox.magic.directive';
import { MagicShellComponent } from './ui/magic-root.component';
import { MagicCheckboxControlValueAccessor } from './ui/directives/magic/form-controls/control-value-accessors/checkbox.cva.directive';
import { MagicDefaultValueAccessor } from './ui/directives/magic/form-controls/control-value-accessors/default.cva.directive';
import { MagicDirective } from './ui/directives/magic.directive';
import { TaskBaseMagicComponent } from './ui/task-base.magic.component';
import { RowMagicDirective } from './ui/directives/magic/row.magic.directive';
import { CheckboxNoFormControlMagicDirective } from './ui/directives/magic/checkbox-noformcontrol.magic.directive';
import { InputNoFormControlMagicDirective } from './ui/directives/magic/input.noformcontrol.magic.directive';
import { DateValueAccessor } from './ui/directives/magic/form-controls/control-value-accessors/date.cva.directive';
import { OverlayContainerMagicProvider } from './services/overlay.conainer.magic.provider';
import { MagicOverlayContainerWrapper } from './ui/magic-modal/magic-overlay-container-wrapper';
import { HttpClientModule } from '@angular/common/http';
import { NonMagicControlDirective } from './ui/directives/NonMagicControlDirective';
import { MagicAlertComponent } from './ui/components/magic-alert.component';
import { ConfirmationComponentsMagicProvider } from './services/confirmation.components.magic.provider';
import { MagicConfirmationBoxComponent } from './ui/components/magic-confirmation-box.component';
import { MagicFocusDirective } from './ui/directives/magic-focus.directive';
import { BaseMagicAlertComponent } from './ui/components/base-magic-alert.component';
import { BaseMagicConfirmComponent } from './ui/components/base-magic-confirm.component';
import { MagicViewContainerRef } from './ui/directives/magicViewContainerRef.directive';
import { MaskitoModule } from "@maskito/angular";
import { Time24MagicPipe } from "./ui/pipes/time24.magic.pipe";
import * as i0 from "@angular/core";
const decs = [
    MagicDirective,
    CheckboxMagicDirective,
    CheckboxNoFormControlMagicDirective,
    InputNoFormControlMagicDirective,
    ComboboxMagicDirective,
    RowMagicDirective,
    MagicCheckboxControlValueAccessor,
    MagicDefaultValueAccessor,
    DateValueAccessor,
    TaskBaseMagicComponent,
    MagicOverlayContainer,
    MagicAlertComponent,
    MagicConfirmationBoxComponent,
    BaseMagicAlertComponent,
    BaseMagicConfirmComponent,
    MagicOverlayContainerWrapper,
    RouterContainerMagicComponent,
    MagicShellComponent,
    SubformMagicComponent,
    ErrorMagicComponent,
    NoControlMagicDirective,
    MgformatMagicDirective,
    DateMagicPipe,
    TimeMagicPipe,
    RangeValidatorMagicDirective,
    NonMagicControlDirective,
    MagicFocusDirective,
    MagicViewContainerRef,
    Time24MagicPipe
];
export class MagicModule {
}
MagicModule.ɵfac = function MagicModule_Factory(t) { return new (t || MagicModule)(); };
MagicModule.ɵmod = i0.ɵɵdefineNgModule({ type: MagicModule });
MagicModule.ɵinj = i0.ɵɵdefineInjector({ providers: [ConfirmationComponentsMagicProvider, OverlayContainerMagicProvider], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        RouterModule,
        DynamicModule,
        HttpClientModule, MaskitoModule] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicModule, [{
        type: NgModule,
        args: [{
                declarations: [...decs],
                exports: [...decs, MaskitoModule],
                entryComponents: [],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule,
                    RouterModule,
                    DynamicModule,
                    HttpClientModule
                ],
                providers: [ConfirmationComponentsMagicProvider, OverlayContainerMagicProvider]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MagicModule, { declarations: [MagicDirective,
        CheckboxMagicDirective,
        CheckboxNoFormControlMagicDirective,
        InputNoFormControlMagicDirective,
        ComboboxMagicDirective,
        RowMagicDirective,
        MagicCheckboxControlValueAccessor,
        MagicDefaultValueAccessor,
        DateValueAccessor,
        TaskBaseMagicComponent,
        MagicOverlayContainer,
        MagicAlertComponent,
        MagicConfirmationBoxComponent,
        BaseMagicAlertComponent,
        BaseMagicConfirmComponent,
        MagicOverlayContainerWrapper,
        RouterContainerMagicComponent,
        MagicShellComponent,
        SubformMagicComponent,
        ErrorMagicComponent,
        NoControlMagicDirective,
        MgformatMagicDirective,
        DateMagicPipe,
        TimeMagicPipe,
        RangeValidatorMagicDirective,
        NonMagicControlDirective,
        MagicFocusDirective,
        MagicViewContainerRef,
        Time24MagicPipe], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        RouterModule,
        DynamicModule,
        HttpClientModule], exports: [MagicDirective,
        CheckboxMagicDirective,
        CheckboxNoFormControlMagicDirective,
        InputNoFormControlMagicDirective,
        ComboboxMagicDirective,
        RowMagicDirective,
        MagicCheckboxControlValueAccessor,
        MagicDefaultValueAccessor,
        DateValueAccessor,
        TaskBaseMagicComponent,
        MagicOverlayContainer,
        MagicAlertComponent,
        MagicConfirmationBoxComponent,
        BaseMagicAlertComponent,
        BaseMagicConfirmComponent,
        MagicOverlayContainerWrapper,
        RouterContainerMagicComponent,
        MagicShellComponent,
        SubformMagicComponent,
        ErrorMagicComponent,
        NoControlMagicDirective,
        MgformatMagicDirective,
        DateMagicPipe,
        TimeMagicPipe,
        RangeValidatorMagicDirective,
        NonMagicControlDirective,
        MagicFocusDirective,
        MagicViewContainerRef,
        Time24MagicPipe, MaskitoModule] }); })();
//# sourceMappingURL=data:application/json;base64,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