import { ComponentFactoryResolver, Injectable } from "@angular/core";
import { ComponentListMagicService } from "./component-list.magic.service";
import { EngineMagicService } from "./engine.magic.service";
import { getGuiEventObj } from "@magic-xpa/engine";
import { OverlayContainerMagicProvider } from "./overlay.conainer.magic.provider";
import { MagicOverlayContainerWrapper } from "../ui/magic-modal/magic-overlay-container-wrapper";
import { ConfirmationComponentsMagicProvider } from "./confirmation.components.magic.provider";
import { OverlayType } from "@magic-xpa/gui";
import { confirmationBox } from "../ui/magic-confirmationBox";
import { isNullOrUndefined } from "@magic-xpa/mscorelib";
import * as i0 from "@angular/core";
import * as i1 from "./component-list.magic.service";
import * as i2 from "./engine.magic.service";
import * as i3 from "./overlay.conainer.magic.provider";
import * as i4 from "./confirmation.components.magic.provider";
export class OverlayWindowService {
    constructor(componentFactoryResolver, componentList, engineMagicService, overlayContainerMagicProvider, confirmationComponentsMagicProvider) {
        this.componentFactoryResolver = componentFactoryResolver;
        this.componentList = componentList;
        this.engineMagicService = engineMagicService;
        this.overlayContainerMagicProvider = overlayContainerMagicProvider;
        this.confirmationComponentsMagicProvider = confirmationComponentsMagicProvider;
        this.overlayWindowFocusManager = null;
    }
    init(overlayWindowsContainerViewRef, rootMagicElement) {
        this.overlayWindowsContainerViewRef = overlayWindowsContainerViewRef;
        this.overlayWindowFocusManager = new OverlayWindowFocusManager(rootMagicElement);
    }
    open(formName, taskId, taskDescription) {
        let comp = this.componentList.lazyLoadModulesMap != null && this.componentList.lazyLoadModulesMap.hasOwnProperty(formName) ? null : this.componentList.getComponent(formName);
        let parameters = { taskIdParam: taskId, taskDescription: taskDescription };
        let componentRef = this.createModalComponent({ MagicFormName: formName, ModalComp: comp, ModalCompParameters: parameters }, this.overlayContainerMagicProvider.getComponent(), OverlayType.Overlay);
        componentRef.instance.onClose.subscribe(() => {
            let guiEvent = getGuiEventObj("close", null, 0);
            guiEvent.TaskID = taskId;
            this.engineMagicService.insertEvent(guiEvent);
        });
    }
    close(commandStr) {
        this.overlayWindowsContainerViewRef.remove();
        this.overlayWindowFocusManager.popDialog();
        let guiEvent1 = getGuiEventObj("dispose", null, 0);
        guiEvent1.TaskID = commandStr;
        this.engineMagicService.insertEvent(guiEvent1);
    }
    openConfirmationBox(title, msg, style) {
        if (this.confirmationComponentsMagicProvider.showDefaultConfirmations()) {
            let res = confirmationBox.showConfirmationBox(title, msg, style);
            this.finishConfirmation(style, res);
        }
        else {
            let comp = confirmationBox.isConfirmBox(style) ? this.confirmationComponentsMagicProvider.getConfirmtionComponent() : this.confirmationComponentsMagicProvider.getAlertComponent();
            let overlayType = confirmationBox.isConfirmBox(style) ? OverlayType.ConfirmationBox : OverlayType.Alert;
            let componentRef = this.createModalComponent({ title: title, message: msg }, comp, overlayType);
            componentRef.instance.onClose.subscribe((res) => {
                this.overlayWindowsContainerViewRef.remove();
                this.overlayWindowFocusManager.popDialog();
                this.finishConfirmation(style, res);
            });
        }
    }
    finishConfirmation(style, result) {
        let guiEvent = getGuiEventObj("confirmationClosed", null, 0);
        guiEvent.keyCode = confirmationBox.convertToExcpectedResultBox(style, result);
        this.engineMagicService.insertEvent(guiEvent);
    }
    createModalComponent(parameters, component, overlayType) {
        let componentRef;
        let magicModalContainerParameters = {
            Component: component,
            Parameters: parameters,
            OverlayTypeParam: overlayType
        };
        const factory = this.componentFactoryResolver.resolveComponentFactory(MagicOverlayContainerWrapper);
        let viewCRef = this.overlayWindowsContainerViewRef;
        componentRef = viewCRef.createComponent(factory);
        Object.assign(componentRef.instance, magicModalContainerParameters);
        this.overlayWindowFocusManager.pushDialog(componentRef.instance.GetRootElement());
        componentRef.instance.DetectChanges();
        return componentRef;
    }
}
OverlayWindowService.ɵfac = function OverlayWindowService_Factory(t) { return new (t || OverlayWindowService)(i0.ɵɵinject(i0.ComponentFactoryResolver), i0.ɵɵinject(i1.ComponentListMagicService), i0.ɵɵinject(i2.EngineMagicService), i0.ɵɵinject(i3.OverlayContainerMagicProvider), i0.ɵɵinject(i4.ConfirmationComponentsMagicProvider)); };
OverlayWindowService.ɵprov = i0.ɵɵdefineInjectable({ token: OverlayWindowService, factory: OverlayWindowService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(OverlayWindowService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i0.ComponentFactoryResolver }, { type: i1.ComponentListMagicService }, { type: i2.EngineMagicService }, { type: i3.OverlayContainerMagicProvider }, { type: i4.ConfirmationComponentsMagicProvider }]; }, null); })();
class OverlayWindowFocusManager {
    constructor(rootMagicElement) {
        this.rootMagicElement = null;
        this.openDialogList = new Array(0);
        this.ignoreUtilFocusChanges = false;
        this.lastFocus = null;
        this.focusListener = null;
        this.rootMagicElement = rootMagicElement;
    }
    pushDialog(rootElement) {
        if (this.openDialogList.length === 0) {
            this.focusListener = this.trapFocus.bind(this);
            document.addEventListener('focus', this.focusListener, true);
        }
        this.openDialogList.push(new DialogInfo(rootElement, (document.activeElement instanceof HTMLElement ? document.activeElement : null)));
    }
    popDialog() {
        const dialogInfo = this.openDialogList.pop();
        this.attemptFocus(dialogInfo.FocusElementOnClose);
        if (this.openDialogList.length === 0) {
            document.removeEventListener('focus', this.focusListener, true);
            this.focusListener = null;
        }
    }
    trapFocus(event) {
        if (this.ignoreUtilFocusChanges) {
            return;
        }
        if (this.openDialogList.length > 0) {
            var currentDialog = this.openDialogList[this.openDialogList.length - 1].RootElement;
            if (currentDialog.contains(event.target)) {
                this.lastFocus = event.target;
            }
            else {
                if (this.rootMagicElement.contains(event.target)) {
                    this.focusFirstDescendant(currentDialog);
                    if (this.lastFocus == document.activeElement) {
                        this.focusLastDescendant(currentDialog);
                    }
                }
                this.lastFocus = document.activeElement;
            }
        }
    }
    focusFirstDescendant(element) {
        for (var i = 0; i < element.childNodes.length; i++) {
            var child = element.childNodes[i];
            if (this.attemptFocus(child) ||
                this.focusFirstDescendant(child)) {
                return true;
            }
        }
        return false;
    }
    ;
    focusLastDescendant(element) {
        for (var i = element.childNodes.length - 1; i >= 0; i--) {
            var child = element.childNodes[i];
            if (this.attemptFocus(child) ||
                this.focusLastDescendant(child)) {
                return true;
            }
        }
        return false;
    }
    ;
    attemptFocus(element) {
        if (!this.isFocusable(element)) {
            return false;
        }
        this.ignoreUtilFocusChanges = true;
        try {
            element.focus();
        }
        catch (e) {
        }
        this.ignoreUtilFocusChanges = false;
        return (document.activeElement === element);
    }
    ;
    isFocusable(element) {
        if (isNullOrUndefined(element))
            return false;
        if (element.tabIndex > 0 || (element.tabIndex === 0 && element.getAttribute('tabIndex') !== null)) {
            return true;
        }
        else if (element.tabIndex < 0)
            return false;
        if (element.disabled) {
            return false;
        }
        switch (element.nodeName) {
            case 'A':
                return !!element.href && element.rel != 'ignore';
            case 'INPUT':
                return element.type != 'hidden' && element.type != 'file';
            case 'BUTTON':
            case 'SELECT':
            case 'TEXTAREA':
                return true;
            default:
                return false;
        }
    }
}
class DialogInfo {
    constructor(rootElement, focusElementOnClose) {
        this.rootElement = rootElement;
        this.focusElementOnClose = focusElementOnClose;
    }
    get RootElement() {
        return this.rootElement;
    }
    get FocusElementOnClose() {
        return this.focusElementOnClose;
    }
}
//# sourceMappingURL=data:application/json;base64,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