import { MagicProperties } from "@magic-xpa/utils";
import { NString, isNullOrUndefined } from "@magic-xpa/mscorelib";
export class StylesMapManager {
    static magicValueGetStyle(styleName, magicValue) {
        let style = "";
        if (!isNullOrUndefined(magicValue)) {
            let value = StylesMapManager.StylesMap.get(styleName);
            if (value.constructor === Map) {
                style = value.get(magicValue);
            }
            else if (value.constructor === String) {
                style = NString.Format(value.toString(), magicValue);
            }
        }
        return style;
    }
}
StylesMapManager.StylesMap = new Map([
    [MagicProperties.LineDivider, new Map([[true, "solid"], [false, "hidden"]])],
    [MagicProperties.ImageFile, "url('\{0}\')"],
    [MagicProperties.Wallpaper, "url('\{0}\')"]
]);
StylesMapManager.MagicPropertyToHtmlAttributeMap = new Map([
    [MagicProperties.LineDivider, "border-bottom-style"],
    [MagicProperties.ImageFile, "background-image"],
    [MagicProperties.Wallpaper, "background-image"]
]);
//# sourceMappingURL=data:application/json;base64,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