import { Injectable } from '@angular/core';
import { TaskMagicService } from './task.magics.service';
import { GuiEnvironment, HtmlProperties, PIC } from '@magic-xpa/gui';
import { isNullOrUndefined, StringBuilder } from '@magic-xpa/mscorelib';
import { getGuiEventObj, CookieService } from '@magic-xpa/engine';
import { Logger, PICInterface, StorageAttribute } from '@magic-xpa/utils';
import { MagicColorService } from './magic-color.service';
import { maskitoTimeOptionsGenerator } from "@maskito/kit";
import * as i0 from "@angular/core";
import * as i1 from "./task.magics.service";
import * as i2 from "./magic-color.service";
export class AccessorMagicService {
    constructor(task, magicColor) {
        this.task = task;
        this.magicColor = magicColor;
        this.Logger = null;
        this.hhmm = maskitoTimeOptionsGenerator({ mode: 'HH:MM' });
        this.hhmmss = maskitoTimeOptionsGenerator({ mode: 'HH:MM:SS' });
        this.Logger = Logger.Instance;
    }
    checkIsReadOnly(controlId) {
        let properties;
        properties = this.task.Records.list[0].getControlMetadata(controlId);
        if (properties.properties.get(HtmlProperties.ReadOnly) !== null && properties.properties.get(HtmlProperties.ReadOnly) === true)
            return true;
        else
            return false;
    }
    getText(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.Text, rowId);
    }
    getTabpageText(controlId, layer) {
        const items = this.task.getProperty(controlId, HtmlProperties.ItemsList);
        if (typeof items !== "undefined")
            return items[layer].displayValue;
        return "";
    }
    getImage(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Image, rowId);
        return result;
    }
    isImageExists(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Image, rowId);
        return !isNullOrUndefined(result);
    }
    getClasses(controlId, rowId) {
        return this.task.getClasses(controlId, rowId);
    }
    getStyle(controlId, styleName, rowId) {
        let style = this.task.getStyle(controlId, styleName, rowId);
        return style;
    }
    getVisible(controlId, rowId) {
        let vis = this.getProperty(controlId, HtmlProperties.Visible, rowId);
        return vis ? 'visible' : 'hidden';
    }
    getAlphaMask(controlId, rowId) {
        if (isNullOrUndefined(controlId))
            return null;
        let pic = this.task.GetControlPictureMask(controlId);
        let mask = pic.getMask();
        let valueStr = new StringBuilder();
        for (let i = 0; i < mask.length; i++) {
            switch (mask.charCodeAt(i)) {
                case PICInterface.PIC_N:
                    valueStr.Append("0");
                    break;
                case PICInterface.PIC_U:
                case PICInterface.PIC_L:
                case PICInterface.PIC_X:
                    valueStr.Append("A");
                    break;
                default:
                    valueStr.Append(mask.charAt(i));
                    break;
            }
        }
        return (pic != null) ? valueStr.toString() : null;
    }
    getNumericPicture(picture) {
        var obj = {};
        if (isNullOrUndefined(picture))
            return obj;
        let pic = new PIC(picture, StorageAttribute.NUMERIC, 0);
        obj['prefix'] = "";
        if (pic.getPosPref_().length > 0 && pic.getNegPref_().length > 0) {
            let pref = '-' + pic.getPosPref_();
            if (pref == pic.getNegPref_())
                obj['prefix'] = pic.getPosPref_();
        }
        if (pic.getPosSuff_().length > 0)
            obj['suffix'] = pic.getPosSuff_();
        else
            obj['suffix'] = "";
        if (pic.isNegative())
            obj['allowNegative'] = true;
        else
            obj['allowNegative'] = false;
        if (pic.getDec() >= 0)
            obj['precision'] = pic.getDec();
        if (pic.isLeft())
            obj['align'] = "left";
        obj['decimal'] = GuiEnvironment.Environment.GetDecimal();
        if (pic.withComa())
            obj['thousands'] = GuiEnvironment.Environment.GetThousands();
        else
            obj['thousands'] = "";
        if (pic.getWholes())
            obj['wholes'] = pic.getWholes();
        return obj;
    }
    getMustInput(controlId, rowId) {
        let vis = this.getProperty(controlId, HtmlProperties.MustInput, rowId);
        return vis ? 'true' : 'false';
    }
    isDisabled(controlId, rowId) {
        let result = this.getProperty(controlId, HtmlProperties.Enabled, rowId);
        return result === true ? null : true;
    }
    getProperty(controlId, prop, rowId) {
        return this.task.getProperty(controlId, prop, rowId);
    }
    getTitle(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.Tooltip, rowId);
    }
    getZoomButtonTitle(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.ZoomButtonTooltip, rowId);
    }
    getSelectedValue(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.SelectedValue, rowId);
    }
    getPlaceholder(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.PlaceHolder, rowId);
    }
    getType(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Password, rowId);
        return result ? "password" : "text";
    }
    getTabIndex(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.TabIndex, rowId);
    }
    getValue(controlId, rowId) {
        let val = this.task.getValue(controlId, rowId);
        return val;
    }
    getFormattedValue(controlId, rowId) {
        let val = this.task.getValue(controlId, rowId);
        val = this.task.getFormattedValue(controlId, val, rowId);
        return val;
    }
    getPicture(controlId, rowId) {
        if (isNullOrUndefined(controlId))
            return null;
        let pic = this.task.GetControlPictureMask(controlId);
        return (pic != null) ? pic.getFormat().toString() : null;
    }
    getCustomProperty(controlId, propertyNameOrRowID, rowId) {
        if (controlId.indexOf('~') == -1)
            return this.getCustomProperty_1(controlId, propertyNameOrRowID, rowId);
        else {
            let cid = controlId.split('~')[0];
            let propName = controlId.split('~')[1];
            return this.getCustomProperty_1(cid, propName, propertyNameOrRowID);
        }
    }
    getCustomProperty_1(controlId, propertyName, rowId) {
        let userProperties;
        if (isNullOrUndefined(rowId))
            rowId = '0';
        let rec = this.task.Records.list[rowId];
        if (isNullOrUndefined(rec))
            debugger;
        else {
            const controlMetadata = rec.getControlMetadata(controlId);
            if (controlMetadata.userProperties.has(propertyName)) {
                userProperties = controlMetadata.userProperties.get(propertyName);
            }
        }
        return userProperties;
    }
    getItemListValues(id, rowId) {
        return this.getProperty(id, HtmlProperties.ItemsList, rowId);
    }
    getFilteredList(controlId, rowId) {
        if (isNullOrUndefined(rowId))
            rowId = '0';
        let items = this.getItemListValues(controlId, rowId);
        let value = this.task.getFormControl(rowId, controlId).value;
        if (value !== null && value !== "" && items instanceof Array) {
            value = value.toLowerCase();
            return items.filter(option => option.displayValue.toLowerCase().includes(value));
        }
        else
            return items;
    }
    getDisplayValue(id, rowId) {
        let displayValue = "";
        let o = this.getProperty(id, HtmlProperties.ItemsList, rowId);
        let value = this.task.getValue(id, rowId);
        if (value >= 0 && value < o.length && !isNullOrUndefined(o[value]))
            displayValue = o[value].displayValue;
        return displayValue;
    }
    isOptionSelected(index, controlId) {
        let val = this.task.getValue(controlId, "0");
        for (let item of val) {
            if (item === index)
                return true;
        }
        return false;
    }
    isTabPageSelected(controlId, layer) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedValue);
        return val == (layer - 1);
    }
    isTabPageLayerSelected(controlId, layer) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedLayer);
        return val == (layer - 1);
    }
    getTabSelectedIndex(controlId) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedValue);
        return val;
    }
    ifRowCreated(row) {
        if (row == null)
            return false;
        let rowId = typeof row == "number" ? row.toString() : row.rowId;
        let result = this.getFormGroupByRow(rowId);
        return !isNullOrUndefined(result);
    }
    getFormGroupByRow(id) {
        return this.task.formGroups[id];
    }
    isRowSelected(controlId, rowId) {
        const selectedRow = this.task.getProperty(controlId, HtmlProperties.SelectedRow, "0");
        return selectedRow == rowId;
    }
    isRowInRowEditing(row) {
        let guiRowId = '0';
        guiRowId = typeof row == "number" ? row.toString() : row.rowId;
        return this.task.isRowInRowEditing(guiRowId);
    }
    isCurrentInRowEditing() {
        let row = this.task.tableService.getSelectedRow();
        return this.task.isRowInRowEditing(row);
    }
    guiTopIndex() {
        return this.task.tableService.getTableTopIndex();
    }
    getErrMsg(id, rowId) {
        let c = this.task.getFormControl(rowId, id);
        if (c.hasError('required'))
            return 'Control must be updated.';
        if (c.hasError('pattern')) {
            if (c.errors.pattern.actualValue < 0 && !c.errors.pattern.requiredPattern.includes('-'))
                return 'Value must be non-negative';
            if (c.errors.pattern.requiredPattern.includes('.')) {
                const numericFormat = Math.abs(c.errors.pattern.actualValue).toString().split('.')[0];
                const decimalFormat = Math.abs(c.errors.pattern.actualValue).toString().split('.')[1];
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                const actualDecimalLimit = c.errors.pattern.requiredPattern.match(/(?:[^,]+,){2}(\d+)/)[1];
                if (numericFormat.length > actualNumericLimit || decimalFormat.length > actualDecimalLimit) {
                    return "Numeric format is limited to " + actualNumericLimit + "." + actualDecimalLimit + " digits";
                }
            }
            else if (!c.errors.pattern.requiredPattern.includes('.') && !Number.isInteger(c.errors.pattern.actualValue)) {
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                return "Numeric format is limited to " + actualNumericLimit + "." + 0 + " digits";
            }
            else {
                const numericFormat = Math.abs(c.errors.pattern.actualValue).toString();
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                if (numericFormat.length > actualNumericLimit) {
                    return "Numeric format is limited to " + actualNumericLimit + "." + 0 + " digits";
                }
            }
        }
        if (c.hasError('rangevalidator'))
            return c.errors.rangevalidator.errorMsg;
        if (c.hasError('maxlength'))
            return 'Max length allowed is : ' + c.errors.maxlength.requiredLength;
        if (c.hasError('max'))
            return 'Max value allowed is : ' + c.errors.max.max;
        let controlMetadata = this.task.Records.list[rowId].getControlMetadata(id);
        for (let key of controlMetadata.customValidators.keys()) {
            if (c.hasError(key)) {
                let customValidator = controlMetadata.customValidators.get(key);
                return customValidator.getErrMessage();
            }
        }
        return 'unknown error';
    }
    setValueToControl(controlName, value, refreshDisplay) {
        if (typeof refreshDisplay === "undefined")
            refreshDisplay = true;
        let guiEvent = getGuiEventObj("setexternalvalue", controlName, 0);
        guiEvent.externalValue = value;
        guiEvent.param = refreshDisplay;
        this.task.insertEvent(guiEvent);
    }
    isDataviewEmpty() {
        return this.task.Records.isEmptyDataView;
    }
    simulateClick(controlName, rowId) {
        if (typeof rowId === "undefined")
            rowId = 0;
        this.task.insertEvent(getGuiEventObj('click', controlName, rowId));
    }
    isLoggedIn() {
        return this.task.getIsLoggenIn();
    }
    GetFormRecords() {
        let rowId = 0;
        let recArray;
        if (!isNullOrUndefined(this.task.Records) && this.task.Records.list.length > 0) {
            let recList = this.task.Records.list;
            let tableControls = new Array();
            for (const key in this.task.template) {
                if (this.task.template[key] == '1')
                    tableControls.push(key);
            }
            recArray = new Array();
            if (tableControls.length > 0) {
                recList.forEach((ctrlMetaData) => {
                    if (this.task.Records.isRowCreated(rowId)) {
                        var formRecord = {};
                        formRecord['rowId'] = rowId;
                        tableControls.forEach((ctrlId) => {
                            formRecord[ctrlId] = ctrlMetaData.values[ctrlId];
                        });
                        recArray.push(formRecord);
                    }
                });
            }
        }
        return recArray;
    }
    SetCookie(name, value, expires, path, domain, secure, sameSite) {
        CookieService.setCookie(name, value, expires, path, domain, secure, sameSite);
    }
    GetCookie(name) {
        return CookieService.getCookie(name);
    }
    DeleteCookie(name) {
        return CookieService.deleteCookie(name);
    }
    getColor(colorNumber, colorType) {
        return this.magicColor.getColor(colorNumber, colorType);
    }
}
AccessorMagicService.ɵfac = function AccessorMagicService_Factory(t) { return new (t || AccessorMagicService)(i0.ɵɵinject(i1.TaskMagicService), i0.ɵɵinject(i2.MagicColorService)); };
AccessorMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: AccessorMagicService, factory: AccessorMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AccessorMagicService, [{
        type: Injectable
    }], function () { return [{ type: i1.TaskMagicService }, { type: i2.MagicColorService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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