import { Injectable } from '@angular/core';
import { EngineMagicService } from './engine.magic.service';
import { List } from '@magic-xpa/mscorelib';
import { Logger } from '@magic-xpa/utils';
import * as i0 from "@angular/core";
import * as i1 from "./engine.magic.service";
export class CommandsCollectorMagicService {
    constructor(magic) {
        this.magic = magic;
        this.count = 0;
        this.commands = new List();
        this.subscription = null;
    }
    startCollecting() {
        this.count++;
        Logger.Instance.WriteDevToLog("CommandsCollectorMagicService.startCollecting() --- " + this.count);
        if (this.subscription === null) {
            this.subscription = this.magic.refreshDom
                .subscribe(command => {
                this.commands.push(command);
            });
        }
    }
    stopCollecting() {
        this.count--;
        Logger.Instance.WriteDevToLog("CommandsCollectorMagicService.stopCollecting() --- " + this.count);
        if (this.count === 0) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
    GetCommands(taskId) {
        const commands = this.commands.filter((command) => command.TaskTag === taskId);
        commands.forEach(command => { this.commands.Remove(command); });
        return commands;
    }
}
CommandsCollectorMagicService.ɵfac = function CommandsCollectorMagicService_Factory(t) { return new (t || CommandsCollectorMagicService)(i0.ɵɵinject(i1.EngineMagicService)); };
CommandsCollectorMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: CommandsCollectorMagicService, factory: CommandsCollectorMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CommandsCollectorMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.EngineMagicService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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