import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class ComponentListMagicService {
    constructor() {
        this.components = new Map();
        this.dialogs = new Map();
        this.lazyLoadModulesMap = null;
    }
    getData(name, mustHaveData) {
        let data = null;
        let haveData = this.components.has(name);
        if (!haveData && mustHaveData) {
            console.log("Error: Component: " + name + " does not exist in components map");
        }
        if (haveData)
            data = this.components.get(name);
        return data;
    }
    getComponent(name, mustHaveData = true) {
        let data = this.getData(name, mustHaveData);
        return data ? data.component : null;
    }
    addComponents(componentList, modulRef) {
        for (let key in componentList) {
            let data = { moduleRef: modulRef, component: componentList[key] };
            this.components.set(key, data);
        }
    }
    getModuleRef(name) {
        let data = this.getData(name, false);
        return data ? data.moduleRef : null;
        ;
    }
    getLazyLoadModuleData(name) {
        return (this.lazyLoadModulesMap != null && this.lazyLoadModulesMap.hasOwnProperty(name)) ? this.lazyLoadModulesMap[name] : null;
    }
}
ComponentListMagicService.ɵfac = function ComponentListMagicService_Factory(t) { return new (t || ComponentListMagicService)(); };
ComponentListMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: ComponentListMagicService, factory: ComponentListMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ComponentListMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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