import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import { MagicBridge } from "@magic-xpa/engine";
import * as i0 from "@angular/core";
export class EngineMagicService {
    constructor() {
        this.magicBridge = MagicBridge;
        this.isStub = false;
        this.isLoggedIn = false;
        this.refreshDom = new Subject();
        this.interactiveCommands = new Subject();
    }
    startMagicEngine(httpClient) {
        this.magicBridge.registerExecuteCommandsCallback(data => {
            if (!this.isStub) {
                try {
                    const list = data;
                    for (let c of list) {
                        this.refreshDom.next(c);
                    }
                }
                catch (e) {
                    console.dir(e);
                    console.log('magic engine not found');
                    console.log('moving to stub mode');
                    this.isStub = true;
                }
            }
        });
        this.magicBridge.registerInteractiveCallback(data => {
            if (!this.isStub) {
                this.interactiveCommands.next(data);
            }
        });
        this.magicBridge.Initialize(httpClient);
    }
    async terminateMagic() {
        await this.magicBridge.TerminateMagic();
    }
    insertEvent(guiEvent) {
        if (!this.isStub)
            this.magicBridge.insertEvent(guiEvent);
    }
    GetRangedValue(taskId, controlName, value) {
        return this.magicBridge.GetRangedValue(taskId, controlName, value);
    }
    GetControlPictureMask(taskId, controlName) {
        return this.magicBridge.GetControlPictureMask(taskId, controlName);
    }
    GetFormattedValue(taskId, controlName, value, rowId) {
        return this.magicBridge.GetFormattedValue(taskId, controlName, value, rowId);
    }
    ValidateControlValue(taskId, controlName, value) {
        return this.magicBridge.ValidateControlValue(taskId, controlName, value);
    }
    GetFldRanges(taskId, controlName) {
        return this.magicBridge.GetFldRanges(taskId, controlName);
    }
    saveData(data) {
    }
    getIsLoggedIn() {
        return this.isLoggedIn;
    }
    setIsLoggedIn(setIsLoggedIn) {
        this.isLoggedIn = setIsLoggedIn;
    }
    TransCacheExists() {
        return this.magicBridge.TransCacheExists();
    }
    TerminateContextUsingFetchAPI() {
        this.magicBridge.TerminateContextUsingFetchAPI();
    }
}
EngineMagicService.ɵfac = function EngineMagicService_Factory(t) { return new (t || EngineMagicService)(); };
EngineMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: EngineMagicService, factory: EngineMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EngineMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5naW5lLm1hZ2ljLnNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9hbmd1bGFyL3NyYy9zZXJ2aWNlcy9lbmdpbmUubWFnaWMuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUMsVUFBVSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBQ3pDLE9BQU8sRUFBQyxPQUFPLEVBQUMsTUFBTSxNQUFNLENBQUM7QUFFN0IsT0FBTyxFQUFZLFdBQVcsRUFBQyxNQUFNLG1CQUFtQixDQUFDOztBQVV6RCxNQUFNLE9BQU8sa0JBQWtCO0lBSC9CO1FBSUUsZ0JBQVcsR0FBRyxXQUFXLENBQUM7UUFDMUIsV0FBTSxHQUFHLEtBQUssQ0FBQztRQUVmLGVBQVUsR0FBRyxLQUFLLENBQUM7UUFFbkIsZUFBVSxHQUF3QixJQUFJLE9BQU8sRUFBRSxDQUFDO1FBQ2hELHdCQUFtQixHQUE0QixJQUFJLE9BQU8sRUFBRSxDQUFDO0tBOEU5RDtJQTVFQyxnQkFBZ0IsQ0FBQyxVQUFzQjtRQUNyQyxJQUFJLENBQUMsV0FBVyxDQUFDLCtCQUErQixDQUFDLElBQUksQ0FBQyxFQUFFO1lBQ3RELElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO2dCQUNoQixJQUFJO29CQUNGLE1BQU0sSUFBSSxHQUFHLElBQW9CLENBQUM7b0JBQ2xDLEtBQUssSUFBSSxDQUFDLElBQUksSUFBSSxFQUFFO3dCQUNsQixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztxQkFDekI7aUJBQ0Y7Z0JBQ0QsT0FBTyxDQUFDLEVBQUU7b0JBQ1IsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDZixPQUFPLENBQUMsR0FBRyxDQUFDLHdCQUF3QixDQUFDLENBQUM7b0JBQ3RDLE9BQU8sQ0FBQyxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztvQkFDbkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7aUJBQ3BCO2FBQ0Y7UUFDSCxDQUFDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxXQUFXLENBQUMsMkJBQTJCLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDbEQsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7Z0JBQ2QsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUNyQztRQUNMLENBQUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFdBQVcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVELEtBQUssQ0FBQyxjQUFjO1FBQ2xCLE1BQU0sSUFBSSxDQUFDLFdBQVcsQ0FBQyxjQUFjLEVBQUUsQ0FBQztJQUMxQyxDQUFDO0lBRUQsV0FBVyxDQUFDLFFBQW1CO1FBQzdCLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTTtZQUNkLElBQUksQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRCxjQUFjLENBQUMsTUFBYyxFQUFFLFdBQW1CLEVBQUUsS0FBYTtRQUMvRCxPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUVELHFCQUFxQixDQUFDLE1BQWMsRUFBRSxXQUFtQjtRQUN2RCxPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMscUJBQXFCLENBQUMsTUFBTSxFQUFFLFdBQVcsQ0FBQyxDQUFDO0lBQ3JFLENBQUM7SUFFRCxpQkFBaUIsQ0FBQyxNQUFjLEVBQUcsV0FBbUIsRUFBRSxLQUFVLEVBQUUsS0FBYztRQUNoRixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLFdBQVcsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0UsQ0FBQztJQUVELG9CQUFvQixDQUFDLE1BQWMsRUFBRSxXQUFtQixFQUFFLEtBQVU7UUFDbEUsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLG9CQUFvQixDQUFDLE1BQU0sRUFBRSxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDM0UsQ0FBQztJQUVELFlBQVksQ0FBQyxNQUFjLEVBQUUsV0FBbUI7UUFDOUMsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUVELFFBQVEsQ0FBQyxJQUFXO0lBR3BCLENBQUM7SUFFRCxhQUFhO1FBQ1gsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFFRCxhQUFhLENBQUMsYUFBc0I7UUFDbEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxhQUFhLENBQUM7SUFDbEMsQ0FBQztJQUVELGdCQUFnQjtRQUNkLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO0lBQzdDLENBQUM7SUFFRCw2QkFBNkI7UUFDM0IsSUFBSSxDQUFDLFdBQVcsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDO0lBQ25ELENBQUM7O29GQXBGVSxrQkFBa0I7MERBQWxCLGtCQUFrQixXQUFsQixrQkFBa0IsbUJBRmpCLE1BQU07dUZBRVAsa0JBQWtCO2NBSDlCLFVBQVU7ZUFBQztnQkFDVixVQUFVLEVBQUUsTUFBTTthQUNuQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7SW5qZWN0YWJsZX0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHtTdWJqZWN0fSBmcm9tIFwicnhqc1wiO1xyXG5cclxuaW1wb3J0IHtJR3VpRXZlbnQsIE1hZ2ljQnJpZGdlfSBmcm9tIFwiQG1hZ2ljLXhwYS9lbmdpbmVcIjtcclxuaW1wb3J0IHtHdWlDb21tYW5kLCBHdWlJbnRlcmFjdGl2ZX0gZnJvbSBcIkBtYWdpYy14cGEvZ3VpXCI7XHJcbmltcG9ydCB7SHR0cENsaWVudH0gZnJvbSBcIkBhbmd1bGFyL2NvbW1vbi9odHRwXCI7XHJcblxyXG4vKipcclxuICogQGlnbm9yZVxyXG4gKi9cclxuQEluamVjdGFibGUoe1xyXG4gIHByb3ZpZGVkSW46ICdyb290J1xyXG59KVxyXG5leHBvcnQgY2xhc3MgRW5naW5lTWFnaWNTZXJ2aWNlIHtcclxuICBtYWdpY0JyaWRnZSA9IE1hZ2ljQnJpZGdlO1xyXG4gIGlzU3R1YiA9IGZhbHNlO1xyXG4gIC8vIHRydWUgd2hlbiB1c2VyIGlzIGxvZ2dlZCBpbiBtYWdpY1xyXG4gIGlzTG9nZ2VkSW4gPSBmYWxzZTtcclxuICAvL1RPRE8gLSB1bnJlZ2lzdGVyXHJcbiAgcmVmcmVzaERvbTogU3ViamVjdDxHdWlDb21tYW5kPiA9IG5ldyBTdWJqZWN0KCk7XHJcbiAgaW50ZXJhY3RpdmVDb21tYW5kczogU3ViamVjdDxHdWlJbnRlcmFjdGl2ZT4gPSBuZXcgU3ViamVjdCgpO1xyXG5cclxuICBzdGFydE1hZ2ljRW5naW5lKGh0dHBDbGllbnQ6IEh0dHBDbGllbnQpIHtcclxuICAgIHRoaXMubWFnaWNCcmlkZ2UucmVnaXN0ZXJFeGVjdXRlQ29tbWFuZHNDYWxsYmFjayhkYXRhID0+IHtcclxuICAgICAgaWYgKCF0aGlzLmlzU3R1Yikge1xyXG4gICAgICAgIHRyeSB7XHJcbiAgICAgICAgICBjb25zdCBsaXN0ID0gZGF0YSBhcyBHdWlDb21tYW5kW107XHJcbiAgICAgICAgICBmb3IgKGxldCBjIG9mIGxpc3QpIHtcclxuICAgICAgICAgICAgdGhpcy5yZWZyZXNoRG9tLm5leHQoYyk7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGNhdGNoIChlKSB7XHJcbiAgICAgICAgICBjb25zb2xlLmRpcihlKTtcclxuICAgICAgICAgIGNvbnNvbGUubG9nKCdtYWdpYyBlbmdpbmUgbm90IGZvdW5kJyk7XHJcbiAgICAgICAgICBjb25zb2xlLmxvZygnbW92aW5nIHRvIHN0dWIgbW9kZScpO1xyXG4gICAgICAgICAgdGhpcy5pc1N0dWIgPSB0cnVlO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgfSk7XHJcblxyXG4gICAgdGhpcy5tYWdpY0JyaWRnZS5yZWdpc3RlckludGVyYWN0aXZlQ2FsbGJhY2soZGF0YSA9PiB7XHJcbiAgICAgIGlmICghdGhpcy5pc1N0dWIpIHtcclxuICAgICAgICAgIHRoaXMuaW50ZXJhY3RpdmVDb21tYW5kcy5uZXh0KGRhdGEpO1xyXG4gICAgICAgIH1cclxuICAgIH0pO1xyXG5cclxuICAgIHRoaXMubWFnaWNCcmlkZ2UuSW5pdGlhbGl6ZShodHRwQ2xpZW50KTtcclxuICB9XHJcblxyXG4gIGFzeW5jIHRlcm1pbmF0ZU1hZ2ljKCk6IFByb21pc2U8dm9pZD4ge1xyXG4gICAgYXdhaXQgdGhpcy5tYWdpY0JyaWRnZS5UZXJtaW5hdGVNYWdpYygpO1xyXG4gIH1cclxuXHJcbiAgaW5zZXJ0RXZlbnQoZ3VpRXZlbnQ6IElHdWlFdmVudCk6IHZvaWQge1xyXG4gICAgaWYgKCF0aGlzLmlzU3R1YilcclxuICAgICAgdGhpcy5tYWdpY0JyaWRnZS5pbnNlcnRFdmVudChndWlFdmVudCk7XHJcbiAgfVxyXG5cclxuICBHZXRSYW5nZWRWYWx1ZSh0YXNrSWQ6IHN0cmluZywgY29udHJvbE5hbWU6IHN0cmluZywgdmFsdWU6IHN0cmluZyk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5tYWdpY0JyaWRnZS5HZXRSYW5nZWRWYWx1ZSh0YXNrSWQsIGNvbnRyb2xOYW1lLCB2YWx1ZSk7XHJcbiAgfVxyXG5cclxuICBHZXRDb250cm9sUGljdHVyZU1hc2sodGFza0lkOiBzdHJpbmcsIGNvbnRyb2xOYW1lOiBzdHJpbmcpOiBhbnkge1xyXG4gICAgcmV0dXJuIHRoaXMubWFnaWNCcmlkZ2UuR2V0Q29udHJvbFBpY3R1cmVNYXNrKHRhc2tJZCwgY29udHJvbE5hbWUpO1xyXG4gIH1cclxuXHJcbiAgR2V0Rm9ybWF0dGVkVmFsdWUodGFza0lkOiBzdHJpbmcsICBjb250cm9sTmFtZTogc3RyaW5nLCB2YWx1ZTogYW55LCByb3dJZD86IHN0cmluZyk6IGFueSB7XHJcbiAgICByZXR1cm4gdGhpcy5tYWdpY0JyaWRnZS5HZXRGb3JtYXR0ZWRWYWx1ZSh0YXNrSWQsIGNvbnRyb2xOYW1lLCB2YWx1ZSwgcm93SWQpO1xyXG4gIH1cclxuXHJcbiAgVmFsaWRhdGVDb250cm9sVmFsdWUodGFza0lkOiBzdHJpbmcsIGNvbnRyb2xOYW1lOiBzdHJpbmcsIHZhbHVlOiBhbnkpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMubWFnaWNCcmlkZ2UuVmFsaWRhdGVDb250cm9sVmFsdWUodGFza0lkLCBjb250cm9sTmFtZSwgdmFsdWUpO1xyXG4gIH1cclxuXHJcbiAgR2V0RmxkUmFuZ2VzKHRhc2tJZDogc3RyaW5nLCBjb250cm9sTmFtZTogc3RyaW5nKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLm1hZ2ljQnJpZGdlLkdldEZsZFJhbmdlcyh0YXNrSWQsIGNvbnRyb2xOYW1lKTtcclxuICB9XHJcblxyXG4gIHNhdmVEYXRhKGRhdGE6c3RyaW5nKVxyXG4gIHtcclxuICAgIC8vdGhpcy5tYWdpY0JyaWRnZS5zYXZlRGF0YShkYXRhKTtcclxuICB9XHJcblxyXG4gIGdldElzTG9nZ2VkSW4oKTpib29sZWFue1xyXG4gICAgcmV0dXJuIHRoaXMuaXNMb2dnZWRJbjtcclxuICB9XHJcblxyXG4gIHNldElzTG9nZ2VkSW4oc2V0SXNMb2dnZWRJbjogYm9vbGVhbil7XHJcbiAgICB0aGlzLmlzTG9nZ2VkSW4gPSBzZXRJc0xvZ2dlZEluO1xyXG4gIH1cclxuXHJcbiAgVHJhbnNDYWNoZUV4aXN0cygpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLm1hZ2ljQnJpZGdlLlRyYW5zQ2FjaGVFeGlzdHMoKTtcclxuICB9XHJcblxyXG4gIFRlcm1pbmF0ZUNvbnRleHRVc2luZ0ZldGNoQVBJKCk6IHZvaWQge1xyXG4gICAgdGhpcy5tYWdpY0JyaWRnZS5UZXJtaW5hdGVDb250ZXh0VXNpbmdGZXRjaEFQSSgpO1xyXG4gIH1cclxufVxyXG4iXX0=