import { Inject, Injectable, InjectionToken } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export let COLOR_FILE_NAME = new InjectionToken('colorFile', {
    providedIn: 'root',
    factory: () => 'clr_rnt.eng'
});
export const MAGIC_FG_COLOR = 1;
export const MAGIC_BG_COLOR = 2;
const SYSTEM_FG = 2;
const SYSTEM_BG = 4;
const SYSTEM_FG_AND_SYSTEM_BG = 6;
const TRANSPERENT_BG = 1;
export class MagicColorService {
    getColorFilePath() {
        return 'assets/' + this.colorFileName;
    }
    constructor(http, colorFile1 = 'clr_rnt.eng') {
        this.http = http;
        this.colorFileName = 'clr_rnt.eng';
        this.fileNotFound = false;
        if (colorFile1)
            this.colorFileName = colorFile1;
        else
            this.colorFileName = 'clr_rnt.eng';
    }
    getColorData() {
        if (!this.colorsData) {
            this.http.get(this.getColorFilePath(), { responseType: 'text' }).subscribe(resp => {
                this.colorsData = resp.replace(/\n/g, '@').split('@');
            }, error1 => {
                console.error('File not found ' + this.colorFileName);
                this.fileNotFound = true;
            });
        }
    }
    hexToRgba(hex, isTransperent) {
        let shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])([a-f\d])$/i;
        hex = hex.replace(shorthandRegex, function (m, r, g, b, a) {
            return a + a + r + r + g + g + b + b;
        });
        let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        let rgb = {
            'red': parseInt(result[4], 16),
            'green': parseInt(result[3], 16),
            'blue': parseInt(result[2], 16),
            'alpha': (255 - parseInt(result[1], 16)) / 255
        };
        if (isTransperent)
            rgb.alpha = 0;
        return 'rgba(' + rgb.red + ',' + rgb.green + ',' + rgb.blue + ',' + rgb.alpha + ')';
    }
    getColor(colorIndex, colorType) {
        let isTransperent = false;
        if (!this.colorsData && !this.fileNotFound)
            this.getColorData();
        if (this.colorsData) {
            if (this.colorsData[colorIndex - 1]) {
                const grayHashCode = '00808080';
                let hex = grayHashCode;
                let color = this.colorsData[colorIndex - 1].split(',');
                let colorAtrributes = +color[3];
                switch (colorType) {
                    case MAGIC_FG_COLOR:
                        if (colorAtrributes != SYSTEM_FG && colorAtrributes != SYSTEM_FG_AND_SYSTEM_BG)
                            hex = (color[1]);
                        break;
                    case MAGIC_BG_COLOR:
                        if (colorAtrributes != SYSTEM_BG && colorAtrributes != SYSTEM_FG_AND_SYSTEM_BG) {
                            if (colorAtrributes == TRANSPERENT_BG)
                                isTransperent = true;
                            hex = (color[2]);
                        }
                        break;
                    default:
                        console.log('Please enter valid color type : 1-FG, 2-BG ' + colorIndex);
                        return '';
                }
                return this.hexToRgba('#' + hex, isTransperent);
            }
            else
                console.log('Could not get color for number ' + colorIndex);
        }
        return '';
    }
}
MagicColorService.ɵfac = function MagicColorService_Factory(t) { return new (t || MagicColorService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(COLOR_FILE_NAME)); };
MagicColorService.ɵprov = i0.ɵɵdefineInjectable({ token: MagicColorService, factory: MagicColorService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicColorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.HttpClient }, { type: undefined, decorators: [{
                type: Inject,
                args: [COLOR_FILE_NAME]
            }] }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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