import { MAT_DATE_LOCALE, NativeDateAdapter } from '@angular/material/core';
import { formatDate } from '@angular/common';
import { Platform } from '@angular/cdk/platform';
import { TaskMagicService } from "./task.magics.service";
import { Inject, Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/platform";
import * as i2 from "./task.magics.service";
export const MG_FORMATS = {
    parse: { dateInput: { month: 'short', year: 'numeric', day: 'numeric' } },
    display: {
        dateInput: 'input',
        monthYearLabel: { year: 'numeric', month: 'short' },
        dateA11yLabel: { year: 'numeric', month: 'long', day: 'numeric' },
        monthYearA11yLabel: { year: 'numeric', month: 'long' }
    }
};
export class MgDateAdapter extends NativeDateAdapter {
    constructor(platform, task, localeId) {
        super(localeId, platform);
        this.platform = platform;
        this.task = task;
        this.localeId = localeId;
        this.mgdtfmt = null;
        this.setLocale(localeId);
    }
    parse(value) {
        let valueStr = value;
        let date = 0, month = 0, year = 0;
        let mgDateMask = this.mgdtfmt;
        let sep = valueStr.indexOf('/') > 0 ? '/' : '-';
        if (value == null || value == "")
            return null;
        if (this.mgdtfmt == null && this.task.mgInputDateFormat != null)
            this.mgdtfmt = this.task.mgInputDateFormat;
        if ((this.mgdtfmt.indexOf('MMM') > 0) || (this.mgdtfmt.indexOf('MMMM') > 0))
            return new Date(value);
        if (mgDateMask !== null) {
            for (let i = 0; i < mgDateMask.length;) {
                switch (mgDateMask[i]) {
                    case 'd':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1)
                                valueStr = valueStr.substr(len + 1);
                            for (; mgDateMask[i] == 'd'; i++)
                                ;
                            date = (Number)(tmpStr);
                        }
                        break;
                    case 'M':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1)
                                valueStr = valueStr.substr(len + 1);
                            for (; mgDateMask[i] == 'M'; i++)
                                ;
                            month = (Number)(tmpStr) > 0 ? (Number)(tmpStr) - 1 : 0;
                        }
                        break;
                    case 'y':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1) {
                                valueStr = valueStr.substr(len + 1);
                            }
                            for (; mgDateMask[i] == 'y'; i++)
                                ;
                            year = (Number)(tmpStr);
                        }
                        break;
                    default:
                        i++;
                        break;
                }
            }
            if (month == 0 && year == 0 && date == 0)
                return null;
            return new Date(year, month, date);
        }
    }
    format(date, displayFormat) {
        if (this.mgdtfmt == null && this.task.mgInputDateFormat != null)
            this.mgdtfmt = this.task.mgInputDateFormat;
        if (displayFormat === 'input') {
            if (this.mgdtfmt == null)
                this.mgdtfmt = 'M/d/yyyy';
            return formatDate(date, this.mgdtfmt, this.locale);
        }
        else {
            return date.toDateString();
        }
    }
}
MgDateAdapter.ɵfac = function MgDateAdapter_Factory(t) { return new (t || MgDateAdapter)(i0.ɵɵinject(i1.Platform), i0.ɵɵinject(i2.TaskMagicService), i0.ɵɵinject(MAT_DATE_LOCALE)); };
MgDateAdapter.ɵprov = i0.ɵɵdefineInjectable({ token: MgDateAdapter, factory: MgDateAdapter.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgDateAdapter, [{
        type: Injectable
    }], function () { return [{ type: i1.Platform }, { type: i2.TaskMagicService }, { type: undefined, decorators: [{
                type: Inject,
                args: [MAT_DATE_LOCALE]
            }] }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWctZGF0ZS1hZGFwdGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvYW5ndWxhci9zcmMvc2VydmljZXMvbWctZGF0ZS1hZGFwdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBQyxlQUFlLEVBQUUsaUJBQWlCLEVBQUMsTUFBTSx3QkFBd0IsQ0FBQztBQUMxRSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFDN0MsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLHVCQUF1QixDQUFDO0FBQ2pELE9BQU8sRUFBQyxnQkFBZ0IsRUFBQyxNQUFNLHVCQUF1QixDQUFDO0FBQ3ZELE9BQU8sRUFBQyxNQUFNLEVBQUUsVUFBVSxFQUFDLE1BQU0sZUFBZSxDQUFDOzs7O0FBRWpELE1BQU0sQ0FBQyxNQUFNLFVBQVUsR0FBRztJQUN4QixLQUFLLEVBQUUsRUFBQyxTQUFTLEVBQUUsRUFBQyxLQUFLLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLFNBQVMsRUFBQyxFQUFDO0lBQ3JFLE9BQU8sRUFBRTtRQUNQLFNBQVMsRUFBRSxPQUFPO1FBQ2xCLGNBQWMsRUFBRSxFQUFDLElBQUksRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBQztRQUNqRCxhQUFhLEVBQUUsRUFBQyxJQUFJLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsR0FBRyxFQUFFLFNBQVMsRUFBQztRQUMvRCxrQkFBa0IsRUFBRSxFQUFDLElBQUksRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBQztLQUNyRDtDQUNGLENBQUM7QUFJRixNQUFNLE9BQU8sYUFBYyxTQUFRLGlCQUFpQjtJQUVsRCxZQUNXLFFBQWtCLEVBQ2YsSUFBc0IsRUFDQSxRQUFnQjtRQUdoRCxLQUFLLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBTG5CLGFBQVEsR0FBUixRQUFRLENBQVU7UUFDZixTQUFJLEdBQUosSUFBSSxDQUFrQjtRQUNBLGFBQVEsR0FBUixRQUFRLENBQVE7UUFKN0MsWUFBTyxHQUFXLElBQUksQ0FBQztRQVExQixJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzdCLENBQUM7SUFFRCxLQUFLLENBQUUsS0FBVTtRQUVmLElBQUksUUFBUSxHQUFXLEtBQUssQ0FBQztRQUM3QixJQUFJLElBQUksR0FBRyxDQUFDLEVBQUUsS0FBSyxHQUFHLENBQUMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2xDLElBQUksVUFBVSxHQUFXLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDdEMsSUFBSSxHQUFHLEdBQUcsUUFBUSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO1FBRWhELElBQUksS0FBSyxJQUFJLElBQUksSUFBSSxLQUFLLElBQUksRUFBRTtZQUFFLE9BQU8sSUFBSSxDQUFDO1FBQzlDLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsSUFBSSxJQUFJO1lBQzdELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztRQUM3QyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDekUsT0FBTyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN6QixJQUFJLFVBQVUsS0FBSyxJQUFJLEVBQUU7WUFDdkIsS0FBSyxJQUFJLENBQUMsR0FBQyxDQUFDLEVBQUUsQ0FBQyxHQUFHLFVBQVUsQ0FBQyxNQUFNLEdBQUc7Z0JBQ3BDLFFBQVEsVUFBVSxDQUFDLENBQUMsQ0FBQyxFQUFFO29CQUNyQixLQUFLLEdBQUc7d0JBQUU7NEJBQ04sSUFBSSxNQUFjLENBQUM7NEJBQ25CLElBQUksR0FBRyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDOzRCQUNuQyxNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDOzRCQUN4RCxJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUM7Z0NBQ1YsUUFBUSxHQUFHLFFBQVEsQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFDLENBQUMsQ0FBQyxDQUFDOzRCQUNwQyxPQUFNLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxHQUFHLEVBQUUsQ0FBQyxFQUFFO2dDQUFDLENBQUM7NEJBQ2pDLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO3lCQUN2Qjt3QkFDRCxNQUFNO29CQUNWLEtBQUssR0FBRzt3QkFBRTs0QkFDTixJQUFJLE1BQWMsQ0FBQzs0QkFDbkIsSUFBSSxHQUFHLEdBQUcsUUFBUSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLENBQUM7NEJBQ25DLE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7NEJBRXhELElBQUksR0FBRyxHQUFHLENBQUMsQ0FBQztnQ0FDVixRQUFRLEdBQUcsUUFBUSxDQUFDLE1BQU0sQ0FBQyxHQUFHLEdBQUMsQ0FBQyxDQUFDLENBQUM7NEJBRXBDLE9BQU8sVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDLEVBQUU7Z0NBQUMsQ0FBQzs0QkFDbEMsS0FBSyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO3lCQUN0RDt3QkFDRCxNQUFNO29CQUNWLEtBQUssR0FBRzt3QkFBRTs0QkFDTixJQUFJLE1BQU0sQ0FBQzs0QkFDWCxJQUFJLEdBQUcsR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQzs0QkFDbkMsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQzs0QkFDeEQsSUFBSSxHQUFHLEdBQUcsQ0FBQyxDQUFDLEVBQUU7Z0NBQ1osUUFBUSxHQUFHLFFBQVEsQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDOzZCQUNyQzs0QkFDRCxPQUFPLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxHQUFHLEVBQUUsQ0FBQyxFQUFFO2dDQUFDLENBQUM7NEJBQ2xDLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO3lCQUN6Qjt3QkFDRCxNQUFNO29CQUNSO3dCQUNFLENBQUMsRUFBRSxDQUFDO3dCQUNKLE1BQU07aUJBQ1Q7YUFDRjtZQUVELElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDO2dCQUN0QyxPQUFPLElBQUksQ0FBQztZQUNkLE9BQU8sSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztTQUNwQztJQUVMLENBQUM7SUFFRCxNQUFNLENBQUMsSUFBVSxFQUFFLGFBQXFCO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsSUFBSSxJQUFJO1lBQzdELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztRQUM3QyxJQUFJLGFBQWEsS0FBSyxPQUFPLEVBQUU7WUFDN0IsSUFBSSxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUk7Z0JBQ3RCLElBQUksQ0FBQyxPQUFPLEdBQUcsVUFBVSxDQUFDO1lBQzVCLE9BQU8sVUFBVSxDQUFDLElBQUksRUFBQyxJQUFJLENBQUMsT0FBTyxFQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUNsRDthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7U0FDNUI7SUFDSCxDQUFDOzswRUFuRlUsYUFBYSwwRUFLWixlQUFlO3FEQUxoQixhQUFhLFdBQWIsYUFBYTt1RkFBYixhQUFhO2NBRHpCLFVBQVU7O3NCQU1KLE1BQU07dUJBQUMsZUFBZSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7TUFUX0RBVEVfTE9DQUxFLCBOYXRpdmVEYXRlQWRhcHRlcn0gZnJvbSAnQGFuZ3VsYXIvbWF0ZXJpYWwvY29yZSc7XHJcbmltcG9ydCB7IGZvcm1hdERhdGUgfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xyXG5pbXBvcnQgeyBQbGF0Zm9ybSB9IGZyb20gJ0Bhbmd1bGFyL2Nkay9wbGF0Zm9ybSc7XHJcbmltcG9ydCB7VGFza01hZ2ljU2VydmljZX0gZnJvbSBcIi4vdGFzay5tYWdpY3Muc2VydmljZVwiO1xyXG5pbXBvcnQge0luamVjdCwgSW5qZWN0YWJsZX0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuXHJcbmV4cG9ydCBjb25zdCBNR19GT1JNQVRTID0ge1xyXG4gIHBhcnNlOiB7ZGF0ZUlucHV0OiB7bW9udGg6ICdzaG9ydCcsIHllYXI6ICdudW1lcmljJywgZGF5OiAnbnVtZXJpYyd9fSxcclxuICBkaXNwbGF5OiB7XHJcbiAgICBkYXRlSW5wdXQ6ICdpbnB1dCcsXHJcbiAgICBtb250aFllYXJMYWJlbDoge3llYXI6ICdudW1lcmljJywgbW9udGg6ICdzaG9ydCd9LFxyXG4gICAgZGF0ZUExMXlMYWJlbDoge3llYXI6ICdudW1lcmljJywgbW9udGg6ICdsb25nJywgZGF5OiAnbnVtZXJpYyd9LFxyXG4gICAgbW9udGhZZWFyQTExeUxhYmVsOiB7eWVhcjogJ251bWVyaWMnLCBtb250aDogJ2xvbmcnfVxyXG4gIH1cclxufTtcclxuXHJcblxyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBNZ0RhdGVBZGFwdGVyIGV4dGVuZHMgTmF0aXZlRGF0ZUFkYXB0ZXIge1xyXG4gIHB1YmxpYyBtZ2R0Zm10OiBzdHJpbmcgPSBudWxsO1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgICBwdWJsaWMgcGxhdGZvcm06IFBsYXRmb3JtLFxyXG4gICAgICBwcm90ZWN0ZWQgdGFzazogVGFza01hZ2ljU2VydmljZSxcclxuICAgICAgQEluamVjdChNQVRfREFURV9MT0NBTEUpIHB1YmxpYyBsb2NhbGVJZDogc3RyaW5nXHJcbiAgKSB7XHJcblxyXG4gICAgICBzdXBlcihsb2NhbGVJZCwgcGxhdGZvcm0pO1xyXG4gICAgICB0aGlzLnNldExvY2FsZShsb2NhbGVJZCk7XHJcbiAgfVxyXG5cclxuICBwYXJzZSAodmFsdWU6IGFueSkgOiBEYXRlIHwgbnVsbFxyXG4gIHtcclxuICAgIGxldCB2YWx1ZVN0cjogc3RyaW5nID0gdmFsdWU7XHJcbiAgICBsZXQgZGF0ZSA9IDAsIG1vbnRoID0gMCwgeWVhciA9IDA7XHJcbiAgICBsZXQgbWdEYXRlTWFzazogc3RyaW5nID0gdGhpcy5tZ2R0Zm10O1xyXG4gICAgbGV0IHNlcCA9IHZhbHVlU3RyLmluZGV4T2YoJy8nKSA+IDAgPyAnLycgOiAnLSc7XHJcblxyXG4gICAgaWYgKHZhbHVlID09IG51bGwgfHwgdmFsdWUgPT0gXCJcIikgcmV0dXJuIG51bGw7XHJcbiAgICBpZiAodGhpcy5tZ2R0Zm10ID09IG51bGwgJiYgdGhpcy50YXNrLm1nSW5wdXREYXRlRm9ybWF0ICE9IG51bGwpXHJcbiAgICAgIHRoaXMubWdkdGZtdCA9IHRoaXMudGFzay5tZ0lucHV0RGF0ZUZvcm1hdDtcclxuICAgIGlmICgodGhpcy5tZ2R0Zm10LmluZGV4T2YoJ01NTScpID4gMCkgfHwgKHRoaXMubWdkdGZtdC5pbmRleE9mKCdNTU1NJykgPiAwKSlcclxuICAgICAgcmV0dXJuIG5ldyBEYXRlKHZhbHVlKTtcclxuICAgIGlmIChtZ0RhdGVNYXNrICE9PSBudWxsKSB7XHJcbiAgICAgIGZvciAobGV0IGk9MDsgaSA8IG1nRGF0ZU1hc2subGVuZ3RoOykge1xyXG4gICAgICAgIHN3aXRjaCAobWdEYXRlTWFza1tpXSkge1xyXG4gICAgICAgICAgY2FzZSAnZCc6IHtcclxuICAgICAgICAgICAgICBsZXQgdG1wU3RyOiBzdHJpbmc7XHJcbiAgICAgICAgICAgICAgbGV0IGxlbiA9IHZhbHVlU3RyLmluZGV4T2Yoc2VwLCAwKTtcclxuICAgICAgICAgICAgICB0bXBTdHIgPSBsZW4gPT0gLTEgPyB2YWx1ZVN0ciA6IHZhbHVlU3RyLnN1YnN0cigwLCBsZW4pO1xyXG4gICAgICAgICAgICAgIGlmIChsZW4gPiAtMSlcclxuICAgICAgICAgICAgICAgIHZhbHVlU3RyID0gdmFsdWVTdHIuc3Vic3RyKGxlbisxKTtcclxuICAgICAgICAgICAgICBmb3IgKDttZ0RhdGVNYXNrW2ldID09ICdkJzsgaSsrKTtcclxuICAgICAgICAgICAgICBkYXRlID0gKE51bWJlcikodG1wU3RyKTtcclxuICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgICBjYXNlICdNJzoge1xyXG4gICAgICAgICAgICAgIGxldCB0bXBTdHI6IHN0cmluZztcclxuICAgICAgICAgICAgICBsZXQgbGVuID0gdmFsdWVTdHIuaW5kZXhPZihzZXAsIDApO1xyXG4gICAgICAgICAgICAgIHRtcFN0ciA9IGxlbiA9PSAtMSA/IHZhbHVlU3RyIDogdmFsdWVTdHIuc3Vic3RyKDAsIGxlbik7XHJcblxyXG4gICAgICAgICAgICAgIGlmIChsZW4gPiAtMSlcclxuICAgICAgICAgICAgICAgIHZhbHVlU3RyID0gdmFsdWVTdHIuc3Vic3RyKGxlbisxKTtcclxuXHJcbiAgICAgICAgICAgICAgZm9yICg7IG1nRGF0ZU1hc2tbaV0gPT0gJ00nIDtpKyspO1xyXG4gICAgICAgICAgICAgIG1vbnRoID0gKE51bWJlcikodG1wU3RyKSA+IDAgPyAoTnVtYmVyKSh0bXBTdHIpLSAxIDogMDtcclxuICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgICBjYXNlICd5Jzoge1xyXG4gICAgICAgICAgICAgIGxldCB0bXBTdHI7XHJcbiAgICAgICAgICAgICAgbGV0IGxlbiA9IHZhbHVlU3RyLmluZGV4T2Yoc2VwLCAwKTtcclxuICAgICAgICAgICAgICB0bXBTdHIgPSBsZW4gPT0gLTEgPyB2YWx1ZVN0ciA6IHZhbHVlU3RyLnN1YnN0cigwLCBsZW4pO1xyXG4gICAgICAgICAgICAgIGlmIChsZW4gPiAtMSkge1xyXG4gICAgICAgICAgICAgICAgdmFsdWVTdHIgPSB2YWx1ZVN0ci5zdWJzdHIobGVuICsgMSk7XHJcbiAgICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICAgIGZvciAoOyBtZ0RhdGVNYXNrW2ldID09ICd5JyA7aSsrKTtcclxuICAgICAgICAgICAgICB5ZWFyID0gKE51bWJlcikodG1wU3RyKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgICAgIGkrKztcclxuICAgICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcblxyXG4gICAgICBpZiAobW9udGggPT0gMCAmJiB5ZWFyID09IDAgJiYgZGF0ZSA9PSAwKVxyXG4gICAgICAgIHJldHVybiBudWxsO1xyXG4gICAgICByZXR1cm4gbmV3IERhdGUoeWVhciwgbW9udGgsIGRhdGUpO1xyXG4gICAgfVxyXG5cclxufVxyXG5cclxuZm9ybWF0KGRhdGU6IERhdGUsIGRpc3BsYXlGb3JtYXQ6IE9iamVjdCk6IHN0cmluZyB7XHJcbiAgICBpZiAodGhpcy5tZ2R0Zm10ID09IG51bGwgJiYgdGhpcy50YXNrLm1nSW5wdXREYXRlRm9ybWF0ICE9IG51bGwpXHJcbiAgICAgIHRoaXMubWdkdGZtdCA9IHRoaXMudGFzay5tZ0lucHV0RGF0ZUZvcm1hdDtcclxuICAgIGlmIChkaXNwbGF5Rm9ybWF0ID09PSAnaW5wdXQnKSB7XHJcbiAgICAgIGlmICh0aGlzLm1nZHRmbXQgPT0gbnVsbClcclxuICAgICAgICB0aGlzLm1nZHRmbXQgPSAnTS9kL3l5eXknOyAvL2RlZmF1bHQgZm9ybWF0XHJcbiAgICAgIHJldHVybiBmb3JtYXREYXRlKGRhdGUsdGhpcy5tZ2R0Zm10LHRoaXMubG9jYWxlKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHJldHVybiBkYXRlLnRvRGF0ZVN0cmluZygpO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG5cclxuIl19