import { Compiler, Injectable, Injector } from '@angular/core';
import { TaskMagicService } from './task.magics.service';
import { List, isNullOrUndefined } from '@magic-xpa/mscorelib';
import { ComponentListMagicService } from './component-list.magic.service';
import { ActivatedRoute, Router } from '@angular/router';
import { CommandsCollectorMagicService } from './commands-collector.magic.service';
import { RouterCommandsMagicService } from '../services/router-commands.magic.service';
import { MagicLazyLoaderService } from './magic.lazy.loader.service';
import * as i0 from "@angular/core";
import * as i1 from "./task.magics.service";
import * as i2 from "@angular/router";
import * as i3 from "./component-list.magic.service";
import * as i4 from "./commands-collector.magic.service";
import * as i5 from "../services/router-commands.magic.service";
import * as i6 from "./magic.lazy.loader.service";
export class SubformMagicService {
    constructor(task, activatedRoute, componentList, pendingCommandsCollector, router, routerCommandsMagicService, componentListMagicService, loader, injector, compiler) {
        this.task = task;
        this.activatedRoute = activatedRoute;
        this.componentList = componentList;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.router = router;
        this.routerCommandsMagicService = routerCommandsMagicService;
        this.componentListMagicService = componentListMagicService;
        this.loader = loader;
        this.injector = injector;
        this.compiler = compiler;
        this.subformsDict = {};
        this.routesDict = {};
        this.currentRouteDefinition = null;
    }
    mgGetComp(subformName) {
        if (subformName in this.subformsDict) {
            let formName = this.subformsDict[subformName].formName;
            if (formName)
                return this.componentList.getComponent(formName);
        }
        return null;
    }
    mgGetParameters(subformName) {
        if (subformName in this.subformsDict) {
            return this.subformsDict[subformName].parameters;
        }
        else
            return '';
    }
    deleteSubformComp(subformControlName, formName) {
        if (Object.keys(this.subformsDict).indexOf(subformControlName) >= 0) {
            if (this.subformsDict[subformControlName].formName === formName) {
                this.subformsDict[subformControlName] = {};
                this.task.refreshView();
            }
        }
    }
    addSubformComp(subformControlName, formName, taskId, taskDescription, routerPath, params, inDefaultOutlet) {
        this.pendingCommandsCollector.startCollecting();
        let refreshNeeded = false;
        if (isNullOrUndefined(routerPath)) {
            if (Object.keys(this.subformsDict).indexOf(subformControlName) >= 0) {
                if (this.subformsDict[subformControlName].formName === formName) {
                    this.subformsDict[subformControlName] = {};
                    this.task.refreshView();
                }
            }
            let moduleRef = this.componentListMagicService.getModuleRef(formName);
            if (moduleRef == null) {
                let lazyLoadModule = this.componentListMagicService.getLazyLoadModuleData(formName);
                if (lazyLoadModule != null) {
                    let moduleName = lazyLoadModule.moduleName.replace('Magic', '');
                    moduleName = moduleName.replace('Module', '');
                    this.loader.Load(moduleName).then(m => {
                        const compiled = this.compiler.compileModuleAndAllComponentsSync(m[lazyLoadModule.moduleName]);
                        moduleRef = compiled.ngModuleFactory.create(this.injector);
                        this.subformsDict[subformControlName] = {
                            formName,
                            parameters: { taskIdParam: taskId, taskDescription: taskDescription }
                        };
                        this.task.refreshView();
                    });
                }
            }
            else {
                this.subformsDict[subformControlName] = {
                    formName,
                    parameters: { taskIdParam: taskId, taskDescription: taskDescription }
                };
                refreshNeeded = true;
            }
        }
        else {
            if (inDefaultOutlet)
                subformControlName = 'primary';
            let routeParams = new List();
            routeParams.push(routerPath);
            if (params !== null) {
                routeParams = routeParams.concat(params);
            }
            let routeCommand = {
                callerMgSubformServiceRef: this,
                routerOutletName: subformControlName,
                formName: formName,
                parameters: { taskIdParam: taskId, taskDescription: taskDescription },
                routeParams: routeParams
            };
            if (SubformMagicService.currentCallerMgSubformServiceRef === null)
                this.ExecuteRouteCommand(routeCommand);
            else
                this.routerCommandsMagicService.AddRouteCommand(routeCommand);
        }
        if (refreshNeeded)
            this.task.refreshView();
    }
    ExecuteRouteCommand(routeCommand) {
        let currentSubformMagicService = routeCommand.callerMgSubformServiceRef;
        let relativeRoute = SubformMagicService.getRelativeRoute(currentSubformMagicService.activatedRoute);
        if (currentSubformMagicService.routesDict[routeCommand.routerOutletName] === routeCommand.routeParams[0]) {
            currentSubformMagicService.router.navigate([{ outlets: { [routeCommand.routerOutletName]: null } }], { relativeTo: relativeRoute })
                .then((result) => {
                SubformMagicService.currentCallerMgSubformServiceRef = currentSubformMagicService;
                currentSubformMagicService.currentRouteDefinition = {
                    formName: routeCommand.formName,
                    parameters: routeCommand.parameters
                };
                currentSubformMagicService.PerformRouterNavigate(routeCommand.routerOutletName, routeCommand.routeParams);
            });
        }
        else {
            SubformMagicService.currentCallerMgSubformServiceRef = currentSubformMagicService;
            currentSubformMagicService.currentRouteDefinition = {
                formName: routeCommand.formName,
                parameters: routeCommand.parameters
            };
            if (SubformMagicService.routerContainers.length > 0) {
                let routeContainer = SubformMagicService.routerContainers[0];
                SubformMagicService.routerContainers.shift();
                routeContainer.initializeComponent();
            }
            else {
                currentSubformMagicService.PerformRouterNavigate(routeCommand.routerOutletName, routeCommand.routeParams);
            }
        }
    }
    PerformRouterNavigate(routerOutletName, routeParams) {
        let relativeRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
        this.router.navigate([{ outlets: { [routerOutletName]: routeParams } }], { relativeTo: relativeRoute })
            .then((result) => {
            if (result !== null && !result) {
                let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
                subformMagicService.currentRouteDefinition = null;
                SubformMagicService.currentCallerMgSubformServiceRef = null;
                subformMagicService.pendingCommandsCollector.stopCollecting();
                subformMagicService.routerCommandsMagicService.ExecuteNextCommand();
            }
        });
    }
    init() {
        const pendingCommands = this.pendingCommandsCollector.GetCommands(this.task.taskId);
        if (pendingCommands.length > 0) {
            pendingCommands.forEach(command => { this.task.executeCommand(command); });
            this.task.refreshView();
        }
        this.pendingCommandsCollector.stopCollecting();
    }
    refreshView() {
        this.task.refreshView();
    }
    static getRelativeRoute(sendActivatedRoute) {
        let currentActiveRoute = sendActivatedRoute;
        if (currentActiveRoute.snapshot.routeConfig !== null && currentActiveRoute.snapshot.routeConfig.path === '') {
            currentActiveRoute = currentActiveRoute.parent;
            if (!currentActiveRoute.snapshot.routeConfig.loadChildren)
                console.log('getRelativeRoute(): both path and currentActiveRoute.snapshot.routeConfig.loadChildren are empty.');
        }
        return currentActiveRoute;
    }
}
SubformMagicService.currentCallerMgSubformServiceRef = null;
SubformMagicService.routerContainers = new Array();
SubformMagicService.ɵfac = function SubformMagicService_Factory(t) { return new (t || SubformMagicService)(i0.ɵɵinject(i1.TaskMagicService), i0.ɵɵinject(i2.ActivatedRoute), i0.ɵɵinject(i3.ComponentListMagicService), i0.ɵɵinject(i4.CommandsCollectorMagicService), i0.ɵɵinject(i2.Router), i0.ɵɵinject(i5.RouterCommandsMagicService), i0.ɵɵinject(i3.ComponentListMagicService), i0.ɵɵinject(i6.MagicLazyLoaderService), i0.ɵɵinject(i0.Injector), i0.ɵɵinject(i0.Compiler)); };
SubformMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: SubformMagicService, factory: SubformMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SubformMagicService, [{
        type: Injectable
    }], function () { return [{ type: i1.TaskMagicService }, { type: i2.ActivatedRoute }, { type: i3.ComponentListMagicService }, { type: i4.CommandsCollectorMagicService }, { type: i2.Router }, { type: i5.RouterCommandsMagicService }, { type: i3.ComponentListMagicService }, { type: i6.MagicLazyLoaderService }, { type: i0.Injector }, { type: i0.Compiler }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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