import { InteractiveCommandType } from '@magic-xpa/gui';
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
import { RouterContainerMagicComponent } from "./router-container.magic.component";
export class GuiInteractiveExecutor {
    Run() {
        try {
            switch (this.command._commandType) {
                case InteractiveCommandType.GET_VALUE:
                    this.onValue();
                    break;
                case InteractiveCommandType.GET_ROWS_IN_PAGE:
                    this.onGetRowsInPage();
                    break;
                case InteractiveCommandType.GET_MAX_ROWS_IN_PAGINATED_TABLE:
                    this.onGetMaxRowsInPaginatedTable();
                    break;
                case InteractiveCommandType.MESSAGE_BOX:
                    this.OnMessageBox();
                    break;
                case InteractiveCommandType.GET_TOP_INDEX:
                    this.OnGetTopIndex();
                    break;
                case InteractiveCommandType.GET_IS_ROW_EDITING:
                    this.OnGetIsRowEditing();
                    break;
                case InteractiveCommandType.SET_TITLE:
                    this.OnSetTitle();
                    break;
                case InteractiveCommandType.REFRESH_PAGE:
                    this.OnRefreshPage();
                    break;
                case InteractiveCommandType.GET_LAST_ROUTE:
                    this.OnGetLastRoute();
                    break;
            }
        }
        catch (ex) {
            throw ex;
        }
    }
    static executeInteractiveCommand(task, guiIntactiveCommand, overlayService) {
        let executor = new GuiInteractiveExecutor();
        executor.task = task;
        executor.command = guiIntactiveCommand;
        executor.overlayService = overlayService;
        executor.Run();
    }
    onValue() {
        let guiRowId = this.task.getGuiRowId(+this.command._line, this.task.isTableControl(this.command.controlName) || this.command._obj2.IsTableChild);
        let result = this.task.getFormControl(guiRowId.toString(), this.command.controlName);
        let val;
        if (!isNullOrUndefined(result)) {
            val = result.value;
        }
        else if (this.task.isTableControl(this.command.controlName))
            val = this.task.getValue(this.command.controlName, guiRowId.toString());
        val = this.task.ConvertValToNative(this.command.controlName, guiRowId, val);
        this.command._mgValue.obj = val;
    }
    onGetRowsInPage() {
        this.command._intVal1 = this.task.tableService.getPageSize();
        if (this.task.oldPageSize == 0)
            this.task.oldPageSize = this.command._intVal1;
    }
    onGetMaxRowsInPaginatedTable() {
        this.command._intVal1 = this.task.tableService.getMaxRowsInTable();
    }
    OnMessageBox() {
        this.overlayService.openConfirmationBox(this.command._mgValue.title, this.command._mgValue.str, this.command._mgValue.style);
    }
    OnSetTitle() {
        this.task.setTitle(this.command._mgValue.title);
    }
    OnRefreshPage() {
        let navigateToRootRoute = this.command._boolVal;
        let initialUrl = this.command._obj1;
        if (navigateToRootRoute)
            window.location.replace(initialUrl);
        else
            window.location.reload();
    }
    OnGetTopIndex() {
        this.command._intVal1 = this.task.tableService.getTableTopIndex();
    }
    OnGetIsRowEditing() {
        let dvRowIndex = this.command._intVal1;
        let guiRowIndex = this.task.getGuiRowId(dvRowIndex, true);
        let isLineMode = this.command._boolVal;
        if (isLineMode && (isNullOrUndefined(guiRowIndex) || isNullOrUndefined(this.task.Records.list[guiRowIndex])))
            this.command._boolVal = false;
        else
            this.command._boolVal = this.task.Records.list[guiRowIndex].isEditing;
    }
    OnGetLastRoute() {
        this.command.resultString = RouterContainerMagicComponent.LastRoute;
    }
}
//# sourceMappingURL=data:application/json;base64,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