import { Directive, ElementRef, Input, Optional, Renderer2, ViewContainerRef } from "@angular/core";
import { isNullOrUndefined } from "@magic-xpa/mscorelib";
import { CommandType, GuiConstants, HtmlProperties, InteractiveCommandType, Modifiers } from "@magic-xpa/gui";
import { getGuiEventObj } from "@magic-xpa/engine";
import { TaskBaseMagicComponent } from "../task-base.magic.component";
import { TaskMagicService } from "../../services/task.magics.service";
import { debounceTime, filter, map } from "rxjs/operators";
import { RowMagicDirective } from "./magic/row.magic.directive";
import { fromEvent } from "rxjs";
import { BindingLevel, MgControlType, StorageAttributeType } from "@magic-xpa/utils";
import * as i0 from "@angular/core";
import * as i1 from "../../services/task.magics.service";
import * as i2 from "./magic/row.magic.directive";
export class MagicDirective {
    set magic(val) {
        this.id = val;
        this.selector = "magic";
    }
    ;
    set eventsOnly(val) {
        console.log("eventsOnly");
        this.eventsOnlyVal = true;
    }
    ;
    constructor(_task, element, renderer, vcRef, magicRow) {
        this._task = _task;
        this.element = element;
        this.renderer = renderer;
        this.vcRef = vcRef;
        this.magicRow = magicRow;
        this.eventHandlers = {};
        this.eventsOnlyVal = false;
        this.htmlElement = this.element.nativeElement;
        if (!(typeof magicRow === "undefined" || magicRow === null))
            this.rowId = magicRow.rowId;
    }
    get task() {
        return this._task;
    }
    regEvents() {
        this.eventHandlers["focusin"] = this.OnFocus.bind(this);
        Object.keys(this.eventHandlers).forEach((key) => {
            this.focusUnlistener = this.renderer.listen(this.htmlElement, key, this.eventHandlers[key]);
        });
        let events = ["click", "mousedown", "dblclick"];
        events.forEach(event => {
            this.renderer.listen(this.htmlElement, event, (e) => {
                let fromButton = false;
                if (this.htmlElement instanceof HTMLButtonElement)
                    fromButton = true;
                this.task.insertEvent(getGuiEventObj(event, this.id, +this.rowId, fromButton));
                if (MagicDirective.noOfAutoCompleteBoxesOpened < 1)
                    e.cancelBubble = true;
            });
        });
        this.renderer.listen(this.htmlElement, "change", (e) => {
            let guiEvent = getGuiEventObj("selectionchanged", this.id, +this.rowId);
            if ((event.target).selectedIndex !== undefined) {
                guiEvent.Value = (event.target).selectedIndex.toString();
                e.cancelBubble = true;
                this.task.insertEvent(guiEvent);
            }
        });
        fromEvent(this.htmlElement, "input").pipe(map((event) => {
            return event.target.value;
        }), debounceTime(200)).subscribe((x) => {
            if (this.task.getProperty(this.id, HtmlProperties.BindingLevel, this.rowId) === BindingLevel.Character) {
                let attribute = this.task.Records.list[0].getControlMetadata(this.id).dataType;
                if (attribute !== StorageAttributeType.Date && attribute != StorageAttributeType.Time)
                    this.task.mgAccessorService.setValueToControl(this.id, x, true);
            }
        });
        this.renderer.listen(this.htmlElement, "keydown", (e) => {
            let guiEvent = getGuiEventObj("keydown", this.id, +this.rowId);
            guiEvent.modifiers = Modifiers.MODIFIER_NONE;
            if (e.altKey && e.keyCode !== GuiConstants.KEY_ALT)
                guiEvent.modifiers = Modifiers.MODIFIER_ALT;
            else if (e.ctrlKey && e.keyCode !== GuiConstants.KEY_CTRL)
                guiEvent.modifiers = Modifiers.MODIFIER_CTRL;
            let supportedKey = e.keyCode === GuiConstants.KEY_PG_UP ||
                e.keyCode === GuiConstants.KEY_PG_DOWN ||
                e.keyCode === GuiConstants.KEY_LEFT ||
                e.keyCode === GuiConstants.KEY_RIGHT ||
                e.keyCode === GuiConstants.KEY_UP ||
                e.keyCode === GuiConstants.KEY_DOWN ||
                e.keyCode === GuiConstants.KEY_ESC ||
                e.keyCode === GuiConstants.KEY_HOME ||
                e.keyCode === GuiConstants.KEY_END ||
                e.keyCode === GuiConstants.KEY_RETURN ||
                (e.keyCode >= GuiConstants.KEY_F1 && e.keyCode <= GuiConstants.KEY_F12);
            if (guiEvent.modifiers !== Modifiers.MODIFIER_NONE || supportedKey) {
                guiEvent.keyCode = e.keyCode;
                if (e.keyCode !== GuiConstants.KEY_ESC || e.keyCode === GuiConstants.KEY_ESC && (!MagicDirective.opened && MagicDirective.noOfAutoCompleteBoxesOpened < 1))
                    e.cancelBubble = true;
                this.task.insertEvent(guiEvent);
            }
        });
    }
    OnFocus() {
        this.task.insertEvent(getGuiEventObj("focus", this.id, +this.rowId));
        event.cancelBubble = true;
    }
    IsSameElement(command) {
        let line = command.line;
        if (this.task.isTableControl(command.CtrlName))
            line = this.task.getGuiRowId(line, true);
        return (command.CtrlName === this.id &&
            (line === +this.rowId ||
                (line === 0 && isNullOrUndefined(this.rowId))));
    }
    IsSameComponent(command) {
        return (command.controlName === this.id);
    }
    regUpdatesUI() {
        this.subscribeRefreshDom = this.task
            .refreshDom.pipe(filter(c => this.IsSameElement(c)))
            .subscribe(a => {
            let command = a;
            if (isNullOrUndefined(this.rowId))
                this.rowId = "0";
            try {
                if (!this.eventsOnlyVal)
                    this.handleCommand(command);
            }
            catch (ex) {
                console.dir(ex);
            }
        });
        this.subscribeInteractiveCommands = this.task.interactiveCommands
            .pipe(filter(c => this.IsSameComponent(c)))
            .subscribe(command => {
            this.handleInteractiveCommands(command);
        });
    }
    ngOnInit() {
        this.regEvents();
        this.regUpdatesUI();
    }
    handleCommand(command) {
        switch (command.CommandType) {
            case CommandType.SET_PROPERTY:
                this.handleSetProperty(command);
                break;
            case CommandType.SET_FOCUS:
                this.focusUnlistener();
                if (!(command.obj.ConnectedControl && this.htmlElement instanceof HTMLButtonElement))
                    this.htmlElement.focus();
                this.focusUnlistener = this.renderer.listen(this.htmlElement, "focusin", this.eventHandlers["focusin"]);
                break;
        }
    }
    handleInteractiveCommands(command) {
        switch (command._commandType) {
            case InteractiveCommandType.CALL_JS:
                let methodName = command._str;
                let args = command.arguments;
                let magicComponent = (this.vcRef._hostLView).find(v => v instanceof TaskBaseMagicComponent);
                let resultString = "";
                try {
                    if (!isNullOrUndefined(magicComponent[methodName])) {
                        resultString = magicComponent[methodName].apply(magicComponent, args);
                    }
                    else
                        console.error("Instance method " + methodName + " does not exists");
                }
                catch (e) {
                    console.error(e.message);
                }
                command.resultString = resultString;
                break;
        }
    }
    handleSetProperty(command) {
        switch (command.Operation) {
            case HtmlProperties.ReadOnly:
                {
                    if (command.obj.Type == MgControlType.CTRL_TYPE_TEXT)
                        if (command.obj1 != true)
                            this.renderer.removeAttribute(this.htmlElement, command.Operation);
                        else
                            this.renderer.setAttribute(this.htmlElement, command.Operation, command.str);
                }
                break;
        }
    }
    ngOnDestroy() {
        this.subscribeRefreshDom.unsubscribe();
    }
}
MagicDirective.opened = false;
MagicDirective.noOfAutoCompleteBoxesOpened = 0;
MagicDirective.ɵfac = function MagicDirective_Factory(t) { return new (t || MagicDirective)(i0.ɵɵdirectiveInject(i1.TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(i2.RowMagicDirective, 8)); };
MagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: MagicDirective, selectors: [["", "magic", ""]], inputs: { magic: "magic", eventsOnly: "eventsOnly", rowId: "rowId" } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicDirective, [{
        type: Directive,
        args: [{
                selector: "[magic]"
            }]
    }], function () { return [{ type: i1.TaskMagicService }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.ViewContainerRef }, { type: i2.RowMagicDirective, decorators: [{
                type: Optional
            }] }]; }, { magic: [{
            type: Input,
            args: ["magic"]
        }], eventsOnly: [{
            type: Input,
            args: ["eventsOnly"]
        }], rowId: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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