import { Directive, HostListener } from '@angular/core';
import { MagicDirective } from '../magic.directive';
import { HtmlProperties } from "@magic-xpa/gui";
import { filter } from "rxjs/operators";
import * as i0 from "@angular/core";
import * as i1 from "../magic.directive";
export class ComboboxMagicDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
        this.magicDirective.task.refreshDom.pipe(filter(c => this.magicDirective.IsSameElement(c))).subscribe(value => {
            let command = value;
            if (command.Operation === HtmlProperties.ItemsList)
                this.onComboboxItemsListChanged();
        });
    }
    onChange($event) {
        this.magicDirective.task.onComboboxSelectionChanged($event, this.magicDirective.id, +this.magicDirective.rowId);
    }
    onComboboxItemsListChanged() {
        this.magicDirective.task.refreshView();
    }
}
ComboboxMagicDirective.ɵfac = function ComboboxMagicDirective_Factory(t) { return new (t || ComboboxMagicDirective)(i0.ɵɵdirectiveInject(i1.MagicDirective)); };
ComboboxMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: ComboboxMagicDirective, selectors: [["select", "magic", "", 3, "multiple", ""]], hostBindings: function ComboboxMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function ComboboxMagicDirective_change_HostBindingHandler($event) { return ctx.onChange($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ComboboxMagicDirective, [{
        type: Directive,
        args: [{
                selector: `select[magic]:not([multiple])`,
            }]
    }], function () { return [{ type: i1.MagicDirective }]; }, { onChange: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tYm9ib3gubWFnaWMuZGlyZWN0aXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvYW5ndWxhci9zcmMvdWkvZGlyZWN0aXZlcy9tYWdpYy9jb21ib2JveC5tYWdpYy5kaXJlY3RpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDeEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLG9CQUFvQixDQUFDO0FBQ3BELE9BQU8sRUFBYyxjQUFjLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUM1RCxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7OztBQVV4QyxNQUFNLE9BQU8sc0JBQXNCO0lBRWpDLFlBQXNCLGNBQThCO1FBQTlCLG1CQUFjLEdBQWQsY0FBYyxDQUFnQjtRQUlsRCxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDNUcsSUFBSSxPQUFPLEdBQWUsS0FBSyxDQUFDO1lBQ2hDLElBQUksT0FBTyxDQUFDLFNBQVMsS0FBSyxjQUFjLENBQUMsU0FBUztnQkFDaEQsSUFBSSxDQUFDLDBCQUEwQixFQUFFLENBQUM7UUFDdEMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBTUQsUUFBUSxDQUFDLE1BQU07UUFDYixJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ2xILENBQUM7SUFLRCwwQkFBMEI7UUFDeEIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDekMsQ0FBQzs7NEZBMUJVLHNCQUFzQjsyREFBdEIsc0JBQXNCOzJHQUF0QixvQkFBZ0I7O3VGQUFoQixzQkFBc0I7Y0FKbEMsU0FBUztlQUFDO2dCQUNULFFBQVEsRUFDTiwrQkFBK0I7YUFDakM7aUVBa0JBLFFBQVE7a0JBRFAsWUFBWTttQkFBQyxRQUFRLEVBQUUsQ0FBQyxRQUFRLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaXJlY3RpdmUsIEhvc3RMaXN0ZW5lciB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBNYWdpY0RpcmVjdGl2ZSB9IGZyb20gJy4uL21hZ2ljLmRpcmVjdGl2ZSc7XHJcbmltcG9ydCB7IEd1aUNvbW1hbmQsIEh0bWxQcm9wZXJ0aWVzIH0gZnJvbSBcIkBtYWdpYy14cGEvZ3VpXCI7XHJcbmltcG9ydCB7IGZpbHRlciB9IGZyb20gXCJyeGpzL29wZXJhdG9yc1wiO1xyXG5cclxuXHJcbi8qKlxyXG4gKiBEaXJlY3RpdmUgZm9yIGNvbWJvYm94ZXMsIHRvIGhhbmRsZSB0aGUgJ2NoYW5nZScgZXZlbnRcclxuICovXHJcbkBEaXJlY3RpdmUoe1xyXG4gIHNlbGVjdG9yOlxyXG4gICAgYHNlbGVjdFttYWdpY106bm90KFttdWx0aXBsZV0pYCxcclxuIH0pXHJcbmV4cG9ydCBjbGFzcyBDb21ib2JveE1hZ2ljRGlyZWN0aXZle1xyXG5cclxuICBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgbWFnaWNEaXJlY3RpdmU6IE1hZ2ljRGlyZWN0aXZlKSB7XHJcbiAgICAvLyBzdWJjcmliZSB0byByZWZyZXNoRG9tLiBUaGlzIGlzIGEgc3BlY2lhbCBjYXNlIGZvciBuYXRpdmUgc2VsZWN0IEhUTUwgY29udHJvbC5cclxuICAgIC8vIHRvIHJlZnJlc2ggdGhlIHNlbGVjdGVkIHByb3BlcnR5LiBFbHNlIGJ5IGRlZmF1bHQsIEhUTUwgZWxlbWVudCBkb2Vzbid0IGdldCByZWZyZXNoZWQgYXMgcGVyXHJcbiAgICAvLyBzZWxlY3RlZCB2YWx1ZSBhbmQgMXN0IGVsZW1lbnQgcmVtYWlucyBzZWxlY3RlZC5cclxuICAgIHRoaXMubWFnaWNEaXJlY3RpdmUudGFzay5yZWZyZXNoRG9tLnBpcGUoZmlsdGVyKGMgPT4gdGhpcy5tYWdpY0RpcmVjdGl2ZS5Jc1NhbWVFbGVtZW50KGMpKSkuc3Vic2NyaWJlKHZhbHVlID0+e1xyXG4gICAgICBsZXQgY29tbWFuZDogR3VpQ29tbWFuZCA9IHZhbHVlO1xyXG4gICAgICBpZiAoY29tbWFuZC5PcGVyYXRpb24gPT09IEh0bWxQcm9wZXJ0aWVzLkl0ZW1zTGlzdClcclxuICAgICAgICB0aGlzLm9uQ29tYm9ib3hJdGVtc0xpc3RDaGFuZ2VkKCk7XHJcbiAgICB9KTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEhhbmRsZXMgdGhlIENvbWJvYm94ICdjaGFuZ2UnIGV2ZW50IC0gcGFzcyBpdCB0byB0aGUgTWFnaWMgZW5naW5lXHJcbiAgICovXHJcbiAgQEhvc3RMaXN0ZW5lcignY2hhbmdlJywgWyckZXZlbnQnXSlcclxuICBvbkNoYW5nZSgkZXZlbnQpIHtcclxuICAgIHRoaXMubWFnaWNEaXJlY3RpdmUudGFzay5vbkNvbWJvYm94U2VsZWN0aW9uQ2hhbmdlZCgkZXZlbnQsIHRoaXMubWFnaWNEaXJlY3RpdmUuaWQsICt0aGlzLm1hZ2ljRGlyZWN0aXZlLnJvd0lkKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFRvIHJlZnJlc2ggQ29tYm9ib3ggc2VsZWN0aW9uIGFzIHBlciBzZWxlY3RlZCBwcm9wZXJ0eS5cclxuICAgKi9cclxuICBvbkNvbWJvYm94SXRlbXNMaXN0Q2hhbmdlZCgpOiB2b2lkIHtcclxuICAgIHRoaXMubWFnaWNEaXJlY3RpdmUudGFzay5yZWZyZXNoVmlldygpO1xyXG4gIH1cclxufVxyXG5cclxuXHJcbiJdfQ==