import { Directive, ElementRef, forwardRef, HostListener, Renderer2 } from "@angular/core";
import { NG_VALUE_ACCESSOR } from "@angular/forms";
import * as i0 from "@angular/core";
export const DATE_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => DateValueAccessor),
    multi: true
};
export class DateValueAccessor {
    constructor(renderer, elementRef) {
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    writeValue(value) {
        if (!value) {
            this.renderer.setProperty(this.elementRef.nativeElement, "value", null);
            return;
        }
        this.renderer.setProperty(this.elementRef.nativeElement, "valueAsDate", new Date(Date.UTC(value.getFullYear(), value.getMonth(), value.getDate())));
    }
    registerOnChange(fn) {
        this.onChange = v => fn(v instanceof Date
            ? new Date(v.getUTCFullYear(), v.getUTCMonth(), v.getUTCDate())
            : v);
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.renderer.setProperty(this.elementRef.nativeElement, "disabled", isDisabled);
    }
}
DateValueAccessor.ɵfac = function DateValueAccessor_Factory(t) { return new (t || DateValueAccessor)(i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ElementRef)); };
DateValueAccessor.ɵdir = i0.ɵɵdefineDirective({ type: DateValueAccessor, selectors: [["", "dateInput", ""]], hostBindings: function DateValueAccessor_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("input", function DateValueAccessor_input_HostBindingHandler($event) { return ctx.onChange($event.target.valueAsDate); })("blur", function DateValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
    } }, features: [i0.ɵɵProvidersFeature([DATE_VALUE_ACCESSOR])] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateValueAccessor, [{
        type: Directive,
        args: [{
                selector: "[dateInput]",
                providers: [DATE_VALUE_ACCESSOR]
            }]
    }], function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, { onChange: [{
            type: HostListener,
            args: ["input", ["$event.target.valueAsDate"]]
        }], onTouched: [{
            type: HostListener,
            args: ["blur", []]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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