import { Directive, ElementRef, Input, Renderer2, ViewContainerRef, Optional } from '@angular/core';
import { CommandType } from "@magic-xpa/gui";
import { getGuiEventObj } from "@magic-xpa/engine";
import { HtmlProperties } from "@magic-xpa/gui";
import { MagicDirective } from "../magic.directive";
import { TaskMagicService } from "../../../services/task.magics.service";
import { StylesMapManager } from "../../../services/StylesMapManager";
import { RowMagicDirective } from "./row.magic.directive";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/task.magics.service";
import * as i2 from "./row.magic.directive";
export class NoControlMagicDirective extends MagicDirective {
    set magic(val) { this.id = val; this.selector = 'magicnc'; }
    ;
    constructor(_task, element, renderer, vcRef, magicRow) {
        super(_task, element, renderer, vcRef, magicRow);
    }
    regEvents() {
        super.regEvents();
        if (this.htmlElement instanceof HTMLSelectElement) {
            this.htmlElement.addEventListener('change', (e) => {
                let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
                guiEvent.Value = (event.target).selectedIndex.toString();
                this.task.insertEvent(guiEvent);
            });
        }
        if (this.isRadio()) {
            this.htmlElement.addEventListener('change', (e) => {
                let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
                guiEvent.Value = (e.target).value;
                this.task.insertEvent(guiEvent);
            });
        }
        if (this.isTabControl()) {
            const tabControl = this.htmlElement.children[0];
            let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
            for (var i = 0; i < tabControl.children.length; i++) {
                tabControl.children[i].addEventListener('click', (e) => {
                    guiEvent.Value = (e.currentTarget.getAttribute('layer') - 1).toString();
                    this.task.insertEvent(guiEvent);
                });
            }
        }
    }
    isTabControl() {
        return this.htmlElement instanceof HTMLDivElement &&
            this.htmlElement.children[0].getAttribute('magicMark') === "magicTabControl";
    }
    isRadio() {
        return this.htmlElement instanceof HTMLDivElement &&
            this.htmlElement.children[0].getAttribute('magicMark') === "magicRadio";
    }
    handleCommand(command) {
        super.handleCommand(command);
        switch (command.CommandType) {
            case CommandType.SET_CLASS:
                const controlMetadata = this._task.Records.list[0].getControlMetadata(this.id);
                if (controlMetadata.removedClass != '') {
                    this.htmlElement.classList.remove(controlMetadata.removedClass);
                    controlMetadata.removedClass = '';
                }
                this.htmlElement.classList.add(command.obj1);
                break;
            case CommandType.SET_VALUE:
                if (this.htmlElement instanceof HTMLLabelElement)
                    this.htmlElement.innerText = command.value;
                if (this.htmlElement instanceof HTMLSelectElement)
                    this.htmlElement.value = command.value;
                if (this.htmlElement instanceof HTMLAnchorElement)
                    this.htmlElement.text = command.value;
                if (this.htmlElement instanceof HTMLInputElement) {
                    if (this.htmlElement.type === "checkbox") {
                        this.htmlElement.checked = command.value;
                    }
                    else {
                        this.htmlElement.value = command.value;
                    }
                }
                if (this.htmlElement instanceof HTMLButtonElement) {
                    this.htmlElement.innerHTML = command.value;
                }
                break;
            case CommandType.SET_PROPERTY:
                this.handleSetProperty(command);
                break;
            case CommandType.SET_STYLE:
                let value = StylesMapManager.magicValueGetStyle(command.Operation, command.obj1);
                let attribute = StylesMapManager.MagicPropertyToHtmlAttributeMap.get(command.Operation);
                this.htmlElement.setAttribute("style", attribute + ":" + value);
                break;
        }
    }
    handleSetProperty(command) {
        super.handleSetProperty(command);
        switch (command.Operation) {
            case HtmlProperties.Text:
                if (this.htmlElement instanceof HTMLLabelElement)
                    this.htmlElement.innerText = command.obj1;
                break;
            case HtmlProperties.Image:
                if (this.htmlElement instanceof HTMLImageElement)
                    this.htmlElement.src = command.obj1;
                else
                    this.htmlElement.setAttribute("src", command.obj1);
                break;
            case HtmlProperties.ItemsList:
                if (this.htmlElement instanceof HTMLSelectElement) {
                    var len = this.htmlElement.length;
                    for (var i = len - 1; i >= 0; i--) {
                        this.htmlElement.remove(i);
                    }
                    for (let s of command.obj1) {
                        let elem = document.createElement("option");
                        elem.text = s.displayValue;
                        elem.value = s.index;
                        this.htmlElement.add(elem);
                    }
                }
                else if (this.isTabControl() && this.htmlElement.children.length > 0) {
                    const tabControl = this.htmlElement.children[0];
                    for (var i = 0; i < tabControl.children.length; i++) {
                        if (tabControl.children[i] instanceof HTMLButtonElement) {
                            tabControl.children[i].innerText = command.obj1[i].displayValue;
                        }
                    }
                }
                break;
            case HtmlProperties.Visible:
                this.htmlElement.setAttribute('style', 'visibility:' + (command.obj1 ? 'visible' : 'hidden'));
                break;
            case HtmlProperties.Enabled:
                if (command.obj1 === false)
                    this.htmlElement.setAttribute("disabled", "true");
                else
                    this.htmlElement.removeAttribute("disabled");
                break;
            case HtmlProperties.TabIndex:
                this.htmlElement.setAttribute(command.Operation, command.obj1);
                break;
            case HtmlProperties.SelectedValue:
                if (this.htmlElement instanceof HTMLSelectElement)
                    this.htmlElement.value = command.obj1;
                else if (this.isTabControl() && this.htmlElement.children.length > 0) {
                    const tabControl = this.htmlElement.children[0];
                    for (var i = 0; i < tabControl.children.length; i++) {
                        let child = tabControl.children[i];
                        const layer = child.getAttribute('layer') - 1;
                        if (child instanceof HTMLButtonElement) {
                            if (layer == command.obj1) {
                                child.classList.add('tab_button_active');
                            }
                            else {
                                child.classList.remove('tab_button_active');
                            }
                        }
                        else {
                            let style = (layer == command.obj1) ? 'display: inline' : 'display: none';
                            child.setAttribute('style', style);
                        }
                    }
                }
                break;
            case HtmlProperties.PlaceHolder:
                this.htmlElement.setAttribute("placeholder", command.obj1);
                break;
            case HtmlProperties.Tooltip:
                this.htmlElement.setAttribute("title", command.obj1);
                break;
            case HtmlProperties.Password:
                if (command.obj1 === false)
                    this.htmlElement.setAttribute("type", "text");
                else
                    this.htmlElement.setAttribute("type", "password");
                break;
        }
    }
}
NoControlMagicDirective.ɵfac = function NoControlMagicDirective_Factory(t) { return new (t || NoControlMagicDirective)(i0.ɵɵdirectiveInject(i1.TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(i2.RowMagicDirective, 8)); };
NoControlMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: NoControlMagicDirective, selectors: [["", "magicnc", ""]], inputs: { magic: ["magicnc", "magic"] }, features: [i0.ɵɵInheritDefinitionFeature] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NoControlMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[magicnc]'
            }]
    }], function () { return [{ type: i1.TaskMagicService }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.ViewContainerRef }, { type: i2.RowMagicDirective, decorators: [{
                type: Optional
            }] }]; }, { magic: [{
            type: Input,
            args: ['magicnc']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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