import { Directive, ElementRef, HostListener, Input } from "@angular/core";
import { TaskMagicService } from "../../../services/task.magics.service";
import { getGuiEventObj } from "@magic-xpa/engine";
import { filter } from "rxjs/operators";
import { MagicDirective } from "../../directives/magic.directive";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/task.magics.service";
export class RowMagicDirective {
    constructor(_task, element) {
        this._task = _task;
        this.element = element;
        this.rowChangedSubscriber = null;
        this.htmlElement = this.element.nativeElement;
    }
    ngOnInit() {
        this.rowChangedSubscriber = this._task
            .OnSelectedRowChanged.pipe(filter(rowId => rowId === this.rowId))
            .subscribe(rowId => {
            if (!this.isInView(this.htmlElement))
                this.htmlElement.scrollIntoView();
        });
    }
    isInView(element) {
        const rect = element.getBoundingClientRect();
        const parentRect = element.parentElement.getBoundingClientRect();
        return (rect.top >= parentRect.top &&
            rect.bottom <= parentRect.bottom);
    }
    ngOnDestroy() {
        if (this.rowChangedSubscriber !== null) {
            this.rowChangedSubscriber.unsubscribe();
        }
    }
    onClick($event) {
        if (this.rowId != '') {
            this._task.insertEvent(getGuiEventObj('click', "magicRow", +this.rowId));
            if (MagicDirective.noOfAutoCompleteBoxesOpened < 1)
                event.cancelBubble = true;
        }
    }
}
RowMagicDirective.ɵfac = function RowMagicDirective_Factory(t) { return new (t || RowMagicDirective)(i0.ɵɵdirectiveInject(i1.TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef)); };
RowMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: RowMagicDirective, selectors: [["", "magicRow", ""]], hostBindings: function RowMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("click", function RowMagicDirective_click_HostBindingHandler($event) { return ctx.onClick($event); });
    } }, inputs: { rowId: ["magicRow", "rowId"] } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RowMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[magicRow]'
            }]
    }], function () { return [{ type: i1.TaskMagicService }, { type: i0.ElementRef }]; }, { rowId: [{
            type: Input,
            args: ['magicRow']
        }], onClick: [{
            type: HostListener,
            args: ['click', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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