import { Directive, HostListener } from '@angular/core';
import { TaskMagicService } from '../../services/task.magics.service';
import { StringBuilder, RefParam } from '@magic-xpa/mscorelib';
import { PICInterface, StorageAttribute } from '@magic-xpa/utils';
import { MagicDirective } from './magic.directive';
import { Validators } from '@angular/forms';
import { MgDateFormatter } from '../pipes/date.magic.pipe';
import { isUndefined } from '@magic-xpa/mscorelib';
import * as i0 from "@angular/core";
import * as i1 from "./magic.directive";
import * as i2 from "../../services/task.magics.service";
export class MgformatMagicDirective {
    constructor(magicDir, _task) {
        this.magicDir = magicDir;
        this._task = _task;
        this.datePasteFlag = false;
    }
    ngAfterViewInit() {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        if (control != null && this._task.mgInputDateFormat == null) {
            let pic = this._task.GetControlPictureMask(this.magicDir.id);
            if (pic.getAttr() == StorageAttribute.DATE) {
                this.formatDate(pic);
            }
        }
    }
    onFocusEvent($event) {
        this.calculatePattern();
    }
    onPaste(event) {
        this.datePasteFlag = true;
    }
    onInputEvent(event) {
        let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
        if (attr == StorageAttribute.DATE) {
            if (!this.datePasteFlag)
                this.dateMasking(event);
            this.datePasteFlag = false;
        }
        this.calculatePattern();
    }
    dateMasking(event) {
        const input = event.target;
        let cursorPos = event.target.selectionStart;
        const separator = this._task.mgInputDateFormat.includes('/') ? '/' : '-';
        if (cursorPos >= input.value.length) {
            const value = input.value.replace(/[^a-zA-Z0-9/-]/g, '');
            if (this._task.mgInputDateFormat == "dd/MM/yyyy" || this._task.mgInputDateFormat == "MM/dd/yyyy" || this._task.mgInputDateFormat == "dd-MM-yyyy" || this._task.mgInputDateFormat == "MM-dd-yyyy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 10)
                    input.value = value.slice(0, 10);
            }
            else if (this._task.mgInputDateFormat == "yyyy/MM/dd" || this._task.mgInputDateFormat == "yyyy/dd/MM" || this._task.mgInputDateFormat == "yyyy-MM-dd" || this._task.mgInputDateFormat == "yyyy-dd-MM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '0000' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = '000' + value.slice(0);
                else if (value.length == 3 && value[2] == separator)
                    input.value = '00' + value.slice(0);
                else if (value.length == 4 && value[3] == separator)
                    input.value = '0' + value.slice(0);
                else if (value.length == 5 && value[4] != separator)
                    input.value = value.slice(0, 4) + separator + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 5) + '01' + value.slice(5);
                else if (value.length == 7 && value[6] == separator)
                    input.value = value.slice(0, 5) + '0' + value.slice(5);
                else if (value.length == 8 && value[7] != separator)
                    input.value = value.slice(0, 7) + separator + value.slice(7);
                else if (value.length >= 10)
                    input.value = value.slice(0, 10);
            }
            else if (this._task.mgInputDateFormat == "dd/MM/yy" || this._task.mgInputDateFormat == "yy/MM/dd" || this._task.mgInputDateFormat == "MM/dd/yy" || this._task.mgInputDateFormat == "yy/dd/MM" || this._task.mgInputDateFormat == "dd-MM-yy" || this._task.mgInputDateFormat == "yy-MM-dd" || this._task.mgInputDateFormat == "MM-dd-yy" || this._task.mgInputDateFormat == "yy-dd-MM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 8)
                    input.value = value.slice(0, 8);
            }
            else if (this._task.mgInputDateFormat == "dd/MMM/yy" || this._task.mgInputDateFormat == "dd-MMM-yy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "dd/MMM/yyyy" || this._task.mgInputDateFormat == "dd-MMM-yyyy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
            else if (this._task.mgInputDateFormat == "yy/dd/MMM" || this._task.mgInputDateFormat == "yy-dd-MMM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '00' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "yyyy/dd/MMM" || this._task.mgInputDateFormat == "yyyy-dd-MMM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '0000' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = '000' + value.slice(0);
                else if (value.length == 3 && value[2] == separator)
                    input.value = '00' + value.slice(0);
                else if (value.length == 4 && value[3] == separator)
                    input.value = '0' + value.slice(0);
                else if (value.length == 5 && value[4] != separator)
                    input.value = value.slice(0, 4) + separator + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 5) + '01' + value.slice(5);
                else if (value.length == 7 && value[6] == separator)
                    input.value = value.slice(0, 5) + '0' + value.slice(5);
                else if (value.length == 8 && value[7] != separator)
                    input.value = value.slice(0, 7) + separator + value.slice(7);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
            else if (this._task.mgInputDateFormat == "MMM/dd/yy" || this._task.mgInputDateFormat == "MMM-dd-yy") {
                if (value.length == 4 && value[3] != separator)
                    input.value = value.slice(0, 3) + separator + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 4) + '01' + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 4) + '0' + value.slice(4);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "MMM/dd/yyyy" || this._task.mgInputDateFormat == "MMM-dd-yyyy") {
                if (value.length == 4 && value[3] != separator)
                    input.value = value.slice(0, 3) + separator + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 4) + '01' + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 4) + '0' + value.slice(4);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
        }
        if (cursorPos < input.value.length && input.value.length > this._task.mgInputDateFormat.length) {
            let inputDate = input.value;
            let start = input.selectionStart - 1;
            let end = input.selectionEnd - 1;
            let indexToRemove = input.selectionStart - 1;
            input.value = inputDate.slice(0, indexToRemove) + inputDate.slice(indexToRemove + 1);
            input.setSelectionRange(start, end);
        }
    }
    onChangeEvent($event) {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
        switch (attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                this.formatAlphaUnicode(control);
                break;
            case StorageAttribute.BOOLEAN:
                this.formatBoolean(control);
                break;
        }
    }
    calculatePattern() {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        if (control != null) {
            let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
            if (attr == StorageAttribute.NUMERIC || attr == StorageAttribute.ALPHA || attr == StorageAttribute.UNICODE) {
                let pic = this._task.GetControlPictureMask(this.magicDir.id);
                if (this.isPatternGenerationNeeded(attr, pic)) {
                    let pattern = this.generatePattern(attr, pic);
                    if (control.validator == null)
                        control.setValidators(Validators.pattern(pattern));
                    else
                        control.setValidators([control.validator, Validators.pattern(pattern)]);
                }
                else {
                    if (attr == StorageAttribute.ALPHA || attr == StorageAttribute.UNICODE) {
                        if (control.validator == null)
                            control.setValidators(Validators.maxLength(pic.getMaskLength()));
                        else {
                            if (pic.isFormatExp()) {
                                control.setValidators(Validators.maxLength(pic.getMaskLength()));
                                if (isUndefined(this.magicDir.rowId))
                                    this.magicDir.rowId = '0';
                                control.setValidators([control.validator, this._task.customValidator(this.magicDir.rowId, this.magicDir.id)]);
                            }
                            else
                                control.setValidators([control.validator, Validators.maxLength(pic.getMaskLength())]);
                        }
                        control.updateValueAndValidity();
                    }
                }
            }
        }
    }
    formatDate(pic) {
        let mgDateFormatter = new MgDateFormatter();
        this._task.mgInputDateFormat = mgDateFormatter.ConvertMgDateFormatToAngular(pic.getMask());
    }
    formatAlphaUnicode(control) {
        let value = control.value;
        if (value !== null && value.length > 0) {
            const newValue = this._task.GetRangedValue(this.magicDir.id, value);
            if (newValue != null)
                value = newValue;
            let pic = this._task.GetControlPictureMask(this.magicDir.id);
            let mask = pic.getMask();
            let valueStr = new StringBuilder();
            for (let i = 0; i < value.length; i++) {
                switch (mask.charCodeAt(i)) {
                    case PICInterface.PIC_U:
                        valueStr.Append(value.charAt(i).toUpperCase());
                        break;
                    case PICInterface.PIC_L:
                        valueStr.Append(value.charAt(i).toLowerCase());
                        break;
                    default:
                        valueStr.Append(value.charAt(i));
                        break;
                }
            }
            control.setValue(valueStr.ToString());
        }
    }
    formatBoolean(control) {
        let value = control.value;
        if (value !== null && value.length > 0) {
            let newValue = this._task.GetRangedValue(this.magicDir.id, value);
            if (newValue.toUpperCase().startsWith(value.toUpperCase())) {
                control.setValue(newValue);
            }
            else {
                control.setValue(value);
            }
        }
    }
    generatePattern(attribute, pic) {
        let pattern = '';
        switch (attribute) {
            case StorageAttribute.NUMERIC:
                pattern = this.generatePatternForNumber(pic);
                break;
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                pattern = this.generatePatternForAlpha(pic);
                break;
        }
        return pattern;
    }
    generatePatternForNumber(pic) {
        let patternStr = new StringBuilder();
        patternStr.Append('^');
        if (pic.isNegative())
            patternStr.Append('-?');
        if (pic.getWholes())
            patternStr.AppendFormat('\\d{{0},{1}}', 0, pic.getWholes());
        if (pic.getDec())
            patternStr.AppendFormat('(\\.\\d{1,{0}})?', pic.getDec());
        patternStr.Append('$');
        return patternStr.ToString();
    }
    isPatternGenerationNeeded(attr, pic) {
        switch (attr) {
            case StorageAttribute.NUMERIC:
                return true;
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                return (pic.getMaskChars() > 0) ? true : false;
        }
    }
    generatePatternForAlpha(pic) {
        let cnt = 0;
        let inputAllChars = false;
        let closeSet = false;
        let mask = pic.getMask();
        let pattern = new StringBuilder();
        pattern.Append('^');
        for (let i = 0; i < mask.length;) {
            if (inputAllChars && (mask.charCodeAt(i) == PICInterface.PIC_N || mask.charCodeAt(i) == PICInterface.PIC_U || mask.charCodeAt(i) == PICInterface.PIC_L
                || mask.charCodeAt(i) == PICInterface.PIC_X)) {
                pattern.Append('(');
                closeSet = true;
                inputAllChars = false;
            }
            cnt = 0;
            switch (mask.charCodeAt(i)) {
                case PICInterface.PIC_U:
                case PICInterface.PIC_X:
                case PICInterface.PIC_L:
                    {
                        pattern.Append('.');
                        let inputAllCharsRef = new RefParam(false);
                        let dirs = PICInterface.PIC_U.toString();
                        dirs += PICInterface.PIC_L.toString();
                        dirs += PICInterface.PIC_X.toString();
                        cnt = this.getDirectiveCount(mask, i, dirs, inputAllCharsRef);
                        inputAllChars = inputAllCharsRef.value;
                        i += cnt;
                    }
                    break;
                case PICInterface.PIC_N:
                    {
                        pattern.Append('\\d');
                        let inputAllCharsRef = new RefParam(false);
                        cnt = this.getDirectiveCount(mask, i, PICInterface.PIC_L.toString(), inputAllCharsRef);
                        inputAllChars = inputAllCharsRef.value;
                        i += cnt;
                    }
                    break;
                default:
                    pattern.Append(mask[i]);
                    i++;
                    break;
            }
            if (cnt > 0)
                pattern.AppendFormat('{{0},{1}}', inputAllChars ? cnt : 0, cnt);
            if (closeSet)
                pattern.Append(')');
            closeSet = false;
        }
        pattern.Append('$');
        return pattern.ToString();
    }
    getDirectiveCount(mask, idx, pattern, changeInPattern) {
        changeInPattern.value = false;
        let patternCount = 0;
        while (idx < mask.length && this.IsPatternMatches(mask.charCodeAt(idx).toString(), pattern)) {
            patternCount++;
            idx++;
        }
        if (idx < mask.length)
            changeInPattern.value = true;
        return patternCount;
    }
    IsPatternMatches(mask, pattern) {
        for (let i = 0; i < pattern.length; i++)
            if (mask == pattern[i])
                return true;
        return false;
    }
}
MgformatMagicDirective.ɵfac = function MgformatMagicDirective_Factory(t) { return new (t || MgformatMagicDirective)(i0.ɵɵdirectiveInject(i1.MagicDirective), i0.ɵɵdirectiveInject(i2.TaskMagicService)); };
MgformatMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: MgformatMagicDirective, selectors: [["", "mgFormat", ""]], hostBindings: function MgformatMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("focus", function MgformatMagicDirective_focus_HostBindingHandler($event) { return ctx.onFocusEvent($event); })("paste", function MgformatMagicDirective_paste_HostBindingHandler($event) { return ctx.onPaste($event); })("input", function MgformatMagicDirective_input_HostBindingHandler($event) { return ctx.onInputEvent($event); })("change", function MgformatMagicDirective_change_HostBindingHandler($event) { return ctx.onChangeEvent($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgformatMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[mgFormat]'
            }]
    }], function () { return [{ type: i1.MagicDirective }, { type: i2.TaskMagicService }]; }, { onFocusEvent: [{
            type: HostListener,
            args: ['focus', ['$event']]
        }], onPaste: [{
            type: HostListener,
            args: ['paste', ['$event']]
        }], onInputEvent: [{
            type: HostListener,
            args: ['input', ['$event']]
        }], onChangeEvent: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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