import { Directive, ViewContainerRef } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
import { TaskMagicService } from '../../services/task.magics.service';
import * as i0 from "@angular/core";
import * as i1 from "../../services/task.magics.service";
export class RangeValidatorMagicDirective {
    constructor(_task, vcRef) {
        this._task = _task;
        this.vcRef = vcRef;
    }
    validate(c) {
        let controlName;
        controlName = this.getControlName(c);
        let properties;
        properties = this._task.Records.list["0"].getControlMetadata(controlName);
        properties.rangeValidator = true;
        let errMsg = null;
        if (c.dirty)
            errMsg = this._task.ValidateControlValue(controlName, this._task.ConvertValToNative(controlName, 0, c.value));
        let isValid = (errMsg == null) ? true : false;
        if (isValid) {
            return null;
        }
        else {
            return {
                rangevalidator: {
                    errorMsg: errMsg
                }
            };
        }
    }
    getControlName(c) {
        const formGroup = c.parent.controls;
        return Object.keys(formGroup).find(name => c === formGroup[name]) || null;
    }
}
RangeValidatorMagicDirective.ɵfac = function RangeValidatorMagicDirective_Factory(t) { return new (t || RangeValidatorMagicDirective)(i0.ɵɵdirectiveInject(i1.TaskMagicService), i0.ɵɵdirectiveInject(i0.ViewContainerRef)); };
RangeValidatorMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: RangeValidatorMagicDirective, selectors: [["", "rangevalidator", ""]], features: [i0.ɵɵProvidersFeature([
            {
                provide: NG_VALIDATORS,
                useExisting: RangeValidatorMagicDirective,
                multi: true,
            }
        ])] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RangeValidatorMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[rangevalidator] ',
                providers: [
                    {
                        provide: NG_VALIDATORS,
                        useExisting: RangeValidatorMagicDirective,
                        multi: true,
                    }
                ]
            }]
    }], function () { return [{ type: i1.TaskMagicService }, { type: i0.ViewContainerRef }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmFuZ2UtdmFsaWRhdG9yLm1hZ2ljLmRpcmVjdGl2ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2FuZ3VsYXIvc3JjL3VpL2RpcmVjdGl2ZXMvcmFuZ2UtdmFsaWRhdG9yLm1hZ2ljLmRpcmVjdGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzVELE9BQU8sRUFBZSxhQUFhLEVBQWEsTUFBTSxnQkFBZ0IsQ0FBQztBQUN2RSxPQUFPLEVBQUUsZ0JBQWdCLEVBQUUsTUFBTSxvQ0FBb0MsQ0FBQzs7O0FBbUJ0RSxNQUFNLE9BQU8sNEJBQTRCO0lBT3ZDLFlBQXNCLEtBQXVCLEVBQWEsS0FBdUI7UUFBM0QsVUFBSyxHQUFMLEtBQUssQ0FBa0I7UUFBYSxVQUFLLEdBQUwsS0FBSyxDQUFrQjtJQUNqRixDQUFDO0lBT0EsUUFBUSxDQUFDLENBQWM7UUFDbkIsSUFBSSxXQUFtQixDQUFDO1FBQ3hCLFdBQVcsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3RDLElBQUksVUFBMkIsQ0FBQztRQUNoQyxVQUFVLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzFFLFVBQVUsQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDO1FBQ2pDLElBQUksTUFBTSxHQUFXLElBQUksQ0FBQztRQUMxQixJQUFJLENBQUMsQ0FBQyxLQUFLO1lBQ1YsTUFBTSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUUsV0FBVyxFQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsV0FBVyxFQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUNsSCxJQUFJLE9BQU8sR0FBWSxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUM7UUFDdkQsSUFBSSxPQUFPLEVBQUU7WUFDWCxPQUFPLElBQUksQ0FBQztTQUNiO2FBQ0k7WUFDSCxPQUFPO2dCQUNMLGNBQWMsRUFBRTtvQkFDZCxRQUFRLEVBQUcsTUFBTTtpQkFDbEI7YUFDRixDQUFDO1NBQ0g7SUFDTCxDQUFDO0lBS0YsY0FBYyxDQUFDLENBQWM7UUFDM0IsTUFBTSxTQUFTLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDcEMsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUM7SUFDNUUsQ0FBQzs7d0dBM0NVLDRCQUE0QjtpRUFBNUIsNEJBQTRCLDRFQVg1QjtZQUNUO2dCQUNFLE9BQU8sRUFBRSxhQUFhO2dCQUN0QixXQUFXLEVBQUUsNEJBQTRCO2dCQUV6QyxLQUFLLEVBQUUsSUFBSTthQUVaO1NBQ0Y7dUZBR1UsNEJBQTRCO2NBYnhDLFNBQVM7ZUFBQztnQkFDVCxRQUFRLEVBQUUsbUJBQW1CO2dCQUM3QixTQUFTLEVBQUU7b0JBQ1Q7d0JBQ0UsT0FBTyxFQUFFLGFBQWE7d0JBQ3RCLFdBQVcsOEJBQThCO3dCQUV6QyxLQUFLLEVBQUUsSUFBSTtxQkFFWjtpQkFDRjthQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGlyZWN0aXZlLCBWaWV3Q29udGFpbmVyUmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IEZvcm1Db250cm9sLCBOR19WQUxJREFUT1JTLCBWYWxpZGF0b3IgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XHJcbmltcG9ydCB7IFRhc2tNYWdpY1NlcnZpY2UgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy90YXNrLm1hZ2ljcy5zZXJ2aWNlJztcclxuaW1wb3J0IHsgQ29udHJvbE1ldGFkYXRhIH0gZnJvbSAnLi4vLi4vY29udHJvbHMubWV0YWRhdGEubW9kZWwnO1xyXG5cclxuLyoqXHJcbiAqIFZhbGlkYXRlcyB0aGUgZmllbGQgcmFuZ2UuXHJcbiAqL1xyXG5ARGlyZWN0aXZlKHtcclxuICBzZWxlY3RvcjogJ1tyYW5nZXZhbGlkYXRvcl0gJyxcclxuICBwcm92aWRlcnM6IFtcclxuICAgIHtcclxuICAgICAgcHJvdmlkZTogTkdfVkFMSURBVE9SUyxcclxuICAgICAgdXNlRXhpc3Rpbmc6IFJhbmdlVmFsaWRhdG9yTWFnaWNEaXJlY3RpdmUsXHJcblxyXG4gICAgICBtdWx0aTogdHJ1ZSxcclxuXHJcbiAgICB9XHJcbiAgXVxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIFJhbmdlVmFsaWRhdG9yTWFnaWNEaXJlY3RpdmUgaW1wbGVtZW50cyBWYWxpZGF0b3Ige1xyXG5cclxuICAvKipcclxuICAgKlxyXG4gICAqIEBwYXJhbSBfdGFzayBUaGUgdGFzayBzZXJ2aWNlXHJcbiAgICogQHBhcmFtIHZjUmVmXHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIF90YXNrOiBUYXNrTWFnaWNTZXJ2aWNlLCAgcHJvdGVjdGVkIHZjUmVmOiBWaWV3Q29udGFpbmVyUmVmKSB7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBWYWxpZGF0aW9uIG1ldGhvZFxyXG4gICAqIEBwYXJhbSBjIEZvcm1Db250cm9sIHRvIHZhbGlkYXRlXHJcbiAgICogQHJldHVybnMgSWYgdmFsaWRhdGlvbiBmYWlscywgcmV0dXJuIGVycm9yIG1lc3NhZ2UsIGVsc2UgcmV0dXJucyBudWxsXHJcbiAgICovXHJcbiAgIHZhbGlkYXRlKGM6IEZvcm1Db250cm9sKSB7XHJcbiAgICAgICBsZXQgY29udHJvbE5hbWU6IHN0cmluZztcclxuICAgICAgIGNvbnRyb2xOYW1lID0gdGhpcy5nZXRDb250cm9sTmFtZSAoYyk7XHJcbiAgICAgICBsZXQgcHJvcGVydGllczogQ29udHJvbE1ldGFkYXRhO1xyXG4gICAgICAgcHJvcGVydGllcyA9IHRoaXMuX3Rhc2suUmVjb3Jkcy5saXN0W1wiMFwiXS5nZXRDb250cm9sTWV0YWRhdGEoY29udHJvbE5hbWUpO1xyXG4gICAgICAgcHJvcGVydGllcy5yYW5nZVZhbGlkYXRvciA9IHRydWU7XHJcbiAgICAgICBsZXQgZXJyTXNnOiBzdHJpbmcgPSBudWxsO1xyXG4gICAgICAgaWYgKGMuZGlydHkpXHJcbiAgICAgICAgZXJyTXNnID0gdGhpcy5fdGFzay5WYWxpZGF0ZUNvbnRyb2xWYWx1ZSAoY29udHJvbE5hbWUsICB0aGlzLl90YXNrLkNvbnZlcnRWYWxUb05hdGl2ZShjb250cm9sTmFtZSwgIDAsIGMudmFsdWUpKTtcclxuICAgICAgIGxldCBpc1ZhbGlkOiBib29sZWFuID0gKGVyck1zZyA9PSBudWxsKSA/IHRydWUgOiBmYWxzZTtcclxuICAgICAgIGlmIChpc1ZhbGlkKSB7XHJcbiAgICAgICAgIHJldHVybiBudWxsO1xyXG4gICAgICAgfVxyXG4gICAgICAgZWxzZSB7XHJcbiAgICAgICAgIHJldHVybiB7XHJcbiAgICAgICAgICAgcmFuZ2V2YWxpZGF0b3I6IHtcclxuICAgICAgICAgICAgIGVycm9yTXNnIDogZXJyTXNnXHJcbiAgICAgICAgICAgfVxyXG4gICAgICAgICB9O1xyXG4gICAgICAgfVxyXG4gICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEBpZ25vcmVcclxuICAgKi9cclxuICBnZXRDb250cm9sTmFtZShjOiBGb3JtQ29udHJvbCk6IHN0cmluZyB8IG51bGwge1xyXG4gICAgY29uc3QgZm9ybUdyb3VwID0gYy5wYXJlbnQuY29udHJvbHM7XHJcbiAgICByZXR1cm4gT2JqZWN0LmtleXMoZm9ybUdyb3VwKS5maW5kKG5hbWUgPT4gYyA9PT0gZm9ybUdyb3VwW25hbWVdKSB8fCBudWxsO1xyXG4gIH1cclxufVxyXG4iXX0=